/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

final class SelectFrom8Directions2DFunc
implements Func {
    private static final double COS_PI_DIV_8 = StrictMath.cos(0.39269908169872414);
    private static final double SIN_PI_DIV_8 = StrictMath.sin(0.39269908169872414);

    SelectFrom8Directions2DFunc() {
    }

    @Override
    public double get(double ... x) {
        double dx = COS_PI_DIV_8 * x[0] - SIN_PI_DIV_8 * x[1];
        double dy = SIN_PI_DIV_8 * x[0] + COS_PI_DIV_8 * x[1];
        if (dy >= 0.0) {
            return dx >= dy ? 0.0 : (dx >= 0.0 ? 1.0 : (dx >= -dy ? 2.0 : 3.0));
        }
        return dx <= dy ? 4.0 : (dx <= 0.0 ? 5.0 : (dx <= -dy ? 6.0 : 7.0));
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 2 arguments required");
    }

    @Override
    public double get(double x0) {
        throw new IndexOutOfBoundsException("At least 2 arguments required");
    }

    @Override
    public double get(double x0, double x1) {
        double dx = COS_PI_DIV_8 * x0 - SIN_PI_DIV_8 * x1;
        double dy = SIN_PI_DIV_8 * x0 + COS_PI_DIV_8 * x1;
        if (dy >= 0.0) {
            return dx >= dy ? 0.0 : (dx >= 0.0 ? 1.0 : (dx >= -dy ? 2.0 : 3.0));
        }
        return dx <= dy ? 4.0 : (dx <= 0.0 ? 5.0 : (dx <= -dy ? 6.0 : 7.0));
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.get(x0, x1);
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.get(x0, x1);
    }

    public String toString() {
        return "select from 8 directions in 2D plane f(x,y)=0..7 (depending on x, y)";
    }
}

