/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.geometry;

import java.util.Objects;
import java.util.random.RandomGenerator;
import net.algart.math.geometry.Orthonormal3DBasis;

public final class StraightLine3D
implements Cloneable {
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double z0 = 0.0;
    private double dx = 1.0;
    private double dy = 0.0;
    private double dz = 0.0;

    private StraightLine3D() {
    }

    public static StraightLine3D newLine() {
        return new StraightLine3D();
    }

    public static StraightLine3D newLineThroughOrigin(double dx, double dy, double dz) {
        return new StraightLine3D().setDirection(dx, dy, dz);
    }

    public static StraightLine3D newLine(double x0, double y0, double z0, double dx, double dy, double dz) {
        return new StraightLine3D().setStart(x0, y0, z0).setDirection(dx, dy, dz);
    }

    public static StraightLine3D newLineAlongI(double x0, double y0, double z0, Orthonormal3DBasis basis) {
        return new StraightLine3D().setStart(x0, y0, z0).setDirectionAlongI(basis);
    }

    public static StraightLine3D newLineAlongJ(double x0, double y0, double z0, Orthonormal3DBasis basis) {
        return new StraightLine3D().setStart(x0, y0, z0).setDirectionAlongJ(basis);
    }

    public static StraightLine3D newLineAlongK(double x0, double y0, double z0, Orthonormal3DBasis basis) {
        return new StraightLine3D().setStart(x0, y0, z0).setDirectionAlongK(basis);
    }

    public double x0() {
        return this.x0;
    }

    public StraightLine3D x0(double x0) {
        this.x0 = x0;
        return this;
    }

    public double y0() {
        return this.y0;
    }

    public StraightLine3D y0(double y0) {
        this.y0 = y0;
        return this;
    }

    public double z0() {
        return this.z0;
    }

    public StraightLine3D z0(double z0) {
        this.z0 = z0;
        return this;
    }

    public StraightLine3D setStart(double x0, double y0, double z0) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        return this;
    }

    public double dx() {
        return this.dx;
    }

    public double dy() {
        return this.dy;
    }

    public double dz() {
        return this.dz;
    }

    public StraightLine3D setDirection(double dx, double dy, double dz) {
        double length = Orthonormal3DBasis.length(dx, dy, dz);
        if (length < 1.0E-100) {
            throw new IllegalArgumentException("Zero or too short direction vector (" + dx + ", " + dy + ", " + dz + ") (vectors with length <1.0E-100 are not allowed)");
        }
        double mult = 1.0 / length;
        this.setDirectionComponents(dx * mult, dy * mult, dz * mult);
        return this;
    }

    public StraightLine3D shiftAlong(double shift) {
        this.x0 += shift * this.dx;
        this.y0 += shift * this.dy;
        this.z0 += shift * this.dz;
        return this;
    }

    public StraightLine3D setDirectionAlongI(Orthonormal3DBasis basis) {
        Objects.requireNonNull(basis, "Null basis");
        return this.setDirection(basis.ix(), basis.iy(), basis.iz());
    }

    public StraightLine3D setDirectionAlongJ(Orthonormal3DBasis basis) {
        Objects.requireNonNull(basis, "Null basis");
        return this.setDirection(basis.jx(), basis.jy(), basis.jz());
    }

    public StraightLine3D setDirectionAlongK(Orthonormal3DBasis basis) {
        Objects.requireNonNull(basis, "Null basis");
        return this.setDirection(basis.kx(), basis.ky(), basis.kz());
    }

    public StraightLine3D setDirectionAlongX() {
        return this.setDirection(1.0, 0.0, 0.0);
    }

    public StraightLine3D setDirectionAlongY() {
        return this.setDirection(0.0, 1.0, 0.0);
    }

    public StraightLine3D setDirectionAlongZ() {
        return this.setDirection(0.0, 0.0, 1.0);
    }

    public StraightLine3D setRandomDirection(RandomGenerator random) {
        double dz;
        double dy;
        double dx;
        double distanceSqr;
        while (!((distanceSqr = (dx = 2.0 * random.nextDouble() - 1.0) * dx + (dy = 2.0 * random.nextDouble() - 1.0) * dy + (dz = 2.0 * random.nextDouble() - 1.0) * dz) >= 0.01) || !(distanceSqr < 1.0)) {
        }
        return this.setDirection(dx, dy, dz);
    }

    public StraightLine3D setTo(StraightLine3D other) {
        Objects.requireNonNull(other, "Null other");
        this.x0 = other.x0;
        this.y0 = other.y0;
        this.z0 = other.z0;
        this.dx = other.dx;
        this.dy = other.dy;
        this.dz = other.dz;
        return this;
    }

    public double x(double t) {
        return this.x0 + t * this.dx;
    }

    public double y(double t) {
        return this.y0 + t * this.dy;
    }

    public double z(double t) {
        return this.z0 + t * this.dz;
    }

    public double vectorProjection(double ax, double ay, double az) {
        return ax * this.dx + ay * this.dy + az * this.dz;
    }

    public double pointProjection(double x, double y, double z) {
        return (x - this.x0) * this.dx + (y - this.y0) * this.dy + (z - this.z0) * this.dz;
    }

    public double distanceToStartPointSquare(double x, double y, double z) {
        return Orthonormal3DBasis.lengthSquare(x - this.x0, y - this.y0, z - this.z0);
    }

    public double distanceToStartPoint(double x, double y, double z) {
        return Math.sqrt(this.distanceToStartPointSquare(x, y, z));
    }

    public double distanceToStraightSquare(double x, double y, double z) {
        return StraightLine3D.distanceToStraightSquare(this.dx, this.dy, this.dz, x - this.x0, y - this.y0, z - this.z0);
    }

    public double distanceToStraight(double x, double y, double z) {
        return Math.sqrt(this.distanceToStraightSquare(x, y, z));
    }

    public String toString() {
        return "straight (" + this.x0 + "," + this.y0 + "," + this.z0 + ")+t*(" + this.dx + "," + this.dy + "," + this.dz + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof StraightLine3D)) {
            return false;
        }
        StraightLine3D that = (StraightLine3D)o;
        return Double.doubleToLongBits(that.x0) == Double.doubleToLongBits(this.x0) && Double.doubleToLongBits(that.y0) == Double.doubleToLongBits(this.y0) && Double.doubleToLongBits(that.z0) == Double.doubleToLongBits(this.z0) && Double.doubleToLongBits(that.dx) == Double.doubleToLongBits(this.dx) && Double.doubleToLongBits(that.dy) == Double.doubleToLongBits(this.dy) && Double.doubleToLongBits(that.dz) == Double.doubleToLongBits(this.dz);
    }

    public int hashCode() {
        int result = 0;
        result = 37 * result + Double.hashCode(this.x0);
        result = 37 * result + Double.hashCode(this.y0);
        result = 37 * result + Double.hashCode(this.z0);
        result = 37 * result + Double.hashCode(this.dx);
        result = 37 * result + Double.hashCode(this.dy);
        result = 37 * result + Double.hashCode(this.dz);
        return result;
    }

    public StraightLine3D clone() {
        try {
            return (StraightLine3D)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static double distanceToStraightSquare(double dx, double dy, double dz, double x, double y, double z) {
        double t = x * dx + y * dy + z * dz;
        return Orthonormal3DBasis.lengthSquare(x - t * dx, y - t * dy, z - t * dz);
    }

    public static double distanceToStraight(double dx, double dy, double dz, double x, double y, double z) {
        return Math.sqrt(StraightLine3D.distanceToStraightSquare(dx, dy, dz, x, y, z));
    }

    private void setDirectionComponents(double dx, double dy, double dz) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }
}

