/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.Point;
import net.algart.math.patterns.AbstractUniformGridPattern;
import net.algart.math.patterns.DirectPointSetUniformGridPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.SimplePattern;

class BasicDirectPointSetUniformGridPattern
extends AbstractUniformGridPattern
implements DirectPointSetUniformGridPattern {
    private final Set<IPoint> gridIndexes;

    BasicDirectPointSetUniformGridPattern(int dimCount, Set<IPoint> gridIndexes) {
        this(Point.origin(dimCount), Point.ofEqualCoordinates(dimCount, 1.0).coordinates(), gridIndexes);
    }

    BasicDirectPointSetUniformGridPattern(Point originOfGrid, double[] stepsOfGrid, Set<IPoint> gridIndexes) {
        super(originOfGrid, stepsOfGrid, false);
        Objects.requireNonNull(gridIndexes, "Null gridIndexes argument");
        int n = gridIndexes.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty points set");
        }
        long[] minIndex = new long[this.dimCount];
        long[] maxIndex = new long[this.dimCount];
        Arrays.fill(minIndex, Long.MAX_VALUE);
        Arrays.fill(maxIndex, Long.MIN_VALUE);
        for (IPoint p : gridIndexes) {
            Objects.requireNonNull(p, "Null point is the collection");
            if (p.coordCount() != originOfGrid.coordCount()) {
                throw new IllegalArgumentException("Points dimensions mismatch: the origin of grid has " + originOfGrid.coordCount() + " coordinates, but some of points has " + p.coordCount());
            }
            BasicDirectPointSetUniformGridPattern.checkGridIndex(p);
            BasicDirectPointSetUniformGridPattern.checkPoint(p.scaleAndShift(stepsOfGrid, originOfGrid));
            for (int k = 0; k < this.dimCount; ++k) {
                long coordinate = p.coord(k);
                if (coordinate < minIndex[k]) {
                    minIndex[k] = coordinate;
                }
                if (coordinate <= maxIndex[k]) continue;
                maxIndex[k] = coordinate;
            }
        }
        this.gridIndexes = gridIndexes;
        for (int k = 0; k < this.dimCount; ++k) {
            this.gridIndexRanges[k] = IRange.of(minIndex[k], maxIndex[k]);
            BasicDirectPointSetUniformGridPattern.checkGridIndexRange(this.gridIndexRanges[k]);
            BasicDirectPointSetUniformGridPattern.checkCoordRange(this.coordRange(k, this.gridIndexRanges[k]));
        }
    }

    @Override
    public Set<IPoint> gridIndexes() {
        return Collections.unmodifiableSet(this.gridIndexes);
    }

    @Override
    public IRange gridIndexRange(int coordIndex) {
        return this.gridIndexRanges[coordIndex];
    }

    @Override
    public DirectPointSetUniformGridPattern gridIndexPattern() {
        return this.zeroOriginOfGrid && this.unitStepsOfGrid ? this : new BasicDirectPointSetUniformGridPattern(this.dimCount, this.gridIndexes);
    }

    @Override
    public DirectPointSetUniformGridPattern shiftGridIndexes(IPoint shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        HashSet<IPoint> resultIndexes = new HashSet<IPoint>(this.gridIndexes.size());
        for (IPoint p : this.gridIndexes) {
            resultIndexes.add(p.add(shift));
        }
        return new BasicDirectPointSetUniformGridPattern(this.originOfGrid, this.stepsOfGrid, resultIndexes);
    }

    @Override
    public long pointCount() {
        return this.gridIndexes.size();
    }

    @Override
    public boolean isSurelySinglePoint() {
        return this.gridIndexes.size() == 1;
    }

    @Override
    public DirectPointSetUniformGridPattern shift(Point shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        return new BasicDirectPointSetUniformGridPattern(this.originOfGrid.add(shift), this.stepsOfGrid, this.gridIndexes);
    }

    @Override
    public DirectPointSetUniformGridPattern symmetric() {
        return (DirectPointSetUniformGridPattern)super.symmetric();
    }

    @Override
    public DirectPointSetUniformGridPattern multiply(double multiplier) {
        return (DirectPointSetUniformGridPattern)super.multiply(multiplier);
    }

    @Override
    public DirectPointSetUniformGridPattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        multipliers = (double[])multipliers.clone();
        double[] positiveMultipliers = (double[])multipliers.clone();
        Set<IPoint> newIndexes = this.gridIndexes;
        boolean allPositive = true;
        boolean allUnit = true;
        for (double m : multipliers) {
            allPositive &= m > 0.0;
            allUnit &= m == 1.0;
        }
        if (allUnit) {
            return this;
        }
        if (!allPositive) {
            for (int k = 0; k < multipliers.length; ++k) {
                positiveMultipliers[k] = multipliers[k] < 0.0 ? -multipliers[k] : (multipliers[k] == 0.0 ? 1.0 : multipliers[k]);
            }
            newIndexes = new HashSet<IPoint>(this.gridIndexes.size());
            long[] coordinates = new long[this.dimCount];
            for (IPoint p : this.gridIndexes) {
                p.coordinates(coordinates);
                for (int k = 0; k < multipliers.length; ++k) {
                    if (multipliers[k] < 0.0) {
                        coordinates[k] = -coordinates[k];
                        continue;
                    }
                    if (multipliers[k] != 0.0) continue;
                    coordinates[k] = 0L;
                }
                newIndexes.add(IPoint.of(coordinates));
            }
        }
        return new BasicDirectPointSetUniformGridPattern(this.zeroOriginOfGrid ? this.originOfGrid : this.originOfGrid.scale(multipliers), this.unitStepsOfGrid ? positiveMultipliers : this.stepsVector.scale(positiveMultipliers).coordinates(), newIndexes);
    }

    @Override
    public DirectPointSetUniformGridPattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        HashSet<IPoint> resultIndexes = new HashSet<IPoint>(this.gridIndexes.size());
        for (IPoint p : this.gridIndexes) {
            resultIndexes.add(p.projectionAlongAxis(coordIndex));
        }
        return new BasicDirectPointSetUniformGridPattern(this.originOfGrid.projectionAlongAxis(coordIndex), this.stepsVector.projectionAlongAxis(coordIndex).coordinates(), resultIndexes);
    }

    @Override
    public DirectPointSetUniformGridPattern minBound(int coordIndex) {
        return (DirectPointSetUniformGridPattern)super.minBound(coordIndex);
    }

    @Override
    public DirectPointSetUniformGridPattern maxBound(int coordIndex) {
        return (DirectPointSetUniformGridPattern)super.maxBound(coordIndex);
    }

    @Override
    public DirectPointSetUniformGridPattern lowerSurface(int coordIndex) {
        return (DirectPointSetUniformGridPattern)super.lowerSurface(coordIndex);
    }

    @Override
    public DirectPointSetUniformGridPattern upperSurface(int coordIndex) {
        return (DirectPointSetUniformGridPattern)super.upperSurface(coordIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.dimCount + "D multipoint uniform-grid (" + this.gridToString() + ") pattern containing " + this.gridIndexes.size() + " points");
        if (this.pointCount() <= 5L) {
            sb.append(" ").append(this.points());
        }
        if (this.pointCount() <= 1024L) {
            sb.append(" inside ").append(this.coordArea());
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.points().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Pattern && SimplePattern.simplePatternsEqual(this, (Pattern)obj);
    }
}

