/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.List;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.patterns.UniformGridPattern;

public interface Pattern {
    public static final long MAX_COORDINATE = 0x10000000000000L;

    public int dimCount();

    public long pointCount();

    public double largePointCount();

    public Set<Point> points();

    public Set<IPoint> roundedPoints();

    public Range coordRange(int var1);

    public RectangularArea coordArea();

    public Point coordMin();

    public Point coordMax();

    public IRange roundedCoordRange(int var1);

    public IRectangularArea roundedCoordArea();

    public boolean isSurelySinglePoint();

    public boolean isSurelyOriginPoint();

    public boolean isSurelyInteger();

    public UniformGridPattern round();

    public Pattern shift(Point var1);

    public Pattern symmetric();

    public Pattern multiply(double var1);

    public Pattern scale(double ... var1);

    public Pattern projectionAlongAxis(int var1);

    public Pattern minBound(int var1);

    public Pattern maxBound(int var1);

    public Pattern carcass();

    public int maxCarcassMultiplier();

    public Pattern minkowskiAdd(Pattern var1);

    public Pattern minkowskiSubtract(Pattern var1);

    public List<Pattern> minkowskiDecomposition(int var1);

    public boolean hasMinkowskiDecomposition();

    public List<Pattern> unionDecomposition(int var1);

    public List<List<Pattern>> allUnionDecompositions(int var1);
}

