/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import java.util.function.IntConsumer;
import net.algart.math.rectangles.IRectangleFinder;

class IRectangleFinderWithoutOptimization
extends IRectangleFinder {
    IRectangleFinderWithoutOptimization() {
    }

    @Override
    public IRectangleFinderWithoutOptimization compact() {
        return this;
    }

    @Override
    public void findContaining(int x, int y, IntConsumer indexConsumer) {
        for (int k = 0; k < this.n; ++k) {
            if (this.minX(k) > x || this.maxX(k) < x || this.minY(k) > y || this.maxY(k) < y || !this.indexActual(k)) continue;
            indexConsumer.accept(k);
        }
    }

    @Override
    public void findContaining(double x, double y, IntConsumer indexConsumer) {
        for (int k = 0; k < this.n; ++k) {
            if (!((double)this.minX(k) <= x) || !((double)this.maxX(k) >= x) || !((double)this.minY(k) <= y) || !((double)this.maxY(k) >= y) || !this.indexActual(k)) continue;
            indexConsumer.accept(k);
        }
    }

    @Override
    public void findIntersecting(int minX, int maxX, int minY, int maxY, IntConsumer indexConsumer) {
        if (minX > maxX || minY > maxY) {
            return;
        }
        for (int k = 0; k < this.n; ++k) {
            if (this.minX(k) > maxX || this.maxX(k) < minX || this.minY(k) > maxY || this.maxY(k) < minY || !this.indexActual(k)) continue;
            indexConsumer.accept(k);
        }
    }

    @Override
    public String toString() {
        return "unoptimized integer rectangles finder for " + this.n + " rectangles";
    }

    @Override
    protected void setRanges() {
    }
}

