/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.filters3x3.AbstractQuickFilter3x3;

public abstract class AverageBySquare3x3
extends AbstractQuickFilter3x3 {
    private AverageBySquare3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions);
    }

    public static AverageBySquare3x3 newInstance(Class<?> elementType, long dimX, long dimY) {
        return AverageBySquare3x3.newInstance(elementType, new long[]{dimX, dimY});
    }

    public static AverageBySquare3x3 newInstance(Class<?> elementType, long[] dimensions) {
        return AverageBySquare3x3.newInstance(elementType, dimensions, true);
    }

    public static AverageBySquare3x3 newInstance(Class<?> elementType, long[] dimensions, boolean rounding) {
        if (elementType == Character.TYPE) {
            return rounding ? new ForChar.Rounding(dimensions) : new ForChar(dimensions);
        }
        if (elementType == Boolean.TYPE) {
            return rounding ? new ForBit.Rounding(dimensions) : new ForBit(dimensions);
        }
        if (elementType == Byte.TYPE) {
            return rounding ? new ForByte.Rounding(dimensions) : new ForByte(dimensions);
        }
        if (elementType == Short.TYPE) {
            return rounding ? new ForShort.Rounding(dimensions) : new ForShort(dimensions);
        }
        if (elementType == Integer.TYPE) {
            return rounding ? new ForInt.Rounding(dimensions) : new ForInt(dimensions);
        }
        if (elementType == Long.TYPE) {
            return rounding ? new ForLong.Rounding(dimensions) : new ForLong(dimensions);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    public static Matrix<UpdatablePArray> apply(Matrix<? extends PArray> source) {
        Objects.requireNonNull(source, "Null source matrix");
        return AverageBySquare3x3.newInstance(source.elementType(), source.dimensions()).filter(source);
    }

    private static class ForChar
    extends AverageBySquare3x3 {
        private ForChar(long[] dimensions) {
            super(Character.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            char v0 = source[firstLineOffset + this.dimXm1];
            char v1 = source[firstLineOffset];
            char v2 = source[firstLineOffset + this.rem1ForDimX];
            char v3 = source[middleLineOffset + this.dimXm1];
            char v4 = source[middleLineOffset];
            char v5 = source[middleLineOffset + this.rem1ForDimX];
            char v6 = source[lastLineOffset + this.dimXm1];
            char v7 = source[lastLineOffset];
            char v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (char)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = (char)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (char)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9;
        }

        private static class Rounding
        extends ForChar {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8 + 4) / 9;
            }
        }
    }

    private static class ForBit
    extends AverageBySquare3x3 {
        private ForBit(long[] dimensions) {
            super(Boolean.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            boolean v0 = source[firstLineOffset + this.dimXm1];
            boolean v1 = source[firstLineOffset];
            boolean v2 = source[firstLineOffset + this.rem1ForDimX];
            boolean v3 = source[middleLineOffset + this.dimXm1];
            boolean v4 = source[middleLineOffset];
            boolean v5 = source[middleLineOffset + this.rem1ForDimX];
            boolean v6 = source[lastLineOffset + this.dimXm1];
            boolean v7 = source[lastLineOffset];
            boolean v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        boolean average(boolean v0, boolean v1, boolean v2, boolean v3, boolean v4, boolean v5, boolean v6, boolean v7, boolean v8) {
            return v0 && v1 && v2 && v3 && v4 && v5 && v6 && v7 && v8;
        }

        private static class Rounding
        extends ForBit {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            boolean average(boolean v0, boolean v1, boolean v2, boolean v3, boolean v4, boolean v5, boolean v6, boolean v7, boolean v8) {
                int count;
                int n = count = v0 ? 1 : 0;
                if (v1) {
                    ++count;
                }
                if (v2) {
                    ++count;
                }
                if (v3) {
                    ++count;
                }
                if (v4) {
                    ++count;
                }
                if (v5) {
                    ++count;
                }
                if (v6) {
                    ++count;
                }
                if (v7) {
                    ++count;
                }
                if (v8) {
                    ++count;
                }
                return count > 4;
            }
        }
    }

    private static class ForByte
    extends AverageBySquare3x3 {
        private ForByte(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFF;
            int v1 = source[firstLineOffset] & 0xFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFF;
            int v4 = source[middleLineOffset] & 0xFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFF;
            int v7 = source[lastLineOffset] & 0xFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFF;
            result[resultLineOffset] = (byte)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFF;
                result[++resultLineOffset] = (byte)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFF;
                result[++resultLineOffset] = (byte)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9;
        }

        private static class Rounding
        extends ForByte {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8 + 4) / 9;
            }
        }
    }

    private static class ForShort
    extends AverageBySquare3x3 {
        private ForShort(long[] dimensions) {
            super(Short.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1] & 0xFFFF;
            int v1 = source[firstLineOffset] & 0xFFFF;
            int v2 = source[firstLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v3 = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int v4 = source[middleLineOffset] & 0xFFFF;
            int v5 = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int v6 = source[lastLineOffset + this.dimXm1] & 0xFFFF;
            int v7 = source[lastLineOffset] & 0xFFFF;
            int v8 = source[lastLineOffset + this.rem1ForDimX] & 0xFFFF;
            result[resultLineOffset] = (short)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset] & 0xFFFF;
                result[++resultLineOffset] = (short)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1] & 0xFFFF;
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1] & 0xFFFF;
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1] & 0xFFFF;
                result[++resultLineOffset] = (short)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9;
        }

        private static class Rounding
        extends ForShort {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            int average(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7, int w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8 + 4) / 9;
            }
        }
    }

    private static class ForInt
    extends AverageBySquare3x3 {
        private ForInt(long[] dimensions) {
            super(Integer.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            int v0 = source[firstLineOffset + this.dimXm1];
            int v1 = source[firstLineOffset];
            int v2 = source[firstLineOffset + this.rem1ForDimX];
            int v3 = source[middleLineOffset + this.dimXm1];
            int v4 = source[middleLineOffset];
            int v5 = source[middleLineOffset + this.rem1ForDimX];
            int v6 = source[lastLineOffset + this.dimXm1];
            int v7 = source[lastLineOffset];
            int v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (int)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = (int)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (int)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        long average(long w0, long w1, long w2, long w3, long w4, long w5, long w6, long w7, long w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9L;
        }

        private static class Rounding
        extends ForInt {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            long average(long w0, long w1, long w2, long w3, long w4, long w5, long w6, long w7, long w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8 + 4L) / 9L;
            }
        }
    }

    private static class ForLong
    extends AverageBySquare3x3 {
        private ForLong(long[] dimensions) {
            super(Long.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            long v0 = source[firstLineOffset + this.dimXm1];
            long v1 = source[firstLineOffset];
            long v2 = source[firstLineOffset + this.rem1ForDimX];
            long v3 = source[middleLineOffset + this.dimXm1];
            long v4 = source[middleLineOffset];
            long v5 = source[middleLineOffset + this.rem1ForDimX];
            long v6 = source[lastLineOffset + this.dimXm1];
            long v7 = source[lastLineOffset];
            long v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (long)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = (long)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (long)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9.0;
        }

        private static class Rounding
        extends ForLong {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8 + 4.5) / 9.0;
            }
        }
    }

    private static class ForFloat
    extends AverageBySquare3x3 {
        private ForFloat(long[] dimensions) {
            super(Float.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            float v0 = source[firstLineOffset + this.dimXm1];
            float v1 = source[firstLineOffset];
            float v2 = source[firstLineOffset + this.rem1ForDimX];
            float v3 = source[middleLineOffset + this.dimXm1];
            float v4 = source[middleLineOffset];
            float v5 = source[middleLineOffset + this.rem1ForDimX];
            float v6 = source[lastLineOffset + this.dimXm1];
            float v7 = source[lastLineOffset];
            float v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = (float)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = (float)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = (float)this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9.0;
        }

        private static class Rounding
        extends ForFloat {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9.0;
            }
        }
    }

    private static class ForDouble
    extends AverageBySquare3x3 {
        private ForDouble(long[] dimensions) {
            super(Double.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double v0 = source[firstLineOffset + this.dimXm1];
            double v1 = source[firstLineOffset];
            double v2 = source[firstLineOffset + this.rem1ForDimX];
            double v3 = source[middleLineOffset + this.dimXm1];
            double v4 = source[middleLineOffset];
            double v5 = source[middleLineOffset + this.rem1ForDimX];
            double v6 = source[lastLineOffset + this.dimXm1];
            double v7 = source[lastLineOffset];
            double v8 = source[lastLineOffset + this.rem1ForDimX];
            result[resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            int resultLineOffsetTo = resultLineOffset + this.dimX - 2;
            ++firstLineOffset;
            ++middleLineOffset;
            ++lastLineOffset;
            while (resultLineOffset < resultLineOffsetTo) {
                v0 = v1;
                v1 = v2;
                v2 = source[++firstLineOffset];
                v3 = v4;
                v4 = v5;
                v5 = source[++middleLineOffset];
                v6 = v7;
                v7 = v8;
                v8 = source[++lastLineOffset];
                result[++resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
            if (this.dimX >= 2) {
                v0 = v1;
                v1 = v2;
                v2 = source[firstLineOffset - this.dimXm1];
                v3 = v4;
                v4 = v5;
                v5 = source[middleLineOffset - this.dimXm1];
                v6 = v7;
                v7 = v8;
                v8 = source[lastLineOffset - this.dimXm1];
                result[++resultLineOffset] = this.average(v0, v1, v2, v3, v4, v5, v6, v7, v8);
            }
        }

        double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
            return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9.0;
        }

        private static class Rounding
        extends ForDouble {
            private Rounding(long[] dimensions) {
                super(dimensions);
            }

            @Override
            double average(double w0, double w1, double w2, double w3, double w4, double w5, double w6, double w7, double w8) {
                return (w0 + w1 + w2 + w3 + w4 + w5 + w6 + w7 + w8) / 9.0;
            }
        }
    }
}

