/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;
import net.algart.matrices.linearfiltering.Derivator;

public abstract class AbstractDerivator
extends AbstractArrayProcessorWithContextSwitching
implements Derivator {
    protected final boolean decrementForUnsigned;

    protected AbstractDerivator(ArrayContext context, boolean decrementForUnsigned) {
        super(context);
        this.decrementForUnsigned = decrementForUnsigned;
    }

    @Override
    public Derivator context(ArrayContext newContext) {
        return (Derivator)super.context(newContext);
    }

    @Override
    public abstract boolean isPseudoCyclic();

    @Override
    public double decrement(Class<?> elementType) {
        if (this.decrementForUnsigned) {
            if (elementType == Byte.TYPE) {
                return 128.0;
            }
            if (elementType == Short.TYPE || elementType == Character.TYPE) {
                return 32768.0;
            }
        }
        return 0.0;
    }

    @Override
    public abstract Matrix<? extends PArray> asMaximumFromShiftedForwardAndBackward(Matrix<? extends PArray> var1, Matrix<? extends PIntegerArray> var2, IPoint ... var3);

    @Override
    public Matrix<? extends UpdatablePArray> maximumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.maximumFromShiftedForwardAndBackward(dest, src, directionIndexes, directions);
        return dest;
    }

    @Override
    public void maximumFromShiftedForwardAndBackward(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asMaximumFromShiftedForwardAndBackward(src, directionIndexes, directions));
    }

    @Override
    public abstract Matrix<? extends BitArray> asMaskOfMaximums(Matrix<? extends PArray> var1, Derivator.SuppressionMode var2, Matrix<? extends PIntegerArray> var3, IPoint ... var4);

    @Override
    public Matrix<? extends UpdatableBitArray> maskOfMaximums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatableBitArray> dest = this.memoryModel().newBitMatrix(src.dimensions());
        this.maskOfMaximums(dest, src, mode, directionIndexes, directions);
        return dest;
    }

    @Override
    public void maskOfMaximums(Matrix<? extends UpdatableBitArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asMaskOfMaximums(src, mode, directionIndexes, directions));
    }

    @Override
    public abstract Matrix<? extends PArray> asNonMaximumSuppression(Matrix<? extends PArray> var1, Derivator.SuppressionMode var2, double var3, Matrix<? extends PIntegerArray> var5, IPoint ... var6);

    @Override
    public Matrix<? extends UpdatablePArray> nonMaximumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.nonMaximumSuppression(dest, src, mode, filler, directionIndexes, directions);
        return dest;
    }

    @Override
    public void nonMaximumSuppression(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asNonMaximumSuppression(src, mode, filler, directionIndexes, directions));
    }

    @Override
    public abstract Matrix<? extends PArray> asMinimumFromShiftedForwardAndBackward(Matrix<? extends PArray> var1, Matrix<? extends PIntegerArray> var2, IPoint ... var3);

    @Override
    public Matrix<? extends UpdatablePArray> minimumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.minimumFromShiftedForwardAndBackward(dest, src, directionIndexes, directions);
        return dest;
    }

    @Override
    public void minimumFromShiftedForwardAndBackward(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asMinimumFromShiftedForwardAndBackward(src, directionIndexes, directions));
    }

    @Override
    public abstract Matrix<? extends BitArray> asMaskOfMinimums(Matrix<? extends PArray> var1, Derivator.SuppressionMode var2, Matrix<? extends PIntegerArray> var3, IPoint ... var4);

    @Override
    public Matrix<? extends UpdatableBitArray> maskOfMinimums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatableBitArray> dest = this.memoryModel().newBitMatrix(src.dimensions());
        this.maskOfMinimums(dest, src, mode, directionIndexes, directions);
        return dest;
    }

    @Override
    public void maskOfMinimums(Matrix<? extends UpdatableBitArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asMaskOfMinimums(src, mode, directionIndexes, directions));
    }

    @Override
    public abstract Matrix<? extends PArray> asNonMinimumSuppression(Matrix<? extends PArray> var1, Derivator.SuppressionMode var2, double var3, Matrix<? extends PIntegerArray> var5, IPoint ... var6);

    @Override
    public Matrix<? extends UpdatablePArray> nonMinimumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.nonMinimumSuppression(dest, src, mode, filler, directionIndexes, directions);
        return dest;
    }

    @Override
    public void nonMinimumSuppression(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(dest, src, directionIndexes);
        directions = AbstractDerivator.checkAndCloneDirections(src.dimCount(), directions);
        Matrices.copy(this.context(), dest, this.asNonMinimumSuppression(src, mode, filler, directionIndexes, directions));
    }

    @Override
    public Matrix<? extends PIntegerArray> asRoundedDirectionIndex2D(Matrix<? extends PArray> vectorX, Matrix<? extends PArray> vectorY) {
        Matrices.checkDimensionEquality(vectorX, vectorY);
        double d = this.decrement(vectorX.elementType());
        if (d != 0.0) {
            vectorX = Matrices.asFuncMatrix((Func)LinearFunc.getInstance(-d, 1.0), DoubleArray.class, vectorX);
        }
        if ((d = this.decrement(vectorY.elementType())) != 0.0) {
            vectorY = Matrices.asFuncMatrix((Func)LinearFunc.getInstance(-d, 1.0), DoubleArray.class, vectorY);
        }
        return Matrices.asFuncMatrix(Func.SELECT_FROM_8_DIRECTIONS_2D, ByteArray.class, vectorX, vectorY);
    }

    @Override
    public IPoint[] roundedDirections2D() {
        return Func.SHIFTS_ALONG_8_DIRECTIONS_2D.toArray(new IPoint[0]);
    }

    @Override
    public <T extends PArray> Matrix<T> asModuleOfVector(Class<? extends T> requiredType, List<? extends Matrix<? extends PArray>> vectorComponents) {
        ArrayList<? extends Matrix<? extends PArray>> list = new ArrayList<Matrix<? extends PArray>>(vectorComponents);
        Matrices.checkDimensionEquality(list);
        int n = list.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty list of vector components");
        }
        if (n == 1) {
            Matrix<? extends PArray> m = list.get(0);
            double d = this.decrement(m.elementType());
            if (d != 0.0) {
                m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance(-d, 1.0), DoubleArray.class, m);
            }
            return Matrices.asFuncMatrix(Func.ABS, requiredType, m);
        }
        for (int k = 0; k < n; ++k) {
            Matrix<? extends PArray> m = list.get(k);
            double d = this.decrement(m.elementType());
            if (d != 0.0) {
                m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance(-d, 1.0), DoubleArray.class, m);
            }
            m = Matrices.asFuncMatrix((Func)PowerFunc.getInstance(2.0), DoubleArray.class, m);
            list.set(k, m);
        }
        Matrix<DoubleArray> sqrSum = Matrices.asFuncMatrix((Func)LinearFunc.getNonweightedInstance(0.0, 1.0, n), DoubleArray.class, list);
        return Matrices.asFuncMatrix((Func)PowerFunc.getInstance(0.5), requiredType, sqrSum);
    }

    protected static IPoint[] checkAndCloneDirections(int dimCount, IPoint ... directions) {
        Objects.requireNonNull(directions, "Null directions argument");
        directions = (IPoint[])directions.clone();
        int k = 0;
        for (IPoint dir : directions) {
            Objects.requireNonNull(dir, "Null direction #" + k);
            if (dir.coordCount() != dimCount) {
                throw new IllegalArgumentException("The direction #" + k + " = " + String.valueOf(dir) + " has illegal number of dimensions: " + dimCount + "-dimensional vectors required");
            }
            ++k;
        }
        return directions;
    }
}

