/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.StreamingApertureProcessor;
import net.algart.matrices.morphology.AbstractRankMorphology;
import net.algart.matrices.morphology.CustomRankPrecision;
import net.algart.matrices.morphology.FixedPercentileRankMorphology;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.matrices.morphology.RankProcessors;

public abstract class BasicRankMorphology
extends AbstractRankMorphology
implements RankMorphology {
    final boolean interpolated;
    final int[] bitLevels;

    BasicRankMorphology(ArrayContext context, boolean interpolated, int[] bitLevels) {
        super(context);
        Objects.requireNonNull(bitLevels, "Null bitLevels argument");
        this.bitLevels = (int[])bitLevels.clone();
        this.interpolated = interpolated;
        RankProcessors.getPercentiler(null, interpolated, this.bitLevels);
    }

    public static RankMorphology getInstance(ArrayContext context, double dilationLevel, CustomRankPrecision precision) {
        return new FixedPercentileRankMorphology(context, dilationLevel, precision.interpolated(), precision.bitLevels());
    }

    @Override
    public boolean isPseudoCyclic() {
        return true;
    }

    @Override
    protected abstract Matrix<? extends PArray> asDilationOrErosion(Matrix<? extends PArray> var1, Pattern var2, boolean var3);

    @Override
    protected abstract Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3, boolean var4, boolean var5);

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        StreamingApertureProcessor percentiler = RankProcessors.getPercentiler(this.context(), this.interpolated, this.bitLevels);
        return percentiler.asProcessed(src.array().type(), src, percentileIndexes, pattern);
    }

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        StreamingApertureProcessor percentiler = RankProcessors.getPercentiler(this.context(), this.interpolated, this.bitLevels);
        percentiler.process(dest, src, percentileIndexes, pattern);
    }

    @Override
    public <T extends PArray> Matrix<T> asRank(Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        StreamingApertureProcessor ranker = RankProcessors.getRanker(this.context(), this.interpolated && PFloatingArray.class.isAssignableFrom(requiredType), this.bitLevels);
        return ranker.asProcessed(requiredType, baseMatrix, rankedMatrix, pattern);
    }

    @Override
    public void rank(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        StreamingApertureProcessor ranker = RankProcessors.getRanker(this.context(), this.interpolated && PFloatingArray.class.isAssignableFrom(dest.type()), this.bitLevels);
        ranker.process(dest, baseMatrix, rankedMatrix, pattern);
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentilesIndexes, Matrix<? extends PArray> toPercentilesIndexes, Pattern pattern, double filler) {
        StreamingApertureProcessor averager = RankProcessors.getAveragerBetweenPercentiles(this.context(), filler, this.interpolated, this.bitLevels);
        return averager.asProcessed(src.array().type(), src, fromPercentilesIndexes, toPercentilesIndexes, pattern);
    }

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentilesIndexes, Matrix<? extends PArray> toPercentilesIndexes, Pattern pattern, double filler) {
        StreamingApertureProcessor averager = RankProcessors.getAveragerBetweenPercentiles(this.context(), filler, this.interpolated, this.bitLevels);
        averager.process(dest, src, fromPercentilesIndexes, toPercentilesIndexes, pattern);
    }

    @Override
    public Matrix<? extends PArray> asMeanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        StreamingApertureProcessor averager = RankProcessors.getAveragerBetweenValues(this.context(), filler, this.interpolated, this.bitLevels);
        return averager.asProcessed(src.array().type(), src, minValues, maxValues, pattern);
    }

    @Override
    public void meanBetweenValues(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        StreamingApertureProcessor averager = RankProcessors.getAveragerBetweenValues(this.context(), filler, this.interpolated, this.bitLevels);
        averager.process(dest, src, minValues, maxValues, pattern);
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfSum(Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        StreamingApertureProcessor averager = RankProcessors.getSummator(this.context(), processingFunc);
        return averager.asProcessed(src.array().type(), src, pattern);
    }

    @Override
    public void functionOfSum(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        StreamingApertureProcessor averager = RankProcessors.getSummator(this.context(), processingFunc);
        averager.process(dest, src, pattern);
    }

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentilesIndexes1, Matrix<? extends PArray> percentilesIndexes2, Pattern pattern, Func processingFunc) {
        StreamingApertureProcessor contraster = RankProcessors.getPercentilePairProcessor(this.context(), processingFunc, this.interpolated, this.bitLevels);
        return contraster.asProcessed(src.array().type(), src, src, percentilesIndexes1, percentilesIndexes2, pattern);
    }

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Matrix<? extends PArray> percentilesIndexes1, Matrix<? extends PArray> percentilesIndexes2, Pattern pattern, Func processingFunc) {
        StreamingApertureProcessor contraster = RankProcessors.getPercentilePairProcessor(this.context(), processingFunc, this.interpolated, this.bitLevels);
        contraster.process(dest, src, src, percentilesIndexes1, percentilesIndexes2, pattern);
    }
}

