/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.morphology.Morphology;

public class ContinuedMorphology
implements Morphology {
    private static final boolean SIMPLIFIED_CONSTANT_CONTINUATION = true;
    private final Morphology parent;
    final ArrayContext context;
    final MemoryModel memoryModel;
    final Matrix.ContinuationMode continuationMode;

    ContinuedMorphology(Morphology parent, Matrix.ContinuationMode continuationMode) {
        Objects.requireNonNull(parent, "Null parent morphology");
        Objects.requireNonNull(continuationMode, "Null continuationMode derivator");
        if (continuationMode == Matrix.ContinuationMode.NONE) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be used with continuation mode \"" + String.valueOf(continuationMode) + "\"");
        }
        this.parent = parent;
        this.context = parent.context() == null ? ArrayContext.DEFAULT : parent.context();
        this.memoryModel = this.context.getMemoryModel();
        this.continuationMode = continuationMode;
    }

    public static ContinuedMorphology getInstance(Morphology parent, Matrix.ContinuationMode continuationMode) {
        return new ContinuedMorphology(parent, continuationMode);
    }

    public Morphology parent() {
        return this.parent;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    @Override
    public Morphology context(ArrayContext newContext) {
        return new ContinuedMorphology(this.parent.context(newContext), this.continuationMode);
    }

    @Override
    public boolean isPseudoCyclic() {
        return this.continuationMode == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public Matrix<? extends PArray> asDilation(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), pattern, false);
        return this.reduce(this.parent.asDilation(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends PArray> asErosion(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), pattern, true);
        return this.reduce(this.parent.asErosion(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), pattern, false);
        return this.reduce(this.parent.dilation(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), pattern, true);
        return this.reduce(this.parent.erosion(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakDilation(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), pattern, false, pattern, true);
        return this.reduce(this.parent.weakDilation(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakErosion(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), pattern, true, pattern, false);
        return this.reduce(this.parent.weakErosion(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> beucherGradient(Matrix<? extends PArray> src, Pattern pattern) {
        IRectangularArea a = DependenceApertureBuilder.MAX.getAperture(src.dimCount(), pattern, false, pattern, true);
        return this.reduce(this.parent.beucherGradient(this.extend(src, a), pattern), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = (subtractionMode == Morphology.SubtractionMode.NONE ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, false);
        return this.reduce(this.parent.dilation(this.extend(src, a), pattern, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = (subtractionMode == Morphology.SubtractionMode.NONE ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, true);
        return this.reduce(this.parent.erosion(this.extend(src, a), pattern, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> closing(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = (subtractionMode == Morphology.SubtractionMode.NONE ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, false, pattern, true);
        return this.reduce(this.parent.closing(this.extend(src, a), pattern, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> opening(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = (subtractionMode == Morphology.SubtractionMode.NONE ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0).getAperture(src.dimCount(), pattern, true, pattern, false);
        return this.reduce(this.parent.opening(this.extend(src, a), pattern, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilationErosion(Matrix<? extends PArray> src, Pattern ptn1, Pattern ptn2, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), ptn1, false, ptn2, true);
        return this.reduce(this.parent.dilationErosion(this.extend(src, a), ptn1, ptn2, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosionDilation(Matrix<? extends PArray> src, Pattern ptn1, Pattern ptn2, Morphology.SubtractionMode subtractionMode) {
        IRectangularArea a = DependenceApertureBuilder.SUM.getAperture(src.dimCount(), ptn1, true, ptn2, false);
        return this.reduce(this.parent.erosionDilation(this.extend(src, a), ptn1, ptn2, subtractionMode), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedDilationErosion(Matrix<? extends PArray> src, Pattern ptn1, Pattern ptn2) {
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), ptn1, false, ptn2, true);
        return this.reduce(this.parent.maskedDilationErosion(this.extend(src, a), ptn1, ptn2), a);
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedErosionDilation(Matrix<? extends PArray> src, Pattern ptn1, Pattern ptn2) {
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), ptn1, true, ptn2, false);
        return this.reduce(this.parent.maskedErosionDilation(this.extend(src, a), ptn1, ptn2), a);
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean disableMemoryAllocation) {
        Matrices.checkDimensionEquality(dest, src);
        IRectangularArea a = (disableMemoryAllocation ? DependenceApertureBuilder.SUM_MAX_0 : DependenceApertureBuilder.SUM).getAperture(src.dimCount(), pattern, false);
        Matrix<? extends PArray> continued = this.extend(src, a);
        if (disableMemoryAllocation) {
            this.parent.dilation(this.extend(dest, a, true), continued, pattern, disableMemoryAllocation);
        } else {
            Matrix<UpdatablePArray> temp = this.memoryModel.newMatrix(UpdatablePArray.class, continued);
            this.parent.context(this.context.part(0.0, 0.95)).dilation(temp, continued, pattern, disableMemoryAllocation);
            Matrices.copy(this.context.part(0.95, 1.0), dest, this.reduce(temp, a));
        }
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean disableMemoryAllocation) {
        Matrices.checkDimensionEquality(dest, src);
        IRectangularArea a = (disableMemoryAllocation ? DependenceApertureBuilder.SUM_MAX_0 : DependenceApertureBuilder.SUM).getAperture(src.dimCount(), pattern, true);
        Matrix<? extends PArray> continued = this.extend(src, a);
        if (disableMemoryAllocation) {
            this.parent.erosion(this.extend(dest, a, true), continued, pattern, disableMemoryAllocation);
        } else {
            Matrix<UpdatablePArray> temp = this.memoryModel.newMatrix(UpdatablePArray.class, continued);
            this.parent.context(this.context.part(0.0, 0.95)).erosion(temp, continued, pattern, disableMemoryAllocation);
            Matrices.copy(this.context.part(0.95, 1.0), dest, this.reduce(temp, a));
        }
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.dilation(dest, src, pattern, false);
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.erosion(dest, src, pattern, false);
    }

    private <T extends PArray> Matrix<T> extend(Matrix<T> src, IRectangularArea aperture) {
        return this.extend(src, aperture, false);
    }

    private <T extends PArray> Matrix<T> extend(Matrix<T> m, IRectangularArea aperture, boolean dest) {
        if (m.isEmpty()) {
            return m;
        }
        if (!this.parent.isPseudoCyclic()) {
            aperture = aperture.expand(IPoint.origin(aperture.coordCount()));
        }
        if (this.continuationMode.isConstant() && aperture.contains(IPoint.origin(m.dimCount()))) {
            long[] size = m.dimensions();
            for (int k = 0; k < size.length; ++k) {
                int n = k;
                size[n] = size[n] + aperture.size(k);
                if (size[k] >= 0L) continue;
                throw new IndexOutOfBoundsException("Too large matrix continuation for morphology: the dimension #" + k + " of the matrix, extended to the corresponding aperture " + String.valueOf(aperture) + ", is greater than Long.MAX_VALUE");
            }
            return m.subMatr(new long[size.length], size, this.continuationMode);
        }
        long[] from = aperture.min().coordinates();
        long[] to = IPoint.of(m.dimensions()).add(aperture.max()).coordinates();
        for (int k = 0; k < to.length; ++k) {
            if (to[k] >= 0L || aperture.max(k) < 0L) continue;
            throw new IndexOutOfBoundsException("Too large matrix continuation for morphology: the dimension #" + k + " of the matrix, extended to the corresponding aperture " + String.valueOf(aperture) + ", is greater than Long.MAX_VALUE");
        }
        return m.subMatrix(from, to, dest ? Matrix.ContinuationMode.ZERO_CONSTANT : this.continuationMode);
    }

    private <T extends PArray> Matrix<T> reduce(Matrix<T> continued, IRectangularArea aperture) {
        if (continued.isEmpty()) {
            return continued;
        }
        if (!this.parent.isPseudoCyclic()) {
            aperture = aperture.expand(IPoint.origin(aperture.coordCount()));
        }
        if (this.continuationMode.isConstant() && aperture.contains(IPoint.origin(continued.dimCount()))) {
            long[] size = continued.dimensions();
            for (int k = 0; k < size.length; ++k) {
                int n = k;
                size[n] = size[n] - aperture.size(k);
            }
            return continued.subMatr(new long[size.length], size, this.continuationMode);
        }
        long[] from = aperture.min().symmetric().coordinates();
        long[] to = IPoint.of(continued.dimensions()).subtract(aperture.max()).coordinates();
        return continued.subMatrix(from, to, Matrix.ContinuationMode.PSEUDO_CYCLIC);
    }
}

