/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.Arrays;

class HistogramCache<T> {
    private final Map<Long, Reference<T>> histogramCache;
    private final int histogramCacheCapacity = 2 * Arrays.SystemSettings.cpuCount();

    HistogramCache() {
        this.histogramCache = new LinkedHashMap<Long, Reference<T>>(){
            private static final long serialVersionUID = 3203370748019883916L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Reference<T>> eldest) {
                return this.size() > HistogramCache.this.histogramCacheCapacity;
            }
        };
    }

    public synchronized int size() {
        return this.histogramCache.size();
    }

    public synchronized T get(long position) {
        Reference<T> ref = this.histogramCache.remove(position);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public synchronized void put(long position, T histogram) {
        Objects.requireNonNull(histogram, "Null histogram");
        this.reap();
        SoftReference<T> ref = new SoftReference<T>(histogram);
        this.histogramCache.put(position, ref);
    }

    private void reap() {
        Set<Map.Entry<Long, Reference<T>>> entries = this.histogramCache.entrySet();
        Iterator<Map.Entry<Long, Reference<T>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Reference<T>> entry = iterator.next();
            if (entry.getValue().get() != null) continue;
            iterator.remove();
        }
    }
}

