/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;

public interface Morphology
extends ArrayProcessorWithContextSwitching {
    @Override
    public Morphology context(ArrayContext var1);

    public boolean isPseudoCyclic();

    public Matrix<? extends PArray> asDilation(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends PArray> asErosion(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> var1, Pattern var2, SubtractionMode var3);

    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> var1, Pattern var2, SubtractionMode var3);

    public void dilation(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3, boolean var4);

    public void erosion(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3, boolean var4);

    public void dilation(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3);

    public void erosion(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3);

    public Matrix<? extends UpdatablePArray> dilationErosion(Matrix<? extends PArray> var1, Pattern var2, Pattern var3, SubtractionMode var4);

    public Matrix<? extends UpdatablePArray> erosionDilation(Matrix<? extends PArray> var1, Pattern var2, Pattern var3, SubtractionMode var4);

    public Matrix<? extends UpdatablePArray> closing(Matrix<? extends PArray> var1, Pattern var2, SubtractionMode var3);

    public Matrix<? extends UpdatablePArray> opening(Matrix<? extends PArray> var1, Pattern var2, SubtractionMode var3);

    public Matrix<? extends UpdatablePArray> weakDilation(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends UpdatablePArray> weakErosion(Matrix<? extends PArray> var1, Pattern var2);

    public Matrix<? extends UpdatablePArray> maskedDilationErosion(Matrix<? extends PArray> var1, Pattern var2, Pattern var3);

    public Matrix<? extends UpdatablePArray> maskedErosionDilation(Matrix<? extends PArray> var1, Pattern var2, Pattern var3);

    public Matrix<? extends UpdatablePArray> beucherGradient(Matrix<? extends PArray> var1, Pattern var2);

    public static enum SubtractionMode {
        NONE{

            @Override
            void subtract(ArrayContext context, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
            }
        }
        ,
        SUBTRACT_RESULT_FROM_SRC{

            @Override
            void subtract(ArrayContext context, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
                Matrices.applyFunc(context, true, Func.POSITIVE_DIFF, dest, src, dest);
            }
        }
        ,
        SUBTRACT_SRC_FROM_RESULT{

            @Override
            void subtract(ArrayContext context, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src) {
                Matrices.applyFunc(context, true, Func.POSITIVE_DIFF, dest, dest, src);
            }
        };


        abstract void subtract(ArrayContext var1, Matrix<? extends UpdatablePArray> var2, Matrix<? extends PArray> var3);
    }
}

