/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRange;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.QuickPointCountPattern;
import net.algart.math.patterns.TooManyPointsInPatternError;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.RankOperationProcessor;
import net.algart.matrices.morphology.RankPrecision;

class Summator
extends RankOperationProcessor {
    private final boolean optimizeGetData = OPTIMIZE_GET_DATA;
    private final boolean optimizeDirectArrays = OPTIMIZE_DIRECT_ARRAYS;
    private final boolean optimizeSegmentsAlongAxes = OPTIMIZE_SEGMENTS_ALONG_AXES;
    private final boolean specialOptimizeThinPatternsPowersOfTwo = SPECIAL_OPTIMIZE_THIN_PATTERNS_POWERS_OF_TWO;
    private final Func processingFunc;
    private final boolean linearFunc;
    private final boolean dividingByPowerOfTwoWithRoundingFunc;
    private final double lfA;
    private final double lfB;
    private final long halfDivisor;
    private final int logDivisor;
    private static final int BIT_TYPE_CODE = 1;
    private static final int CHAR_TYPE_CODE = 2;
    private static final int BYTE_TYPE_CODE = 3;
    private static final int SHORT_TYPE_CODE = 4;
    private static final int INT_TYPE_CODE = 5;
    private static final int LONG_TYPE_CODE = 6;
    private static final int FLOAT_TYPE_CODE = 7;
    private static final int DOUBLE_TYPE_CODE = 8;

    Summator(ArrayContext context, Func processingFunc) {
        super(context, RankPrecision.BITS_1.bitLevels);
        Objects.requireNonNull(processingFunc, "Null contrastingFunc");
        this.processingFunc = processingFunc;
        if (processingFunc == Func.IDENTITY) {
            this.linearFunc = true;
            this.dividingByPowerOfTwoWithRoundingFunc = true;
            this.lfA = 1.0;
            this.lfB = 0.0;
            this.halfDivisor = 0L;
            this.logDivisor = 0;
        } else if (processingFunc instanceof LinearFunc) {
            this.linearFunc = true;
            this.lfA = ((LinearFunc)processingFunc).a(0);
            this.lfB = ((LinearFunc)processingFunc).b();
            long m = Math.round(1.0 / this.lfA);
            if (this.lfB == 0.5 && m > 0L && this.lfA == 1.0 / (double)m && (m & m - 1L) == 0L) {
                this.dividingByPowerOfTwoWithRoundingFunc = true;
                this.halfDivisor = m >> 1;
                this.logDivisor = 63 - Long.numberOfLeadingZeros(m);
            } else {
                this.dividingByPowerOfTwoWithRoundingFunc = false;
                this.halfDivisor = 0L;
                this.logDivisor = -1;
            }
        } else {
            this.linearFunc = false;
            this.dividingByPowerOfTwoWithRoundingFunc = false;
            this.lfA = Double.NaN;
            this.lfB = Double.NaN;
            this.halfDivisor = 0L;
            this.logDivisor = -1;
        }
    }

    @Override
    public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        if (this.optimizeSegmentsAlongAxes && pattern instanceof UniformGridPattern && pattern instanceof QuickPointCountPattern && ((UniformGridPattern)pattern).isActuallyRectangular()) {
            additionalMatrices = new ArrayList<Matrix<? extends PArray>>(additionalMatrices);
            Summator.checkArguments(dest, src, additionalMatrices, pattern);
            long pointCount = pattern.pointCount();
            if (pointCount > 1L) {
                if (pointCount > Integer.MAX_VALUE) {
                    throw new TooManyPointsInPatternError("Too large number of points in the pattern: " + pointCount + " > Integer.MAX_VALUE");
                }
                int n = pattern.dimCount();
                for (int k = 1; k < n; ++k) {
                    IRange range = pattern.roundedCoordRange(k);
                    if (range.size() != pointCount) continue;
                    this.processAlongAxis(dest.array(), src.array(), src.dimensions(), k, range.min(), range.max());
                    return;
                }
            }
        }
        super.process(dest, src, additionalMatrices, pattern);
    }

    @Override
    PArray asProcessed(Class<? extends PArray> desiredType, PArray src, PArray[] additional, long[] dimensions, final long[] shifts, final long[] left, final long[] right) {
        boolean meanByPowerOfTwoFunc;
        assert (shifts.length > 0);
        assert (left.length == right.length);
        boolean direct = this.optimizeDirectArrays && src instanceof DirectAccessible && ((DirectAccessible)((Object)src)).hasJavaArray();
        boolean meanFunc = this.linearFunc && this.lfA >= 0.0 && this.lfA <= 1.0 / (double)shifts.length && this.lfB >= 0.0 && this.lfB < 1.0;
        boolean bl = meanByPowerOfTwoFunc = meanFunc && this.dividingByPowerOfTwoWithRoundingFunc;
        if (src instanceof BitArray) {
            final BitArray a = (BitArray)src;
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if (!a.getBit(i)) continue;
                        ++sum;
                    }
                    return Summator.this.processingFunc.get((double)sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        if (!a.getBit(i)) continue;
                        ++sum;
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (a.getBit(i)) assert (--sum >= 0L) : "Unbalanced 0 and 1 bits";
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            if (!a.getBit(i)) continue;
                            ++sum;
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof CharArray) {
            final CharArray a = (CharArray)src;
            if (direct) {
                final char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (meanFunc && desiredType == CharArray.class) {
                    return new AbstractCharArray(src.length(), true, new Array[]{src}){

                        @Override
                        public char getChar(long index) {
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                            }
                            double v = Summator.this.processingFunc.get((double)sum);
                            return (char)v;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            char[] dest = (char[])destArray;
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.specialOptimizeThinPatternsPowersOfTwo && meanByPowerOfTwoFunc && jaOfs == 0) {
                                        int k = 0;
                                        while (k < count) {
                                            long v = sum + Summator.this.halfDivisor >> Summator.this.logDivisor;
                                            dest[destArrayOffset] = (char)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.linearFunc) {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            dest[destArrayOffset] = (char)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.processingFunc.get((double)sum);
                                            dest[destArrayOffset] = (char)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i;
                                double v = Summator.this.processingFunc.get((double)sum);
                                dest[destArrayOffset] = (char)v;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        long sum = 0L;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                        }
                        double v = Summator.this.processingFunc.get((double)sum);
                        return (char)v;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        long sum = 0L;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                if (Summator.this.linearFunc && jaOfs == 0) {
                                    if (Summator.this.lfB != 0.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.lfA != 1.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                } else {
                                    int k = 0;
                                    while (k < count) {
                                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                                        i = arrayPos + leftInvShift;
                                        sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                        i = ++arrayPos + rightInvShift;
                                        sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                        ++k;
                                        ++destArrayOffset;
                                    }
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (long)(ja[jaOfs + (int)i2] & 0xFFFF);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i2] & 0xFFFF);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    return Summator.this.processingFunc.get((double)sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= (long)a.getInt(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)a.getInt(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof ByteArray) {
            final ByteArray a = (ByteArray)src;
            if (direct) {
                final byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (meanFunc && desiredType == ByteArray.class) {
                    return new AbstractByteArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getByte(long index) {
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                            }
                            double v = Summator.this.processingFunc.get((double)sum);
                            return (int)v;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            byte[] dest = (byte[])destArray;
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.specialOptimizeThinPatternsPowersOfTwo && meanByPowerOfTwoFunc && jaOfs == 0) {
                                        int k = 0;
                                        while (k < count) {
                                            long v = sum + Summator.this.halfDivisor >> Summator.this.logDivisor;
                                            dest[destArrayOffset] = (byte)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.linearFunc) {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            dest[destArrayOffset] = (byte)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.processingFunc.get((double)sum);
                                            dest[destArrayOffset] = (byte)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i;
                                double v = Summator.this.processingFunc.get((double)sum);
                                dest[destArrayOffset] = (byte)v;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum -= (long)(ja[jaOfs + (int)i] & 0xFF);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        long sum = 0L;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                        }
                        double v = Summator.this.processingFunc.get((double)sum);
                        return (int)v;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        long sum = 0L;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                if (Summator.this.linearFunc && jaOfs == 0) {
                                    if (Summator.this.lfB != 0.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.lfA != 1.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                } else {
                                    int k = 0;
                                    while (k < count) {
                                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                                        i = arrayPos + leftInvShift;
                                        sum -= (long)(ja[jaOfs + (int)i] & 0xFF);
                                        i = ++arrayPos + rightInvShift;
                                        sum += (long)(ja[jaOfs + (int)i] & 0xFF);
                                        ++k;
                                        ++destArrayOffset;
                                    }
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (long)(ja[jaOfs + (int)i2] & 0xFF);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i2] & 0xFF);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    return Summator.this.processingFunc.get((double)sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= (long)a.getInt(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)a.getInt(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof ShortArray) {
            final ShortArray a = (ShortArray)src;
            if (direct) {
                final short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (meanFunc && desiredType == ShortArray.class) {
                    return new AbstractShortArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getShort(long index) {
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                            }
                            double v = Summator.this.processingFunc.get((double)sum);
                            return (int)v;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            short[] dest = (short[])destArray;
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.specialOptimizeThinPatternsPowersOfTwo && meanByPowerOfTwoFunc && jaOfs == 0) {
                                        int k = 0;
                                        while (k < count) {
                                            long v = sum + Summator.this.halfDivisor >> Summator.this.logDivisor;
                                            dest[destArrayOffset] = (short)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.linearFunc) {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            dest[destArrayOffset] = (short)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            double v = Summator.this.processingFunc.get((double)sum);
                                            dest[destArrayOffset] = (short)v;
                                            long i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i;
                                double v = Summator.this.processingFunc.get((double)sum);
                                dest[destArrayOffset] = (short)v;
                                for (long shift : right) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i = arrayPos - shift;
                                    if (i < 0L) {
                                        i += this.length;
                                    }
                                    sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        long sum = 0L;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                        }
                        double v = Summator.this.processingFunc.get((double)sum);
                        return (int)v;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        long sum = 0L;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                if (Summator.this.linearFunc && jaOfs == 0) {
                                    if (Summator.this.lfB != 0.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum + Summator.this.lfB;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.lfA != 1.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * (double)sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)(ja[(int)i] & 0xFFFF);
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)(ja[(int)i] & 0xFFFF);
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                } else {
                                    int k = 0;
                                    while (k < count) {
                                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                                        i = arrayPos + leftInvShift;
                                        sum -= (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                        i = ++arrayPos + rightInvShift;
                                        sum += (long)(ja[jaOfs + (int)i] & 0xFFFF);
                                        ++k;
                                        ++destArrayOffset;
                                    }
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (long)(ja[jaOfs + (int)i2] & 0xFFFF);
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (long)(ja[jaOfs + (int)i2] & 0xFFFF);
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    return Summator.this.processingFunc.get((double)sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= (long)a.getInt(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)a.getInt(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof IntArray) {
            final IntArray a = (IntArray)src;
            if (direct) {
                final int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (desiredType == IntArray.class) {
                    return new AbstractIntArray(src.length(), true, new Array[]{src}){

                        @Override
                        public int getInt(long index) {
                            long sum = 0L;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)ja[jaOfs + (int)i];
                            }
                            return (int)Summator.this.processingFunc.get((double)sum);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            int[] dest = (int[])destArray;
                            long sum = 0L;
                            for (long shift : shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (long)ja[jaOfs + (int)i];
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.linearFunc) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (int)(Summator.this.lfA * (double)sum + Summator.this.lfB);
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (int)Summator.this.processingFunc.get((double)sum);
                                            i = arrayPos + leftInvShift;
                                            sum -= (long)ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (long)ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i2;
                                dest[destArrayOffset] = (int)Summator.this.processingFunc.get((double)sum);
                                for (long shift : right) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum -= (long)ja[jaOfs + (int)i2];
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum += (long)ja[jaOfs + (int)i2];
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        long sum = 0L;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)ja[jaOfs + (int)i];
                        }
                        return Summator.this.processingFunc.get((double)sum);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        long sum = 0L;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)ja[jaOfs + (int)i];
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                int k = 0;
                                while (k < count) {
                                    dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                                    i = arrayPos + leftInvShift;
                                    sum -= (long)ja[jaOfs + (int)i];
                                    i = ++arrayPos + rightInvShift;
                                    sum += (long)ja[jaOfs + (int)i];
                                    ++k;
                                    ++destArrayOffset;
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (long)ja[jaOfs + (int)i2];
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (long)ja[jaOfs + (int)i2];
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    return Summator.this.processingFunc.get((double)sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    long sum = 0L;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (long)a.getInt(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get((double)sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= (long)a.getInt(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (long)a.getInt(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof LongArray) {
            final LongArray a = (LongArray)src;
            if (direct) {
                final long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (desiredType == LongArray.class) {
                    return new AbstractLongArray(src.length(), true, new Array[]{src}){

                        @Override
                        public long getLong(long index) {
                            double sum = 0.0;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i];
                            }
                            return (long)Summator.this.processingFunc.get(sum);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            long[] dest = (long[])destArray;
                            double sum = 0.0;
                            for (long shift : shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i];
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.linearFunc) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (long)(Summator.this.lfA * sum + Summator.this.lfB);
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (long)Summator.this.processingFunc.get(sum);
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i2;
                                dest[destArrayOffset] = (long)Summator.this.processingFunc.get(sum);
                                for (long shift : right) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum -= (double)ja[jaOfs + (int)i2];
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum += (double)ja[jaOfs + (int)i2];
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double sum = 0.0;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (double)ja[jaOfs + (int)i];
                        }
                        return Summator.this.processingFunc.get(sum);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        double sum = 0.0;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (double)ja[jaOfs + (int)i];
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                int k = 0;
                                while (k < count) {
                                    dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                                    i = arrayPos + leftInvShift;
                                    sum -= (double)ja[jaOfs + (int)i];
                                    i = ++arrayPos + rightInvShift;
                                    sum += (double)ja[jaOfs + (int)i];
                                    ++k;
                                    ++destArrayOffset;
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (double)ja[jaOfs + (int)i2];
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i2];
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (double)a.getLong(i);
                    }
                    return Summator.this.processingFunc.get(sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += (double)a.getLong(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= (double)a.getLong(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (double)a.getLong(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof FloatArray) {
            final FloatArray a = (FloatArray)src;
            if (direct) {
                final float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (desiredType == FloatArray.class) {
                    return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                        @Override
                        public float getFloat(long index) {
                            double sum = 0.0;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i];
                            }
                            return (float)Summator.this.processingFunc.get(sum);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            float[] dest = (float[])destArray;
                            double sum = 0.0;
                            for (long shift : shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i];
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.linearFunc && jaOfs == 0) {
                                        if (Summator.this.lfB != 0.0) {
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)(Summator.this.lfA * sum + Summator.this.lfB);
                                                i = arrayPos + leftInvShift;
                                                sum -= (double)ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += (double)ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        } else if (Summator.this.lfA != 1.0) {
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)(Summator.this.lfA * sum);
                                                i = arrayPos + leftInvShift;
                                                sum -= (double)ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += (double)ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        } else {
                                            assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)sum;
                                                i = arrayPos + leftInvShift;
                                                sum -= (double)ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += (double)ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (float)Summator.this.processingFunc.get(sum);
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i2;
                                dest[destArrayOffset] = (float)Summator.this.processingFunc.get(sum);
                                for (long shift : right) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum -= (double)ja[jaOfs + (int)i2];
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum += (double)ja[jaOfs + (int)i2];
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double sum = 0.0;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (double)ja[jaOfs + (int)i];
                        }
                        return Summator.this.processingFunc.get(sum);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        double sum = 0.0;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += (double)ja[jaOfs + (int)i];
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                if (Summator.this.linearFunc && jaOfs == 0) {
                                    if (Summator.this.lfB != 0.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * sum + Summator.this.lfB;
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.lfA != 1.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= (double)ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += (double)ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                } else {
                                    int k = 0;
                                    while (k < count) {
                                        dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                                        i = arrayPos + leftInvShift;
                                        sum -= (double)ja[jaOfs + (int)i];
                                        i = ++arrayPos + rightInvShift;
                                        sum += (double)ja[jaOfs + (int)i];
                                        ++k;
                                        ++destArrayOffset;
                                    }
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= (double)ja[jaOfs + (int)i2];
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += (double)ja[jaOfs + (int)i2];
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += a.getDouble(i);
                    }
                    return Summator.this.processingFunc.get(sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += a.getDouble(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= a.getDouble(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += a.getDouble(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        if (src instanceof DoubleArray) {
            final DoubleArray a = (DoubleArray)src;
            if (direct) {
                final double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                final int jaOfs = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (desiredType == FloatArray.class) {
                    return new AbstractFloatArray(src.length(), true, new Array[]{src}){

                        @Override
                        public float getFloat(long index) {
                            double sum = 0.0;
                            for (long shift : shifts) {
                                long i = index - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += ja[jaOfs + (int)i];
                            }
                            return (float)Summator.this.processingFunc.get(sum);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            long i;
                            if (!Summator.this.optimizeGetData) {
                                super.getData(arrayPos, destArray, destArrayOffset, count);
                                return;
                            }
                            Objects.requireNonNull(destArray, "Null destArray argument");
                            Summator.checkRanges(this.length, arrayPos, count);
                            if (count == 0) {
                                return;
                            }
                            float[] dest = (float[])destArray;
                            double sum = 0.0;
                            for (long shift : shifts) {
                                i = arrayPos - shift;
                                if (i < 0L) {
                                    i += this.length;
                                }
                                sum += ja[jaOfs + (int)i];
                            }
                            if (left.length == 1) {
                                long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                                long leftInvShift = -right[0];
                                assert (leftInvShift <= 0L && rightInvShift >= 0L);
                                if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                    if (Summator.this.linearFunc && jaOfs == 0) {
                                        if (Summator.this.lfB != 0.0) {
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)(Summator.this.lfA * sum + Summator.this.lfB);
                                                i = arrayPos + leftInvShift;
                                                sum -= ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        } else if (Summator.this.lfA != 1.0) {
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)(Summator.this.lfA * sum);
                                                i = arrayPos + leftInvShift;
                                                sum -= ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        } else {
                                            assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                            int k = 0;
                                            while (k < count) {
                                                dest[destArrayOffset] = (float)sum;
                                                i = arrayPos + leftInvShift;
                                                sum -= ja[(int)i];
                                                i = ++arrayPos + rightInvShift;
                                                sum += ja[(int)i];
                                                ++k;
                                                ++destArrayOffset;
                                            }
                                        }
                                    } else {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = (float)Summator.this.processingFunc.get(sum);
                                            i = arrayPos + leftInvShift;
                                            sum -= ja[jaOfs + (int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += ja[jaOfs + (int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                    return;
                                }
                            }
                            int k = 0;
                            while (k < count) {
                                long i2;
                                dest[destArrayOffset] = (float)Summator.this.processingFunc.get(sum);
                                for (long shift : right) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum -= ja[jaOfs + (int)i2];
                                }
                                if (++arrayPos == this.length) {
                                    arrayPos = 0L;
                                }
                                for (long shift : left) {
                                    i2 = arrayPos - shift;
                                    if (i2 < 0L) {
                                        i2 += this.length;
                                    }
                                    sum += ja[jaOfs + (int)i2];
                                }
                                ++k;
                                ++destArrayOffset;
                            }
                        }
                    };
                }
                return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                    @Override
                    public double getDouble(long index) {
                        double sum = 0.0;
                        for (long shift : shifts) {
                            long i = index - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += ja[jaOfs + (int)i];
                        }
                        return Summator.this.processingFunc.get(sum);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        long i;
                        if (!Summator.this.optimizeGetData) {
                            super.getData(arrayPos, destArray, destArrayOffset, count);
                            return;
                        }
                        Objects.requireNonNull(destArray, "Null destArray argument");
                        Summator.checkRanges(this.length, arrayPos, count);
                        if (count == 0) {
                            return;
                        }
                        double[] dest = (double[])destArray;
                        double sum = 0.0;
                        for (long shift : shifts) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += ja[jaOfs + (int)i];
                        }
                        if (left.length == 1) {
                            long rightInvShift = left[0] == 0L ? 0L : this.length - left[0];
                            long leftInvShift = -right[0];
                            assert (leftInvShift <= 0L && rightInvShift >= 0L);
                            if (arrayPos + leftInvShift >= 0L && arrayPos < this.length - rightInvShift - (long)count) {
                                if (Summator.this.linearFunc && jaOfs == 0) {
                                    if (Summator.this.lfB != 0.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * sum + Summator.this.lfB;
                                            i = arrayPos + leftInvShift;
                                            sum -= ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else if (Summator.this.lfA != 1.0) {
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = Summator.this.lfA * sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    } else {
                                        assert (Summator.this.lfA == 1.0 && Summator.this.lfB == 0.0);
                                        int k = 0;
                                        while (k < count) {
                                            dest[destArrayOffset] = sum;
                                            i = arrayPos + leftInvShift;
                                            sum -= ja[(int)i];
                                            i = ++arrayPos + rightInvShift;
                                            sum += ja[(int)i];
                                            ++k;
                                            ++destArrayOffset;
                                        }
                                    }
                                } else {
                                    int k = 0;
                                    while (k < count) {
                                        dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                                        i = arrayPos + leftInvShift;
                                        sum -= ja[jaOfs + (int)i];
                                        i = ++arrayPos + rightInvShift;
                                        sum += ja[jaOfs + (int)i];
                                        ++k;
                                        ++destArrayOffset;
                                    }
                                }
                                return;
                            }
                        }
                        int k = 0;
                        while (k < count) {
                            long i2;
                            dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                            for (long shift : right) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum -= ja[jaOfs + (int)i2];
                            }
                            if (++arrayPos == this.length) {
                                arrayPos = 0L;
                            }
                            for (long shift : left) {
                                i2 = arrayPos - shift;
                                if (i2 < 0L) {
                                    i2 += this.length;
                                }
                                sum += ja[jaOfs + (int)i2];
                            }
                            ++k;
                            ++destArrayOffset;
                        }
                    }
                };
            }
            return new AbstractDoubleArray(src.length(), true, new Array[]{src}){

                @Override
                public double getDouble(long index) {
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = index - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += a.getDouble(i);
                    }
                    return Summator.this.processingFunc.get(sum);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    if (!Summator.this.optimizeGetData) {
                        super.getData(arrayPos, destArray, destArrayOffset, count);
                        return;
                    }
                    Objects.requireNonNull(destArray, "Null destArray argument");
                    Summator.checkRanges(this.length, arrayPos, count);
                    if (count == 0) {
                        return;
                    }
                    double[] dest = (double[])destArray;
                    double sum = 0.0;
                    for (long shift : shifts) {
                        long i = arrayPos - shift;
                        if (i < 0L) {
                            i += this.length;
                        }
                        sum += a.getDouble(i);
                    }
                    int k = 0;
                    while (k < count) {
                        long i;
                        dest[destArrayOffset] = Summator.this.processingFunc.get(sum);
                        for (long shift : right) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum -= a.getDouble(i);
                        }
                        if (++arrayPos == this.length) {
                            arrayPos = 0L;
                        }
                        for (long shift : left) {
                            i = arrayPos - shift;
                            if (i < 0L) {
                                i += this.length;
                            }
                            sum += a.getDouble(i);
                        }
                        ++k;
                        ++destArrayOffset;
                    }
                }
            };
        }
        throw new AssertionError((Object)("Illegal array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processAlongAxis(UpdatablePArray dest, PArray src, long[] dimensions, int coordIndex, long min, long max) {
        block266: {
            block267: {
                if (!Summator.$assertionsDisabled && coordIndex <= 0) {
                    throw new AssertionError();
                }
                if (!Summator.$assertionsDisabled && max - min + 1L > 0x7FFFFFFFL) {
                    throw new AssertionError();
                }
                n = (int)(max - min + 1L);
                length = src.length();
                if (length == 0L) {
                    return;
                }
                meanFunc = this.linearFunc != false && this.lfA >= 0.0 && this.lfA <= 1.0 / (double)n && this.lfB >= 0.0 && this.lfB < 1.0;
                meanByPowerOfTwoFunc = meanFunc != false && this.dividingByPowerOfTwoWithRoundingFunc != false;
                layerSize = dimensions[0];
                for (k = 1; k < coordIndex; ++k) {
                    layerSize *= dimensions[k];
                }
                m = dimensions[coordIndex];
                for (k = coordIndex + 1; k < dimensions.length; ++k) {
                    m *= dimensions[k];
                }
                if (!Summator.$assertionsDisabled && m * layerSize != length) {
                    throw new AssertionError();
                }
                srcBitsPerElement = src.bitsPerElement();
                v0 /* !! */  = accElementType = srcBitsPerElement <= 16L && n <= 0x7FFFFFFF >> (int)srcBitsPerElement ? Integer.TYPE : Double.TYPE;
                if (!this.optimizeDirectArrays || layerSize > 0x7FFFFFFFL) ** GOTO lbl-1000
                v1 = layerSize;
                v2 = Arrays.sizeOf(accElementType) + (src instanceof BitArray != false ? 1.0 : Arrays.sizeOf(src.elementType()));
                v3 = dest instanceof BitArray != false ? 1.0 : Arrays.sizeOf(dest.elementType());
                if (v1 * (v2 + v3) < (double)Arrays.SystemSettings.maxTempJavaMemory()) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                direct = v4;
                startPart = (double)n / ((double)m + (double)n);
                contextStart = this.contextPart(0.0, startPart);
                contextMain = this.contextPart(startPart, 1.0);
                if (!direct) break block267;
                len = (int)layerSize;
                if (!Summator.$assertionsDisabled && (long)len != layerSize) {
                    throw new AssertionError();
                }
                intAcc = accElementType == Integer.TYPE ? new int[len] : null;
                doubleAcc = accElementType == Double.TYPE ? new double[len] : null;
                elementCounter = 0L;
                if (src instanceof BitArray) {
                    srcTypeCode = 1;
                    srcBuffer = srcBuf /* !! */  = new boolean[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        for (j = 0; j < len; ++j) {
                            if (!srcBuf /* !! */ [j]) continue;
                            v5 = j;
                            intAcc[v5] = intAcc[v5] + 1;
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof CharArray) {
                    srcTypeCode = 2;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new char[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        if (intAcc != null) {
                            for (j = 0; j < len; ++j) {
                                v6 = j;
                                intAcc[v6] = intAcc[v6] + (srcBuf /* !! */ [j] & 65535);
                            }
                        } else {
                            for (j = 0; j < len; ++j) {
                                v7 = j;
                                doubleAcc[v7] = doubleAcc[v7] + (double)(srcBuf /* !! */ [j] & 65535);
                            }
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof ByteArray) {
                    srcTypeCode = 3;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new byte[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        if (intAcc != null) {
                            for (j = 0; j < len; ++j) {
                                v8 = j;
                                intAcc[v8] = intAcc[v8] + (srcBuf /* !! */ [j] & 255);
                            }
                        } else {
                            for (j = 0; j < len; ++j) {
                                v9 = j;
                                doubleAcc[v9] = doubleAcc[v9] + (double)(srcBuf /* !! */ [j] & 255);
                            }
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof ShortArray) {
                    srcTypeCode = 4;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new short[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        if (intAcc != null) {
                            for (j = 0; j < len; ++j) {
                                v10 = j;
                                intAcc[v10] = intAcc[v10] + (srcBuf /* !! */ [j] & 65535);
                            }
                        } else {
                            for (j = 0; j < len; ++j) {
                                v11 = j;
                                doubleAcc[v11] = doubleAcc[v11] + (double)(srcBuf /* !! */ [j] & 65535);
                            }
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof IntArray) {
                    srcTypeCode = 5;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new int[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        for (j = 0; j < len; ++j) {
                            v12 = j;
                            doubleAcc[v12] = doubleAcc[v12] + (double)srcBuf /* !! */ [j];
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof LongArray) {
                    srcTypeCode = 6;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new long[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        for (j = 0; j < len; ++j) {
                            v13 = j;
                            doubleAcc[v13] = doubleAcc[v13] + (double)srcBuf /* !! */ [j];
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof FloatArray) {
                    srcTypeCode = 7;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new float[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        for (j = 0; j < len; ++j) {
                            v14 = j;
                            doubleAcc[v14] = doubleAcc[v14] + (double)srcBuf /* !! */ [j];
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else if (src instanceof DoubleArray) {
                    srcTypeCode = 8;
                    srcBuffer = srcBuf /* !! */  = (boolean[])new double[len];
                    for (shift = min; shift <= max; ++shift) {
                        i = -shift * layerSize % length;
                        if (i < 0L) {
                            i += length;
                        }
                        src.getData(i, srcBuf /* !! */ );
                        for (j = 0; j < len; ++j) {
                            v15 = j;
                            doubleAcc[v15] = doubleAcc[v15] + srcBuf /* !! */ [j];
                        }
                        if ((elementCounter += (long)len) <= 65536L || contextStart == null) continue;
                        elementCounter = 0L;
                        contextStart.checkInterruptionAndUpdateProgress(null, shift - min + 1L, n);
                    }
                } else {
                    throw new AssertionError((Object)("Illegal source array type (" + String.valueOf(src.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
                }
                if (dest instanceof BitArray) {
                    destTypeCode = 1;
                    destBuffer /* !! */  = new boolean[len];
                } else if (dest instanceof CharArray) {
                    destTypeCode = 2;
                    destBuffer /* !! */  = (boolean[])new char[len];
                } else if (dest instanceof ByteArray) {
                    destTypeCode = 3;
                    destBuffer /* !! */  = (boolean[])new byte[len];
                } else if (dest instanceof ShortArray) {
                    destTypeCode = 4;
                    destBuffer /* !! */  = (boolean[])new short[len];
                } else if (dest instanceof IntArray) {
                    destTypeCode = 5;
                    destBuffer /* !! */  = (boolean[])new int[len];
                } else if (dest instanceof LongArray) {
                    destTypeCode = 6;
                    destBuffer /* !! */  = (boolean[])new long[len];
                } else if (dest instanceof FloatArray) {
                    destTypeCode = 7;
                    destBuffer /* !! */  = (boolean[])new float[len];
                } else if (dest instanceof DoubleArray) {
                    destTypeCode = 8;
                    destBuffer /* !! */  = (boolean[])new double[len];
                } else {
                    throw new AssertionError((Object)("Illegal destination array type (" + String.valueOf(dest.getClass()) + "): it must implement one of primitive XxxArray interfaces"));
                }
                arrayPos = 0L;
                while (true) {
                    switch (destTypeCode) {
                        case 1: {
                            destBuf /* !! */  = destBuffer /* !! */ ;
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = this.processingFunc.get((double)intAcc[j]) != 0.0;
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = this.processingFunc.get(doubleAcc[j]) != 0.0;
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 2: {
                            destBuf /* !! */  = (boolean[])((char[])destBuffer /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v = (int)this.processingFunc.get((double)intAcc[j]);
                                    destBuf /* !! */ [j] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v = (int)this.processingFunc.get(doubleAcc[j]);
                                    destBuf /* !! */ [j] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 3: {
                            destBuf /* !! */  = (boolean[])((byte[])destBuffer /* !! */ );
                            if (intAcc != null) {
                                if (this.specialOptimizeThinPatternsPowersOfTwo && meanByPowerOfTwoFunc) {
                                    for (j = 0; j < len; ++j) {
                                        v = (long)intAcc[j] + this.halfDivisor >> this.logDivisor;
                                        destBuf /* !! */ [j] = (byte)v;
                                    }
                                } else if (meanFunc) {
                                    for (j = 0; j < len; ++j) {
                                        v = (int)(this.lfA * (double)intAcc[j] + this.lfB);
                                        destBuf /* !! */ [j] = (byte)v;
                                    }
                                } else if (this.linearFunc) {
                                    if (this.lfA == 1.0 && this.lfB == 0.0) {
                                        for (j = 0; j < len; ++j) {
                                            v = intAcc[j];
                                            destBuf /* !! */ [j] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            v = (int)(this.lfA * (double)intAcc[j] + this.lfB);
                                            destBuf /* !! */ [j] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                                        }
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        v = (int)this.processingFunc.get((double)intAcc[j]);
                                        destBuf /* !! */ [j] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                                    }
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v = (int)this.processingFunc.get(doubleAcc[j]);
                                    destBuf /* !! */ [j] = (byte)(v < 0 ? 0 : (v > 255 ? 255 : v));
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 4: {
                            destBuf /* !! */  = (boolean[])((short[])destBuffer /* !! */ );
                            if (intAcc != null) {
                                if (this.specialOptimizeThinPatternsPowersOfTwo && meanByPowerOfTwoFunc) {
                                    for (j = 0; j < len; ++j) {
                                        v = (long)intAcc[j] + this.halfDivisor >> this.logDivisor;
                                        destBuf /* !! */ [j] = (short)v;
                                    }
                                } else if (meanFunc) {
                                    for (j = 0; j < len; ++j) {
                                        v = (int)(this.lfA * (double)intAcc[j] + this.lfB);
                                        destBuf /* !! */ [j] = (short)v;
                                    }
                                } else if (this.linearFunc) {
                                    if (this.lfA == 1.0 && this.lfB == 0.0) {
                                        for (j = 0; j < len; ++j) {
                                            v = intAcc[j];
                                            destBuf /* !! */ [j] = (short)(v < 0 ? 0 : (v > 65535 ? 65535 : v));
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            v = (int)(this.lfA * (double)intAcc[j] + this.lfB);
                                            destBuf /* !! */ [j] = (short)(v < 0 ? 0 : (v > 65535 ? 65535 : v));
                                        }
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        v = (int)this.processingFunc.get((double)intAcc[j]);
                                        destBuf /* !! */ [j] = (short)(v < 0 ? 0 : (v > 65535 ? 65535 : v));
                                    }
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v = (int)this.processingFunc.get(doubleAcc[j]);
                                    destBuf /* !! */ [j] = (short)(v < 0 ? 0 : (v > 65535 ? 65535 : v));
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 5: {
                            destBuf /* !! */  = (boolean[])((int[])destBuffer /* !! */ );
                            if (this.linearFunc) {
                                if (this.lfB != 0.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (int)(this.lfA * (double)intAcc[j] + this.lfB);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (int)(this.lfA * doubleAcc[j] + this.lfB);
                                        }
                                    }
                                } else if (this.lfA != 1.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (int)(this.lfA * (double)intAcc[j]);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (int)(this.lfA * doubleAcc[j]);
                                        }
                                    }
                                } else {
                                    if (!(Summator.$assertionsDisabled || this.lfA == 1.0 && this.lfB == 0.0)) {
                                        throw new AssertionError();
                                    }
                                    if (intAcc != null) {
                                        dest.setData(arrayPos, intAcc);
                                        break;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = (int)doubleAcc[j];
                                    }
                                }
                            } else if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (int)this.processingFunc.get((double)intAcc[j]);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (int)this.processingFunc.get(doubleAcc[j]);
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 6: {
                            destBuf /* !! */  = (boolean[])((long[])destBuffer /* !! */ );
                            if (this.linearFunc) {
                                if (this.lfB != 0.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (long)(this.lfA * (double)intAcc[j] + this.lfB);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (long)(this.lfA * doubleAcc[j] + this.lfB);
                                        }
                                    }
                                } else if (this.lfA != 1.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (long)(this.lfA * (double)intAcc[j]);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (long)(this.lfA * doubleAcc[j]);
                                        }
                                    }
                                } else {
                                    if (!(Summator.$assertionsDisabled || this.lfA == 1.0 && this.lfB == 0.0)) {
                                        throw new AssertionError();
                                    }
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = intAcc[j];
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (long)doubleAcc[j];
                                        }
                                    }
                                }
                            } else if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (long)this.processingFunc.get((double)intAcc[j]);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (long)this.processingFunc.get(doubleAcc[j]);
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 7: {
                            destBuf /* !! */  = (boolean[])((float[])destBuffer /* !! */ );
                            if (this.linearFunc) {
                                if (this.lfB != 0.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (float)(this.lfA * (double)intAcc[j] + this.lfB);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (float)(this.lfA * doubleAcc[j] + this.lfB);
                                        }
                                    }
                                } else if (this.lfA != 1.0) {
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (float)(this.lfA * (double)intAcc[j]);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (float)(this.lfA * doubleAcc[j]);
                                        }
                                    }
                                } else {
                                    if (!(Summator.$assertionsDisabled || this.lfA == 1.0 && this.lfB == 0.0)) {
                                        throw new AssertionError();
                                    }
                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = intAcc[j];
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = (float)doubleAcc[j];
                                        }
                                    }
                                }
                            } else if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (float)this.processingFunc.get((double)intAcc[j]);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    destBuf /* !! */ [j] = (float)this.processingFunc.get(doubleAcc[j]);
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        case 8: {
                            destBuf /* !! */  = (boolean[])((double[])destBuffer /* !! */ );
                            if (!this.linearFunc) ** GOTO lbl507
                            if (this.lfB != 0.0) {
                                if (intAcc != null) {
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = this.lfA * (double)intAcc[j] + this.lfB;
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = this.lfA * doubleAcc[j] + this.lfB;
                                    }
                                }
                            } else if (this.lfA != 1.0) {
                                if (intAcc != null) {
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = this.lfA * (double)intAcc[j];
                                    }
                                } else {
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = this.lfA * doubleAcc[j];
                                    }
                                }
                            } else {
                                if (!(Summator.$assertionsDisabled || this.lfA == 1.0 && this.lfB == 0.0)) {
                                    throw new AssertionError();
                                }
                                if (intAcc != null) {
                                    for (j = 0; j < len; ++j) {
                                        destBuf /* !! */ [j] = intAcc[j];
                                    }
                                } else {
                                    dest.setData(arrayPos, doubleAcc);
                                    break;
lbl507:
                                    // 1 sources

                                    if (intAcc != null) {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = this.processingFunc.get((double)intAcc[j]);
                                        }
                                    } else {
                                        for (j = 0; j < len; ++j) {
                                            destBuf /* !! */ [j] = this.processingFunc.get(doubleAcc[j]);
                                        }
                                    }
                                }
                            }
                            dest.setData(arrayPos, destBuf /* !! */ );
                            break;
                        }
                        default: {
                            throw new InternalError("Cannot occur");
                        }
                    }
                    if (arrayPos + layerSize == length) break block266;
                    i1 = (arrayPos - max * layerSize) % length;
                    if (i1 < 0L) {
                        i1 += length;
                    }
                    if (!Summator.$assertionsDisabled && (arrayPos += layerSize) > length - layerSize) {
                        throw new AssertionError();
                    }
                    i2 = (arrayPos - min * layerSize) % length;
                    if (i2 < 0L) {
                        i2 += length;
                    }
                    switch (srcTypeCode) {
                        case 1: {
                            srcBuf /* !! */  = srcBuffer;
                            src.getData(i1, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                if (!srcBuf /* !! */ [j]) continue;
                                v16 = j;
                                intAcc[v16] = intAcc[v16] - 1;
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                if (!srcBuf /* !! */ [j]) continue;
                                v17 = j;
                                intAcc[v17] = intAcc[v17] + 1;
                            }
                            break;
                        }
                        case 2: {
                            srcBuf /* !! */  = (boolean[])((char[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v18 = j;
                                    intAcc[v18] = intAcc[v18] - (srcBuf /* !! */ [j] & 65535);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v19 = j;
                                    doubleAcc[v19] = doubleAcc[v19] - (double)(srcBuf /* !! */ [j] & 65535);
                                }
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v20 = j;
                                    intAcc[v20] = intAcc[v20] + (srcBuf /* !! */ [j] & 65535);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v21 = j;
                                    doubleAcc[v21] = doubleAcc[v21] + (double)(srcBuf /* !! */ [j] & 65535);
                                }
                            }
                            break;
                        }
                        case 3: {
                            srcBuf /* !! */  = (boolean[])((byte[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v22 = j;
                                    intAcc[v22] = intAcc[v22] - (srcBuf /* !! */ [j] & 255);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v23 = j;
                                    doubleAcc[v23] = doubleAcc[v23] - (double)(srcBuf /* !! */ [j] & 255);
                                }
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v24 = j;
                                    intAcc[v24] = intAcc[v24] + (srcBuf /* !! */ [j] & 255);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v25 = j;
                                    doubleAcc[v25] = doubleAcc[v25] + (double)(srcBuf /* !! */ [j] & 255);
                                }
                            }
                            break;
                        }
                        case 4: {
                            srcBuf /* !! */  = (boolean[])((short[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v26 = j;
                                    intAcc[v26] = intAcc[v26] - (srcBuf /* !! */ [j] & 65535);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v27 = j;
                                    doubleAcc[v27] = doubleAcc[v27] - (double)(srcBuf /* !! */ [j] & 65535);
                                }
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            if (intAcc != null) {
                                for (j = 0; j < len; ++j) {
                                    v28 = j;
                                    intAcc[v28] = intAcc[v28] + (srcBuf /* !! */ [j] & 65535);
                                }
                            } else {
                                for (j = 0; j < len; ++j) {
                                    v29 = j;
                                    doubleAcc[v29] = doubleAcc[v29] + (double)(srcBuf /* !! */ [j] & 65535);
                                }
                            }
                            break;
                        }
                        case 5: {
                            srcBuf /* !! */  = (boolean[])((int[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v30 = j;
                                doubleAcc[v30] = doubleAcc[v30] - (double)srcBuf /* !! */ [j];
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v31 = j;
                                doubleAcc[v31] = doubleAcc[v31] + (double)srcBuf /* !! */ [j];
                            }
                            break;
                        }
                        case 6: {
                            srcBuf /* !! */  = (boolean[])((long[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v32 = j;
                                doubleAcc[v32] = doubleAcc[v32] - (double)srcBuf /* !! */ [j];
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v33 = j;
                                doubleAcc[v33] = doubleAcc[v33] + (double)srcBuf /* !! */ [j];
                            }
                            break;
                        }
                        case 7: {
                            srcBuf /* !! */  = (boolean[])((float[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v34 = j;
                                doubleAcc[v34] = doubleAcc[v34] - (double)srcBuf /* !! */ [j];
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v35 = j;
                                doubleAcc[v35] = doubleAcc[v35] + (double)srcBuf /* !! */ [j];
                            }
                            break;
                        }
                        case 8: {
                            srcBuf /* !! */  = (boolean[])((double[])srcBuffer);
                            src.getData(i1, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v36 = j;
                                doubleAcc[v36] = doubleAcc[v36] - srcBuf /* !! */ [j];
                            }
                            src.getData(i2, srcBuf /* !! */ );
                            for (j = 0; j < len; ++j) {
                                v37 = j;
                                doubleAcc[v37] = doubleAcc[v37] + srcBuf /* !! */ [j];
                            }
                            break;
                        }
                        default: {
                            throw new InternalError("Impossible switch case");
                        }
                    }
                    if ((elementCounter += (long)len) <= 65536L || contextMain == null) continue;
                    elementCounter = 0L;
                    contextMain.checkInterruptionAndUpdateProgress(null, arrayPos, length);
                }
            }
            updater = LinearFunc.getInstance(0.0, new double[]{1.0, -1.0, 1.0});
            acc = (UpdatablePArray)this.memoryModel().newUnresizableArray(accElementType, layerSize);
            for (shift = min; shift <= max; ++shift) {
                i = -shift * layerSize % length;
                if (i < 0L) {
                    i += length;
                }
                Arrays.applyFunc(contextStart == null ? null : contextStart.part(shift - min, shift - min + 1L, (long)n), false, Func.X_PLUS_Y, acc, new PArray[]{acc, (PArray)src.subArr(i, layerSize)});
            }
            arrayPos = 0L;
            while (true) {
                halfPos = arrayPos + layerSize / 2L;
                Arrays.applyFunc(contextMain == null ? null : contextMain.part(arrayPos, halfPos, length), true, this.processingFunc, dest.subArr(arrayPos, layerSize), new PArray[]{acc});
                if (arrayPos + layerSize == length) break;
                i1 = (arrayPos - max * layerSize) % length;
                if (i1 < 0L) {
                    i1 += length;
                }
                if (!Summator.$assertionsDisabled && (arrayPos += layerSize) > length - layerSize) {
                    throw new AssertionError();
                }
                i2 = (arrayPos - min * layerSize) % length;
                if (i2 < 0L) {
                    i2 += length;
                }
                Arrays.applyFunc(contextMain == null ? null : contextMain.part(halfPos, arrayPos, length), false, updater, acc, new PArray[]{acc, (PArray)src.subArr(i1, layerSize), (PArray)src.subArr(i2, layerSize)});
            }
        }
        if (contextMain != null) {
            contextMain.checkInterruptionAndUpdateProgress(accElementType, length, length);
        }
    }

    private static void checkRanges(long length, long arrayPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw new IndexOutOfBoundsException("arrayPos = " + arrayPos + " < 0");
        }
        if (arrayPos > length - (long)count) {
            throw new IndexOutOfBoundsException("arrayPos+count = " + arrayPos + "+" + count + " > length=" + length);
        }
    }
}

