/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.skeletons.AbstractThinningSkeleton2D;
import net.algart.matrices.skeletons.ThinningSkeleton;
import net.algart.matrices.skeletons.ThinningTools;

public class OctupleThinningSkeleton2D
extends AbstractThinningSkeleton2D
implements ThinningSkeleton {
    private static final int[][] SKELETON_XP = new int[][]{{1, 0}, {-1, 0}, {1, 1}, {0, 1}, {1, -1}, {0, -1}, {0, 1, 0, -1, -1, 1, -1, -1}};
    private static final int[][] SKELETON_YP = ThinningTools.rotate90(SKELETON_XP);
    private static final int[][] SKELETON_XM = ThinningTools.rotate180(SKELETON_XP);
    private static final int[][] SKELETON_YM = ThinningTools.rotate270(SKELETON_XP);
    private static final int[][][] QUADRUPLE_SKELETON = new int[][][]{SKELETON_XP, SKELETON_YP, SKELETON_XM, SKELETON_YM};
    private static final int[][] SKELETON_XPYP = new int[][]{{1, 0, 1, 1, 0, 1}, {0, -1, -1, 0}, {1, -1, 1, 0, 1, 1, 0, 1, -1, 1}};
    private static final int[][] SKELETON_XMYP = ThinningTools.rotate90(SKELETON_XPYP);
    private static final int[][] SKELETON_XMYM = ThinningTools.rotate180(SKELETON_XPYP);
    private static final int[][] SKELETON_XPYM = ThinningTools.rotate270(SKELETON_XPYP);
    private static final int[][][] DIAGONAL_SKELETON = new int[][][]{SKELETON_XPYP, SKELETON_XMYP, SKELETON_XMYM, SKELETON_XPYM};
    private final boolean topological;

    private OctupleThinningSkeleton2D(ArrayContext arrayContext, Matrix<? extends UpdatableBitArray> matrix, boolean diagonalThinning, boolean topological) {
        super(arrayContext, matrix, true, diagonalThinning);
        this.topological = topological;
    }

    public static OctupleThinningSkeleton2D getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix, boolean diagonalThinning, boolean topological) {
        return new OctupleThinningSkeleton2D(context, matrix, diagonalThinning, topological);
    }

    public static OctupleThinningSkeleton2D getInstance(ArrayContext context, Matrix<? extends UpdatableBitArray> matrix) {
        return new OctupleThinningSkeleton2D(context, matrix, true, false);
    }

    @Override
    public long estimatedNumberOfIterations() {
        return ThinningTools.estimatedNumberOfIterations(this.result, this.topological);
    }

    @Override
    public Matrix<BitArray> asThinning(int directionIndex) {
        if (directionIndex < 0 || directionIndex > 7) {
            throw new IllegalArgumentException("Illegal directionIndex = " + directionIndex + " (must be 0..7)");
        }
        if (directionIndex % 2 == 0) {
            return OctupleThinningSkeleton2D.asQuadrupleThinning(this.result, directionIndex / 2, this.topological);
        }
        return OctupleThinningSkeleton2D.asDiagonalThinning(this.result, directionIndex / 2, this.topological);
    }

    public String toString() {
        return "octuple thinning 2D skeletonizer, " + (this.diagonalThinning ? "8 steps" : "4 steps") + (this.topological ? ", topological mode" : "");
    }

    private static Matrix<BitArray> asQuadrupleThinning(Matrix<? extends BitArray> matrix, int directionIndex, boolean topological) {
        Matrix<BitArray> notRemoved;
        int[][] points = QUADRUPLE_SKELETON[directionIndex];
        Matrix<BitArray> internal = ThinningTools.shift(matrix, points[0]);
        Matrix<BitArray> internalOrThin = ThinningTools.or(internal, ThinningTools.not(ThinningTools.shift(matrix, points[1])));
        Matrix<BitArray> topArticulation = ThinningTools.andNot(ThinningTools.shift(matrix, points[2]), ThinningTools.shift(matrix, points[3]));
        Matrix<BitArray> bottomArticulation = ThinningTools.andNot(ThinningTools.shift(matrix, points[4]), ThinningTools.shift(matrix, points[5]));
        if (topological) {
            notRemoved = ThinningTools.or(internalOrThin, topArticulation, bottomArticulation);
        } else {
            Matrix<BitArray> dilation4Points = ThinningTools.or(ThinningTools.shifts(matrix, points[6]));
            notRemoved = ThinningTools.or(internalOrThin, topArticulation, bottomArticulation, ThinningTools.not(dilation4Points));
        }
        return ThinningTools.and(matrix, notRemoved);
    }

    static Matrix<BitArray> asDiagonalThinning(Matrix<? extends BitArray> matrix, int directionIndex, boolean topological) {
        int[][] points = DIAGONAL_SKELETON[directionIndex];
        Matrix<BitArray> dilationInvCorner3Points = ThinningTools.or(ThinningTools.shifts(matrix, points[0]));
        Matrix<BitArray> erosionCorner3Points = ThinningTools.and(ThinningTools.shifts(matrix, points[1]));
        Matrix<BitArray> weakErosion = ThinningTools.or(dilationInvCorner3Points, ThinningTools.not(erosionCorner3Points));
        if (topological) {
            Matrix<BitArray> dilation5Points = ThinningTools.or(ThinningTools.shifts(matrix, points[2]));
            return ThinningTools.and(matrix, weakErosion, dilation5Points);
        }
        return ThinningTools.and(matrix, weakErosion);
    }
}

