/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.matrices.stitching.Frame;
import net.algart.matrices.stitching.FramePosition;

public class DefaultFrame<P extends FramePosition>
implements Frame<P> {
    private final Matrix<? extends PArray> matrix;
    private final P position;

    protected DefaultFrame(Matrix<? extends PArray> matrix, P position) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        Objects.requireNonNull(position, "Null position argument");
        if (matrix.dimCount() != position.area().coordCount()) {
            throw new IllegalArgumentException("Different number of dimensions in passed matrix and position: position coordinates are " + String.valueOf(position.area()) + ", matrix is " + String.valueOf(matrix));
        }
        this.matrix = matrix;
        this.position = position;
    }

    public static <P extends FramePosition> DefaultFrame<P> of(Matrix<? extends PArray> matrix, P position) {
        return new DefaultFrame<P>(matrix, position);
    }

    @Override
    public int dimCount() {
        return this.matrix().dimCount();
    }

    @Override
    public Matrix<? extends PArray> matrix() {
        return this.matrix;
    }

    @Override
    public P position() {
        return this.position;
    }

    @Override
    public void freeResources() {
        this.matrix.freeResources();
    }

    public String toString() {
        return "frame " + String.valueOf(this.matrix()) + " at " + String.valueOf(this.position());
    }

    @Override
    public int hashCode() {
        return this.matrix().hashCode() * 37 + this.position().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Frame && this.matrix().equals(((Frame)obj).matrix()) && this.position().equals(((Frame)obj).position());
    }
}

