/*
 * Decompiled with CFR 0.152.
 */
package com.siams.data.vpjson.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.siams.data.vpjson.VideoPanoramaJson;
import com.siams.data.vpjson.project.classify.Classifier;
import com.siams.data.vpjson.project.contour.Contours;
import com.siams.data.vpjson.project.filter.Filter;
import com.siams.data.vpjson.project.filter.Plugin;
import com.siams.data.vpjson.project.filter.Segmentation;
import com.siams.data.vpjson.project.filter.plugin.StarePlugin;
import com.siams.data.vpjson.project.scan.ScanProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Project {
    @JsonProperty(value="title")
    protected String title = "default";
    @JsonProperty(value="step_title")
    protected String stepTitle;
    @JsonProperty(value="step_uid")
    protected String stepUid;
    @JsonProperty(value="filters")
    protected List<Filter> filters = new ArrayList<Filter>();
    @JsonProperty(value="scan_proc")
    protected ScanProcess scanProcess;
    @JsonProperty(value="classify")
    protected List<Classifier> classifier = new ArrayList<Classifier>();
    @JsonProperty(value="contours")
    protected Contours contours = new Contours();

    public Project(String title) {
        this.title = title;
    }

    @JsonCreator
    public Project() {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? "default" : (title.isEmpty() ? "default" : title);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public ScanProcess getScanProcess() {
        return this.scanProcess;
    }

    public void setScanProcess(ScanProcess scanProcess) {
        this.scanProcess = scanProcess;
    }

    public List<Classifier> getClassifier() {
        return this.classifier;
    }

    public void setClassifier(List<Classifier> classifier) {
        this.classifier = classifier;
    }

    public String getStepTitle() {
        return this.stepTitle;
    }

    public void setStepTitle(String stepTitle) {
        this.stepTitle = stepTitle;
    }

    public String getStepUid() {
        return this.stepUid;
    }

    public void setStepUid(String stepUid) {
        this.stepUid = stepUid;
    }

    public Contours getContours() {
        return this.contours;
    }

    public void setContours(Contours contours) {
        this.contours = contours;
    }

    public Optional<Filter> findFirstFilter(Filter.Type type) {
        if (this.filters == null) {
            return Optional.empty();
        }
        return this.filters.stream().filter(filter -> {
            Filter.Type filterType = Filter.Type.of(filter.getFilterType());
            return filterType.equals((Object)type);
        }).findFirst();
    }

    public Optional<Plugin> findFirstPlugin(String pluginName, String filterName) {
        for (Filter filter : this.filters) {
            Plugin plugin;
            if (!filter.getFilterType().equals(Filter.Type.PLUGIN.toString()) || !(plugin = (Plugin)filter).getPluginName().equals(pluginName) || !plugin.getFilterName().equals(filterName)) continue;
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    public Optional<StarePlugin> findStarePlugin() {
        return this.findFirstPlugin("stare", "stare_ex").map(plugin -> (StarePlugin)plugin);
    }

    public Optional<Segmentation> findSegmentationFilter() {
        return this.findFirstFilter(Filter.Type.SEGMENTATION).map(filter -> (Segmentation)filter);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void addFilter(int index, Filter filter) {
        this.filters.add(index, filter);
    }

    public Filter removeFirstFilter(String pluginName, String filterName) {
        return VideoPanoramaJson.findAndRemove(this.filters, filter -> {
            if (filter.getFilterType().equals(Filter.Type.PLUGIN.toString())) {
                Plugin plugin = (Plugin)filter;
                return plugin.getPluginName().equals(pluginName) && plugin.getFilterName().equals(filterName);
            }
            return false;
        });
    }

    public StarePlugin removeStarePlugin() {
        return (StarePlugin)this.removeFirstFilter("stare", "stare_ex");
    }

    public Filter replacePlugin(String pluginName, String filterName, Filter newPlugin) {
        Filter removed = null;
        ListIterator<Filter> iterator = this.filters.listIterator();
        while (iterator.hasNext()) {
            Plugin plugin;
            Filter filter = iterator.next();
            if (!filter.getFilterType().equals(Filter.Type.PLUGIN.toString()) || !(plugin = (Plugin)filter).getPluginName().equals(pluginName) || !plugin.getFilterName().equals(filterName)) continue;
            iterator.set(newPlugin);
            removed = filter;
        }
        return removed;
    }

    public Filter replaceFilter(Filter.Type type, Filter newFilter) {
        Filter removed = null;
        ListIterator<Filter> iterator = this.filters.listIterator();
        while (iterator.hasNext()) {
            Filter filter = iterator.next();
            if (!filter.getFilterType().equals(type.toString())) continue;
            iterator.set(newFilter);
            removed = filter;
        }
        return removed;
    }
}

