/*
 * Decompiled with CFR 0.152.
 */
package com.siams.data.vpjson.project.filter.plugin.stare;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.data.vpjson.VideoPanoramaJson;
import com.siams.data.vpjson.project.filter.plugin.stare.Control;
import com.siams.data.vpjson.project.filter.plugin.stare.DataBind;
import com.siams.data.vpjson.project.filter.plugin.stare.StareControl;
import com.siams.data.vpjson.project.filter.plugin.stare.set.Set;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Settings {
    @JsonProperty(value="stare_project_file")
    private String stareProjectFile = "";
    @JsonProperty(value="controls")
    private List<Control> controls = new ArrayList<Control>();
    @JsonProperty(value="stare_controls")
    private List<StareControl> stareControls = new ArrayList<StareControl>();
    @JsonProperty(value="data_bind")
    private List<DataBind> dataBinds = new ArrayList<DataBind>();
    @JsonProperty(value="sets")
    private List<Set> sets = new ArrayList<Set>();

    @JsonGetter(value="stare_project_file")
    public String getStareProjectFile() {
        return this.stareProjectFile;
    }

    @JsonSetter(value="stare_project_file")
    public void setStareProjectFile(String stareProjectFile) {
        this.stareProjectFile = stareProjectFile;
    }

    @JsonGetter(value="controls")
    public List<Control> getControls() {
        return this.controls;
    }

    @JsonSetter(value="controls")
    public void setControls(List<Control> controls) {
        this.controls = controls;
    }

    @JsonGetter(value="stare_controls")
    public List<StareControl> getStareControls() {
        return this.stareControls;
    }

    @JsonSetter(value="stare_controls")
    public void setStareControls(List<StareControl> stareControls) {
        this.stareControls = stareControls;
    }

    @JsonGetter(value="data_bind")
    public List<DataBind> getDataBinds() {
        return this.dataBinds;
    }

    @JsonSetter(value="data_bind")
    public void setDataBinds(List<DataBind> dataBinds) {
        this.dataBinds = dataBinds;
    }

    @JsonGetter(value="sets")
    public List<Set> getSets() {
        return this.sets;
    }

    @JsonSetter(value="sets")
    public void setSets(List<Set> sets) {
        this.sets = sets;
    }

    public Optional<StareControl> findFirstStareControl(UUID uid) {
        return this.findFirstStareControl(uid.toString());
    }

    public Optional<StareControl> findFirstStareControl(String id) {
        Objects.requireNonNull(id, "Data process uuid required");
        return this.stareControls.stream().filter(stareControl -> stareControl.getDataProcessUuid().equals(id)).findFirst();
    }

    public void addStareControl(StareControl stareControl) {
        this.stareControls.add(stareControl);
    }

    public Control removeControl(String name) {
        Objects.requireNonNull(name, "Name required");
        return VideoPanoramaJson.findAndRemove(this.controls, control -> control.getName().equals(name));
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    public void addControl(int index, Control control) {
        this.controls.add(index, control);
    }

    public Optional<Control> findFirstControl(String name) {
        Objects.requireNonNull(name, "Control name required");
        return this.controls.stream().filter(control -> control.getName().equals(name)).findFirst();
    }

    public int findFirstControlIndex(String name) {
        Objects.requireNonNull(name, "Control name required");
        int found = -1;
        int size = this.controls.size();
        for (int i = 0; i < size; ++i) {
            if (!this.controls.get(i).getName().equals(name)) continue;
            found = i;
            break;
        }
        return found;
    }

    public StareControl removeStareControl(UUID uid) {
        String controlName;
        Objects.requireNonNull(uid, "Uid required");
        String id = uid.toString();
        StareControl removed = VideoPanoramaJson.findAndRemove(this.stareControls, ctrl -> {
            String ctrlId = ctrl.getDataProcessUuid();
            return ctrlId != null && ctrlId.equals(id);
        });
        if (removed != null && (controlName = removed.getControlName()) != null) {
            this.removeControl(controlName);
        }
        return removed;
    }

    public void setControlsOrder(List<String> orderNames) {
        int actualPosition = 0;
        for (String controlName : orderNames) {
            int currentPosition = this.findFirstControlIndex(controlName);
            if (currentPosition == -1) continue;
            if (currentPosition != actualPosition) {
                Collections.swap(this.controls, currentPosition, actualPosition);
            }
            ++actualPosition;
        }
    }
}

