/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.ConnectionModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.UUID;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UILinkModel
extends ConnectionModel {
    private static Logger logger = Logger.getLogger(UILinkModel.class);
    public static String id = "UILinkModel";

    @JsonCreator
    UILinkModel() {
    }

    @Override
    public void release() {
    }

    public static UILinkModel parseFromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (UILinkModel)mapper.readValue(json, UILinkModel.class);
    }

    public static Optional<UILinkModel> valueOf(String json) {
        Optional<UILinkModel> opt = Optional.empty();
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jLink = reader.readObject();
            UUID linkId = UUID.fromString(jLink.getString("id"));
            UUID srcPortId = UUID.fromString(jLink.getString("src_port_id"));
            UUID destPortId = UUID.fromString(jLink.getString("dest_port_id"));
            UILinkModel uiLinkModel = new Builder().setUuid(linkId).setSrcPortUuid(srcPortId).setDestPortUuid(destPortId).build();
            opt = Optional.of(uiLinkModel);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Failed parse link:\n%s", json), t);
        }
        return opt;
    }

    @Override
    public String getRelUrl() {
        return String.format("/link:%s", this.getUuid());
    }

    public String toString() {
        return "UILinkModel{srcPortUuid=" + String.valueOf(this.srcPortUuid) + ", destPortUuid=" + String.valueOf(this.destPortUuid) + ", uuid=" + String.valueOf(this.uuid) + "}";
    }

    @JsonIgnore
    public void setPort(UIPortModel uiPortModel) {
        PortType portType = uiPortModel.getPortType();
        if (portType.isOutput()) {
            this.setSrcPortUuid(uiPortModel.getUuid());
        } else if (portType.isInput()) {
            this.setDestPortUuid(uiPortModel.getUuid());
        }
    }

    public static class Builder {
        private UUID linkUuid;
        private UUID srcPortUuid;
        private UUID destPortUuid;

        public Builder setUuid(UUID linkUuid) {
            this.linkUuid = linkUuid;
            return this;
        }

        public Builder setSrcPortUuid(UUID srcPortUuid) {
            this.srcPortUuid = srcPortUuid;
            return this;
        }

        public Builder setDestPortUuid(UUID destPortUuid) {
            this.destPortUuid = destPortUuid;
            return this;
        }

        public UILinkModel build() {
            UILinkModel model = new UILinkModel();
            model.setUuid(this.linkUuid);
            model.setSrcPortUuid(this.srcPortUuid);
            model.setDestPortUuid(this.destPortUuid);
            return model;
        }
    }
}

