/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.node.PortDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UIPortModel
extends NodeModel {
    @JsonProperty(value="visible")
    private Boolean visible;
    @JsonProperty(value="port_type")
    private PortType portType;
    @JsonProperty(value="data_type_uuid")
    private UUID dataTypeUuid;
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="caption")
    private String caption = "";
    @JsonIgnore
    private String hint = "";
    @JsonIgnore
    private boolean optional;
    @JsonIgnore
    private boolean slave;
    @JsonIgnore
    private UIPortModel hostPort;
    @JsonIgnore
    private List<UIPortModel> slavePorts = new ArrayList<UIPortModel>();

    @JsonCreator
    UIPortModel() {
    }

    @JsonGetter(value="visible")
    public boolean isVisible() {
        return this.visible == null ? false : this.visible;
    }

    @JsonSetter(value="visible")
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @JsonGetter(value="port_type")
    public PortType getPortType() {
        return this.portType;
    }

    @JsonSetter(value="port_type")
    public void setPortType(PortType portType) {
        this.portType = portType;
    }

    @JsonGetter(value="data_type_uuid")
    public UUID getDataTypeUuid() {
        return this.dataTypeUuid;
    }

    @JsonSetter(value="data_type_uuid")
    public void setDataTypeUuid(UUID dataTypeUuid) {
        this.dataTypeUuid = dataTypeUuid;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public PortDataType getDataType() {
        return PortDataType.findDataType(this.dataTypeUuid);
    }

    @JsonIgnore
    public void setDataType(PortDataType dataType) {
        this.dataTypeUuid = dataType.getUuid();
    }

    @JsonIgnore
    public String getCaption() {
        return this.caption;
    }

    @JsonIgnore
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonIgnore
    public String getHint() {
        return this.hint;
    }

    @JsonIgnore
    public void setHint(String hint) {
        this.hint = hint;
    }

    @JsonIgnore
    public boolean isOptional() {
        return this.optional;
    }

    @JsonIgnore
    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @JsonIgnore
    public boolean isSlave() {
        return this.slave;
    }

    @JsonIgnore
    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    @JsonIgnore
    public UIPortModel getHostPort() {
        return this.hostPort;
    }

    @JsonIgnore
    public void setHostPort(UIPortModel hostPort) {
        this.hostPort = hostPort;
    }

    @JsonIgnore
    public List<UIPortModel> getSlavePorts() {
        return this.slavePorts;
    }

    @JsonIgnore
    public void setSlavePorts(List<UIPortModel> slavePorts) {
        this.slavePorts = slavePorts;
    }

    @JsonIgnore
    public void addSlavePort(UIPortModel slavePort) {
        this.slavePorts.add(slavePort);
    }

    @JsonIgnore
    public void copyFrom(UIPortModel portModelToCopy) {
        this.setVisible(portModelToCopy.isVisible());
        this.setPortType(portModelToCopy.getPortType());
        this.setDataType(portModelToCopy.getDataType());
        this.setName(portModelToCopy.getName());
        this.setCaption(portModelToCopy.getCaption());
        this.setHint(portModelToCopy.getHint());
        this.setOptional(portModelToCopy.isOptional());
        this.setSlave(portModelToCopy.isSlave());
        this.setHostPort(portModelToCopy.getHostPort());
    }

    @Override
    public void release() {
    }

    public String toString() {
        return "UIPortModel{visible=" + this.visible + ", portType=" + String.valueOf((Object)this.portType) + ", uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "'}";
    }

    public static class Builder {
        private UUID uuid;
        private Boolean visible;
        private boolean optional;
        private PortType portType;
        private UUID dataTypeUuid;
        private String name;
        private String caption = "";

        public Builder setUuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder setPortType(PortType portType) {
            this.portType = portType;
            return this;
        }

        public Builder setPortType(int portType) {
            this.portType = PortType.of(portType);
            return this;
        }

        public Builder setDataTypeUuid(UUID dataTypeUuid) {
            this.dataTypeUuid = dataTypeUuid;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public UIPortModel build() {
            Objects.requireNonNull(this.uuid);
            if (this.visible == null) {
                switch (this.portType) {
                    case INPUT_CONTROL: 
                    case OUTPUT_CONTROL: {
                        this.visible = false;
                        break;
                    }
                    case INPUT: 
                    case OUTPUT: {
                        this.visible = !this.optional;
                        break;
                    }
                    default: {
                        throw new EnumConstantNotPresentException(PortType.class, this.portType.toString());
                    }
                }
            }
            UIPortModel portModel = new UIPortModel();
            portModel.setUuid(this.uuid);
            portModel.setPortType(this.portType);
            portModel.setDataTypeUuid(this.dataTypeUuid);
            portModel.setVisible(this.visible);
            portModel.setOptional(this.optional);
            portModel.setName(this.name);
            portModel.setCaption(this.caption);
            return portModel;
        }
    }
}

