/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.viewer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.uuid.UuidUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javafx.geometry.Point2D;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CompareViewerModel
extends ViewerModel {
    public static String id = "CompareViewerModel";
    @JsonProperty(value="storage_key")
    private String key = "";
    @JsonProperty(value="viewers")
    private List<ViewerModel> viewerModels = new ArrayList<ViewerModel>();
    @JsonProperty(value="title")
    private String title = "";
    @JsonProperty(value="order")
    private Integer order = -1;
    @JsonProperty(value="splitter_position")
    private Double splitterPosition = 0.8;
    @JsonProperty(value="update_instantly")
    protected Boolean updateInstantly = false;
    @JsonIgnore
    private Map<Integer, Point2D> benchmarkPoints = new HashMap<Integer, Point2D>();

    @JsonCreator
    public CompareViewerModel() {
    }

    public CompareViewerModel(int order) {
        this.setOrder(order);
        this.setUuid(CompareViewerModel.CreateUuid(order));
        this.setKind(ViewerKind.COMPARE.toString());
    }

    @JsonGetter(value="storage_key")
    public String getStorageKey() {
        return this.key;
    }

    @JsonSetter(value="storage_key")
    public void setStorageKey(String key) {
        this.key = key;
        this.invokeModelChangeListeners(this);
    }

    @JsonGetter(value="viewers")
    public List<ViewerModel> getViewerModels() {
        return this.viewerModels;
    }

    @JsonSetter(value="viewers")
    public void setViewerModels(List<ViewerModel> viewerModels) {
        this.viewerModels.addAll(viewerModels);
        this.invokeModelChangeListeners(this);
    }

    @Override
    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonSetter(value="title")
    public void setTitle(String title) {
        this.title = title;
        this.invokeModelChangeListeners(this);
    }

    @JsonGetter(value="order")
    public Integer getOrder() {
        return this.order;
    }

    @JsonSetter(value="order")
    public void setOrder(Integer order) {
        this.order = order;
        this.invokeModelChangeListeners(this);
    }

    @JsonGetter(value="splitter_position")
    public Double getSplitterPosition() {
        return this.splitterPosition;
    }

    @JsonSetter(value="splitter_position")
    public void setSplitterPosition(Double splitterPosition) {
        this.splitterPosition = splitterPosition;
        this.invokeModelChangeListeners(this);
    }

    @JsonGetter(value="update_instantly")
    public Boolean getUpdateInstantly() {
        return this.updateInstantly;
    }

    @JsonSetter(value="update_instantly")
    public void setUpdateInstantly(Boolean updateInstantly) {
        this.updateInstantly = updateInstantly;
        this.invokeModelChangeListeners(this);
    }

    @JsonIgnore
    public void addViewerModel(ViewerModel viewerModel) {
        this.viewerModels.add(viewerModel);
        this.invokeModelChangeListeners(this);
    }

    public void addViewerModel(int position, ViewerModel viewerModel) {
        if (position < 0 || position > this.viewerModels.size()) {
            this.viewerModels.add(viewerModel);
        } else {
            this.viewerModels.add(position, viewerModel);
        }
        this.invokeModelChangeListeners(this);
    }

    @JsonIgnore
    public void clearViewerModels() {
        this.viewerModels.clear();
        this.invokeModelChangeListeners(this);
    }

    @JsonIgnore
    public Optional<BlockViewerModel> removeViewerModelById(UUID viewerId) {
        Optional opt = CollectionsUtils.removeFirst(this.viewerModels, viewer -> viewer.getUuid().equals(viewerId), BlockViewerModel.class);
        if (opt.isPresent()) {
            this.invokeModelChangeListeners(this);
        }
        return opt;
    }

    @JsonIgnore
    public <T extends BlockViewerModel> T createAndAddViewer(UUID blockId, Class<T> clazz) {
        BlockViewerModel viewerModel = null;
        try {
            viewerModel = (BlockViewerModel)clazz.newInstance();
            viewerModel.setUuid(UUID.randomUUID());
            viewerModel.setBlockUuid(blockId);
            this.addViewerModel(viewerModel);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return (T)viewerModel;
    }

    public <T extends BlockViewerModel> Optional<T> findViewerModel(UUID uuid, Class<T> clazz) {
        return CollectionsUtils.findFirst(this.viewerModels, viewer -> viewer.getUuid().equals(uuid), clazz);
    }

    @JsonIgnore
    public void addBenchmarkPoint(int id, Point2D point) {
        this.benchmarkPoints.put(id, point);
    }

    @JsonIgnore
    public Optional<Point2D> getBenchmarkPoint(int id) {
        return Optional.ofNullable(this.benchmarkPoints.get(id));
    }

    @Override
    public void release() {
        super.release();
        this.uuid = new UUID(0L, 0L);
        this.viewerModels.clear();
    }

    public static UUID CreateUuid(int order) {
        return (UUID)UuidUtils.create((String)String.valueOf(order)).get();
    }

    public boolean hasViewerModel(UUID blockId) {
        return this.viewerModels.stream().filter(viewerModel -> BlockViewerModel.class.isAssignableFrom(viewerModel.getClass())).map(viewerModel -> (BlockViewerModel)viewerModel).anyMatch(blockViewerModel -> blockViewerModel.getBlockUuid().equals(blockId));
    }

    public int indexOf(UUID viewerId) {
        for (int i = 0; i < this.viewerModels.size(); ++i) {
            ViewerModel viewerModel = this.viewerModels.get(i);
            if (!viewerModel.getUuid().equals(viewerId)) continue;
            return i;
        }
        return -1;
    }

    public void swapViewerModels(UUID viewerId1, UUID viewerId2) {
        int position1 = this.indexOf(viewerId1);
        int position2 = this.indexOf(viewerId2);
        if (position1 != -1 && position2 != -1 && position1 != position2) {
            Collections.swap(this.viewerModels, position1, position2);
            this.invokeModelChangeListeners(this);
        }
    }
}

