/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.worker;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.cv.monitor.model.worker.EKind;
import com.siams.cv.monitor.model.worker.SJava;
import com.siams.cv.monitor.model.worker.SPort;
import com.siams.cv.monitor.model.worker.WorkerTypeCategory;
import com.siams.cv.monitor.model.worker.control.SControl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkerStructure {
    private static final Object[] FUNCTIONS_IN_LIST_CORRECTIONS_BEFORE_SHOWING = new Object[]{Pattern.compile("^\\$\\$"), "", Pattern.compile("(^|\\.)\\[\\[[\\w\\$~]+\\]\\]\\s*"), ""};
    private static final Object[] FUNCTIONS_IN_LIST_CORRECTIONS_BEFORE_SORTING = new Object[]{Pattern.compile("(^|\\.)\\[\\[([\\w\\$~]+)\\]\\]"), "$1$2"};
    private final Logger logger = Logger.getLogger(WorkerStructure.class);
    private List<WorkerTypeCategory> categories = new ArrayList<WorkerTypeCategory>();
    private String app = "";
    private String authors = "";
    private String version = "";
    private String name = "";
    private String caption = "";
    private UUID id;
    private UUID uuid;
    private String category = "";
    private String description = "";
    private String url = "";
    @JsonProperty(value="help_file")
    private String helpFile = "";
    private String language = "";
    @Deprecated
    private SJava java = null;
    private String languageDetails = "";
    private List<SControl> controls = Collections.emptyList();
    @JsonProperty(value="in_ports")
    private List<SPort> inPorts;
    @JsonProperty(value="out_ports")
    private List<SPort> outPorts;
    @Deprecated
    private EKind kind;
    private Set<String> tags = new TreeSet<String>();
    private Options options = new Options();

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public Optional<SControl> findControl(String name) {
        return this.controls.stream().filter(control -> control.getName().equals(name)).findFirst();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCorrectedName() {
        return WorkerStructure.replaceFunctionName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public UUID getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = UUID.fromString(id);
    }

    public UUID getUuid() {
        return this.uuid == null ? this.id : this.uuid;
    }

    @JsonSetter(value="uuid")
    public void setUuid(String uuid) {
        this.uuid = UUID.fromString(uuid);
    }

    public String getCorrectedCategory() {
        return WorkerStructure.replaceFunctionName(this.category);
    }

    public String getCategory() {
        return this.category;
    }

    @JsonSetter(value="category")
    public void setCategory(String category) {
        this.category = category;
        this.updateCategoryList();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHelpFile() {
        return this.helpFile;
    }

    public void setHelpFile(String helpFile) {
        this.helpFile = helpFile;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguageDetails() {
        return this.languageDetails;
    }

    public void setLanguageDetails(String languageDetails) {
        this.languageDetails = languageDetails;
    }

    @Deprecated
    public SJava getJava() {
        return this.java;
    }

    public void setJava(SJava java) {
        this.java = java;
    }

    public List<SControl> getControls() {
        return this.controls;
    }

    public void setControls(List<SControl> controls) {
        this.controls = controls;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public List<SPort> getInPorts() {
        return this.inPorts;
    }

    public void setInPorts(List<SPort> inPorts) {
        this.inPorts = inPorts;
    }

    public List<SPort> getOutPorts() {
        return this.outPorts;
    }

    public void setOutPorts(List<SPort> outPorts) {
        this.outPorts = outPorts;
    }

    private void updateCategoryList() {
        this.categories.clear();
        String[] names = this.category.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            String categoryCanonicalName = String.join((CharSequence)".", Arrays.copyOfRange(names, 0, i + 1));
            this.categories.add(new WorkerTypeCategory(categoryCanonicalName, names[i]));
        }
    }

    public List<WorkerTypeCategory> getCategories() {
        return this.categories;
    }

    public String getCategoryPackage(String delimiter) {
        Objects.requireNonNull(delimiter, "Null delimiter");
        if (this.categories == null) {
            return "";
        }
        return this.categories.stream().map(WorkerTypeCategory::getName).collect(Collectors.joining(delimiter));
    }

    @Deprecated
    public EKind getKind() {
        if (this.kind == null) {
            this.kind = EKind.FUNCTION;
        }
        return this.kind;
    }

    public void setKind(EKind kind) {
        this.kind = kind;
    }

    public static String replaceFunctionName(String s) {
        return WorkerStructure.replaceByList(FUNCTIONS_IN_LIST_CORRECTIONS_BEFORE_SHOWING, s);
    }

    public static String replaceFunctionNameForSorting(String s) {
        return WorkerStructure.replaceByList(FUNCTIONS_IN_LIST_CORRECTIONS_BEFORE_SORTING, s);
    }

    private static String replaceByList(Object[] replacements, String s) {
        if (s == null) {
            return null;
        }
        assert (replacements.length % 2 == 0);
        for (int k = 0; k < replacements.length; k += 2) {
            Pattern pattern = (Pattern)replacements[k];
            s = pattern.matcher(s).replaceAll((String)replacements[k + 1]);
        }
        return s;
    }

    public String getCaptionOrName() {
        String caption = this.getCaption();
        if (caption.isEmpty()) {
            caption = this.getCorrectedName();
        }
        return caption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.uuid != null) {
            sb.append("uuid=").append(this.uuid.toString());
        }
        if (this.category != null) {
            sb.append(",category=").append(this.category);
        }
        if (this.name != null) {
            sb.append(",name=").append(this.name);
        }
        if (this.language != null) {
            sb.append(",language=").append(this.language);
        }
        return sb.toString();
    }

    public static WorkerStructure valueOf(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (WorkerStructure)objectMapper.readValue(json, WorkerStructure.class);
    }

    public static WorkerStructure valueOf(InputStream in) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (WorkerStructure)objectMapper.readValue(in, WorkerStructure.class);
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Options {
        private String stage = "";
        private Role role = new Role(this);
        private Behavior behavior = new Behavior(this);

        public String getStage() {
            return this.stage;
        }

        public void setStage(String stage) {
            this.stage = stage;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
        }

        public Behavior getBehavior() {
            return this.behavior;
        }

        public void setBehavior(Behavior behavior) {
            this.behavior = behavior;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public class Role {
            @JsonProperty(value="settings")
            private Boolean settings = false;
            @JsonProperty(value="main")
            private Boolean main = false;
            @JsonProperty(value="owner")
            private Owner owner = new Owner(this);

            public Role(Options this$0) {
            }

            public Boolean getSettings() {
                return this.settings;
            }

            public void setSettings(Boolean settings) {
                this.settings = settings;
            }

            public Boolean getMain() {
                return this.main;
            }

            public void setMain(Boolean main) {
                this.main = main;
            }

            public Owner getOwner() {
                return this.owner;
            }

            public void setOwner(Owner owner) {
                this.owner = owner;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public class Owner {
                @JsonProperty(value="name")
                private String name = "";
                @JsonProperty(value="id")
                private String id = "";
                @JsonProperty(value="context_id")
                private String contextId = "";

                public Owner(Role this$1) {
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getContextId() {
                    return this.contextId;
                }

                public void setContextId(String contextId) {
                    this.contextId = contextId;
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public class Behavior {
            private Boolean input = false;
            private Boolean output = false;
            private Boolean copy = false;
            private Boolean data = false;

            public Behavior(Options this$0) {
            }

            public Boolean getInput() {
                return this.input;
            }

            public void setInput(Boolean input) {
                this.input = input;
            }

            public Boolean getOutput() {
                return this.output;
            }

            public void setOutput(Boolean output) {
                this.output = output;
            }

            public Boolean getCopy() {
                return this.copy;
            }

            public void setCopy(Boolean copy) {
                this.copy = copy;
            }

            public Boolean getData() {
                return this.data;
            }

            public void setData(Boolean data) {
                this.data = data;
            }
        }
    }
}

