/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.worker.control;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.siams.cv.monitor.model.worker.control.SCColor;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SCFile;
import com.siams.cv.monitor.model.worker.control.SCFileToSave;
import com.siams.cv.monitor.model.worker.control.SCFolder;
import com.siams.cv.monitor.model.worker.control.SCRange;
import com.siams.cv.monitor.model.worker.control.SCText;
import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.model.worker.control.SControlDefaultFieldDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="edition_type", defaultImpl=SControl.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SCEnum.class, name="enum"), @JsonSubTypes.Type(value=SCValue.class, name="value"), @JsonSubTypes.Type(value=SCFile.class, name="file"), @JsonSubTypes.Type(value=SCFileToSave.class, name="file_to_save"), @JsonSubTypes.Type(value=SCText.class, name="text"), @JsonSubTypes.Type(value=SCFolder.class, name="folder"), @JsonSubTypes.Type(value=SCColor.class, name="color"), @JsonSubTypes.Type(value=SCRange.class, name="range")})
public class SControl {
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="value_type")
    private ValueType valueType;
    @Deprecated
    @JsonProperty(value="sub_type")
    private String subType = "";
    @JsonProperty(value="edition_type")
    protected EditionType editionType;
    @Deprecated
    @JsonProperty(value="type")
    private String type = "";
    @JsonProperty(value="is_odd")
    private boolean isOdd = false;
    @JsonProperty(value="is_even")
    private boolean isEven = false;
    @JsonProperty(value="min")
    private double min = Double.NaN;
    @JsonProperty(value="max")
    private double max = Double.NaN;
    @JsonProperty(value="default")
    @JsonDeserialize(using=SControlDefaultFieldDeserializer.class)
    private String def = "";
    @JsonProperty(value="caption")
    private String caption = "";
    @JsonProperty(value="hint")
    private String hint = "";
    @JsonProperty(value="description")
    private String description = "";
    @JsonProperty(value="advanced")
    private Boolean advanced = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ValueType getValueType() {
        if (this.valueType == null) {
            return ValueType.valueOf(this.subType);
        }
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    @JsonSetter(value="value_type")
    public void setValueType(String valueType) {
        this.valueType = ValueType.of(valueType);
    }

    public void setEditionType(String editionType) {
        this.editionType = EditionType.of(editionType);
    }

    public EditionType getEditionType() {
        if (this.editionType == null && this.type != null) {
            if (this.type.isEmpty()) {
                throw new IllegalStateException("Edition type is not set");
            }
            return EditionType.valueOf(this.type);
        }
        return this.editionType;
    }

    public boolean isOdd() {
        return this.isOdd;
    }

    public void setOdd(boolean odd) {
        this.isOdd = odd;
    }

    public boolean isEven() {
        return this.isEven;
    }

    public void setEven(boolean even) {
        this.isEven = even;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public String getDef() {
        return this.def;
    }

    public void setDef(String def) {
        this.def = def;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getHint() {
        return this.hint;
    }

    public String getSmartHint() {
        return !this.hint.isEmpty() ? this.hint : (!this.caption.isEmpty() ? this.caption : this.name);
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAdvanced(Boolean advanced) {
        this.advanced = advanced;
    }

    public Boolean getAdvanced() {
        return this.advanced;
    }

    public static enum ValueType {
        BOOLEAN("boolean"),
        BYTE("byte"),
        SHORT("short"),
        DOUBLE("double"),
        FLOAT("float"),
        INT("int"),
        LONG("long"),
        STRING("string"),
        MAT("mat"),
        NUMBERS("numbers"),
        SCALAR("scalar"),
        SETTINGS("settings");

        private final String id;

        private ValueType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static ValueType of(String valueType) {
            return switch (valueType.toLowerCase()) {
                case "bool" -> BOOLEAN;
                case "int16" -> SHORT;
                case "int32", "integer" -> INT;
                case "int64" -> LONG;
                case "str" -> STRING;
                default -> ValueType.valueOf(valueType.toUpperCase());
            };
        }
    }

    public static enum EditionType {
        ENUM("enum"),
        RANGE("range"),
        VALUE("value"),
        FILE("file"),
        FILE_TO_SAVE("file_to_save"),
        FOLDER("folder"),
        TEXT("text"),
        COLOR("color");

        private final String id;

        private EditionType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static EditionType of(String editionType) {
            return EditionType.valueOf(editionType.toUpperCase());
        }
    }
}

