/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import jakarta.json.JsonObject;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.algart.arrays.Arrays;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.graalvm.js.core.UseJS;
import net.algart.executors.api.multichains.core.UseMultiChain;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.python.core.UsingPython;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutionSystemConfigurationException;
import net.algart.executors.api.system.ExecutorLoader;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;
import net.algart.external.UsedForExternalCommunication;
import net.algart.json.PropertyChecker;

public abstract class ExecutionBlock
extends PropertyChecker
implements AutoCloseable {
    public static String DEFAULT_INPUT_PORT = "input";
    public static String DEFAULT_OUTPUT_PORT = "output";
    public static final String GLOBAL_SHARED_SESSION_ID = "$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f";
    public static final boolean SHOW_INFO_ON_STARTUP = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.showInfo", (boolean)false);
    public static final boolean EXTENDED_MODE = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.extended", (boolean)false);
    private static final ExecutorLoader STANDARD_JAVA_EXECUTOR_LOADER;
    private static final ExecutorLoaderSet GLOBAL_LOADERS;
    private static final Map<Integer, Runnable> tasksBeforeExecutingAll;
    private static final Map<Integer, Runnable> tasksAfterExecutingAll;
    private static final Map<Integer, Runnable> oneTimeTasksAfterExecutingAll;
    private final Map<String, Port> inputPorts = new LinkedHashMap<String, Port>();
    private final Map<String, Port> outputPorts = new LinkedHashMap<String, Port>();
    private final Parameters parameters = new Parameters();
    private boolean visibleResultNecessary = false;
    private boolean allOutputsNecessary = false;
    private ExecutionBlock caller = null;
    private ExecutionBlock rootCaller = this;
    private volatile String sessionId = null;
    private volatile ExecutorSpecification specification = null;
    private String ownerId = null;
    private Object contextId = null;
    private String contextName = null;
    private String contextPath = null;
    private Path currentDirectory = null;
    private volatile boolean interruptionRequested = false;
    private volatile boolean closed = false;

    public static ExecutorLoaderSet globalLoaders() {
        return GLOBAL_LOADERS;
    }

    protected ExecutionBlock() {
    }

    @UsedForExternalCommunication
    public final boolean addPort(Port port) {
        Objects.requireNonNull(port, "Null port");
        return switch (port.getPortType()) {
            default -> throw new MatchException(null, null);
            case Port.Type.INPUT -> {
                if (this.inputPorts.putIfAbsent(port.getName(), port) == null) {
                    yield true;
                }
                yield false;
            }
            case Port.Type.OUTPUT -> this.outputPorts.putIfAbsent(port.getName(), port) == null;
        };
    }

    public final boolean replacePort(Port port) {
        Objects.requireNonNull(port, "Null port");
        return switch (port.getPortType()) {
            default -> throw new MatchException(null, null);
            case Port.Type.INPUT -> {
                if (this.inputPorts.put(port.getName(), port) == null) {
                    yield true;
                }
                yield false;
            }
            case Port.Type.OUTPUT -> this.outputPorts.put(port.getName(), port) == null;
        };
    }

    public final boolean removeInputPort(String portName) {
        Objects.requireNonNull(portName, "Null portName");
        return this.inputPorts.remove(portName) != null;
    }

    public final boolean removeOutputPort(String portName) {
        Objects.requireNonNull(portName, "Null portName");
        return this.outputPorts.remove(portName) != null;
    }

    public String defaultInputPortName() {
        return DEFAULT_INPUT_PORT;
    }

    public String defaultOutputPortName() {
        return DEFAULT_OUTPUT_PORT;
    }

    @UsedForExternalCommunication
    public final boolean hasInputPort(String name) {
        return this.inputPorts.containsKey(name);
    }

    @UsedForExternalCommunication
    public final boolean hasOutputPort(String name) {
        return this.outputPorts.containsKey(name);
    }

    public final boolean hasDefaultInputPort() {
        return this.hasInputPort(this.defaultInputPortName());
    }

    public final boolean hasDefaultOutputPort() {
        return this.hasOutputPort(this.defaultOutputPortName());
    }

    public final Collection<Port> inputPorts() {
        return Collections.unmodifiableCollection(this.inputPorts.values());
    }

    public final Collection<Port> outputPorts() {
        return Collections.unmodifiableCollection(this.outputPorts.values());
    }

    public final Map<String, Port> inputPortsMap() {
        return Collections.unmodifiableMap(this.inputPorts);
    }

    public final Map<String, Port> outputPortsMap() {
        return Collections.unmodifiableMap(this.outputPorts);
    }

    @UsedForExternalCommunication
    public final Port getInputPort(String name) {
        Objects.requireNonNull(name, "Null input port name");
        return this.inputPorts.get(name);
    }

    @UsedForExternalCommunication
    public final Port getOutputPort(String name) {
        Objects.requireNonNull(name, "Null output port name");
        return this.outputPorts.get(name);
    }

    public final Port getPort(Port.Type type, String name) {
        Objects.requireNonNull(type, "Null port type");
        Objects.requireNonNull(name, "Null port name");
        return type.getPort(this, name);
    }

    public final Port getRequiredInputPort(String name) {
        Port result = this.getInputPort(name);
        if (result == null) {
            throw new IllegalArgumentException("No input port \"" + name + "\"");
        }
        return result;
    }

    public final Port getRequiredOutputPort(String name) {
        Port result = this.getOutputPort(name);
        if (result == null) {
            throw new IllegalArgumentException("No output port \"" + name + "\"");
        }
        return result;
    }

    public final void requestDefaultOutput() {
        this.requestOutput(this.defaultOutputPortName());
    }

    public final void requestOutput(String ... portNames) {
        for (String portName : portNames) {
            Port outputPort = this.getOutputPort(portName);
            if (outputPort == null) continue;
            outputPort.setConnected(true);
        }
    }

    public final boolean isInputNecessary(String inputPortName) {
        Port inputPort = this.getInputPort(inputPortName);
        if (inputPort == null) {
            return false;
        }
        Boolean check = this.checkInputNecessary(inputPort);
        return check == null || check != false;
    }

    public final boolean isOutputNecessary(String outputPortName) {
        return this.checkOutputNecessary(this.getOutputPort(outputPortName));
    }

    public Boolean checkInputNecessary(Port inputPort) {
        return null;
    }

    public boolean checkOutputNecessary(Port outputPort) {
        return outputPort != null && (this.allOutputsNecessary || outputPort.isConnected());
    }

    public final boolean addInputData(String name, DataType dataType) {
        return !this.inputPorts.containsKey(name) && this.addPort(Port.newInput(name, dataType));
    }

    public final boolean addOutputData(String name, DataType dataType) {
        return !this.outputPorts.containsKey(name) && this.addPort(Port.newOutput(name, dataType));
    }

    public final boolean addInputMat(String name) {
        return !this.inputPorts.containsKey(name) && this.addPort(Port.newInput(name, DataType.MAT));
    }

    public final boolean addOutputMat(String name) {
        return !this.outputPorts.containsKey(name) && this.addPort(Port.newOutput(name, DataType.MAT));
    }

    public final boolean addInputNumbers(String name) {
        return !this.inputPorts.containsKey(name) && this.addPort(Port.newInput(name, DataType.NUMBERS));
    }

    public final boolean addOutputNumbers(String name) {
        return !this.outputPorts.containsKey(name) && this.addPort(Port.newOutput(name, DataType.NUMBERS));
    }

    public final boolean addInputScalar(String name) {
        return !this.inputPorts.containsKey(name) && this.addPort(Port.newInput(name, DataType.SCALAR));
    }

    public final boolean addOutputScalar(String name) {
        return !this.outputPorts.containsKey(name) && this.addPort(Port.newOutput(name, DataType.SCALAR));
    }

    public final Data getInputData(String name) {
        return this.getInputData(name, false);
    }

    public final Data getInputDataContainer(String name) {
        return this.getInputData(name, true);
    }

    public final Data getInputData(String name, boolean allowUninitializedData) {
        return this.getRequiredInputPort(name).getData(Data.class, allowUninitializedData);
    }

    public final Data getData(String name) {
        return this.getRequiredOutputPort(name).getData(Data.class, true);
    }

    public final Data getData() {
        return this.getData(this.defaultOutputPortName());
    }

    public final void removeOutputData(String name) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getData(name).remove();
        }
    }

    public final Data getInputData() {
        return this.getInputData(this.defaultInputPortName());
    }

    public final Data getInputData(boolean allowUninitializedData) {
        return this.getInputData(this.defaultInputPortName(), allowUninitializedData);
    }

    public final Data getInputDataContainer() {
        return this.getInputDataContainer(this.defaultInputPortName());
    }

    public final SMat getInputMat(String name) {
        return this.getInputMat(name, false);
    }

    public final SMat getInputMatContainer(String name) {
        return this.getInputMat(name, true);
    }

    public final SMat getInputMat(String name, boolean allowUninitializedData) {
        return this.getRequiredInputPort(name).getData(SMat.class, allowUninitializedData);
    }

    public final SMat getMat(String name) {
        return this.getRequiredOutputPort(name).getData(SMat.class, true);
    }

    public final void putMat(String name, SMat mat) {
        this.addInputMat(name);
        this.getInputMatContainer(name).setTo(mat);
    }

    public final SMat getInputMat() {
        return this.getInputMat(this.defaultInputPortName());
    }

    public final SMat getInputMat(boolean allowUninitializedData) {
        return this.getInputMat(this.defaultInputPortName(), allowUninitializedData);
    }

    public final SMat getInputMatContainer() {
        return this.getInputMatContainer(this.defaultInputPortName());
    }

    public final SMat getMat() {
        return this.getMat(this.defaultOutputPortName());
    }

    public final void putMat(SMat mat) {
        this.putMat(this.defaultInputPortName(), mat);
    }

    public final SNumbers getInputNumbers(String name) {
        return this.getInputNumbers(name, false);
    }

    public final SNumbers getInputNumbersContainer(String name) {
        return this.getInputNumbers(name, true);
    }

    public final SNumbers getInputNumbers(String name, boolean allowUninitializedData) {
        return this.getRequiredInputPort(name).getData(SNumbers.class, allowUninitializedData);
    }

    public final SNumbers getNumbers(String name) {
        return this.getRequiredOutputPort(name).getData(SNumbers.class, true);
    }

    public final void putNumbers(String name, SNumbers numbers) {
        this.addInputNumbers(name);
        this.getInputNumbersContainer(name).setTo(numbers);
    }

    public final void putNumbers(String name, Object javaArray, int blockLength) {
        this.addInputNumbers(name);
        this.getInputNumbersContainer(name).setToArray(javaArray, blockLength);
    }

    public final SNumbers getInputNumbers() {
        return this.getInputNumbers(this.defaultInputPortName());
    }

    public final SNumbers getInputNumbers(boolean allowUninitializedData) {
        return this.getInputNumbers(this.defaultInputPortName(), allowUninitializedData);
    }

    public final SNumbers getInputNumbersContainer() {
        return this.getInputNumbersContainer(this.defaultInputPortName());
    }

    public final SNumbers getNumbers() {
        return this.getNumbers(this.defaultOutputPortName());
    }

    public final void putNumbers(SNumbers numbers) {
        this.putNumbers(this.defaultInputPortName(), numbers);
    }

    public final void putNumbers(Object javaArray, int blockLength) {
        this.putNumbers(this.defaultInputPortName(), javaArray, blockLength);
    }

    public final SScalar getInputScalar(String name) {
        return this.getInputScalar(name, false);
    }

    public final SScalar getInputScalarContainer(String name) {
        return this.getInputScalar(name, true);
    }

    public final SScalar getInputScalar(String name, boolean allowUninitializedData) {
        return this.getRequiredInputPort(name).getData(SScalar.class, allowUninitializedData);
    }

    public final SScalar getScalar(String name) {
        return this.getRequiredOutputPort(name).getData(SScalar.class, true);
    }

    public final String getStringScalar(String name) {
        return this.getScalar(name).getValue();
    }

    public final int getIntScalar(String name) {
        return this.getScalar(name).toInt();
    }

    public final long getLongScalar(String name) {
        return this.getScalar(name).toLong();
    }

    public final double getDoubleScalar(String name) {
        return this.getScalar(name).toDouble();
    }

    public final void setOutputScalar(String name, String value) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value);
        }
    }

    public final void setOutputScalar(String name, boolean value) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value);
        }
    }

    public final void setOutputScalar(String name, int value) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value);
        }
    }

    public final void setOutputScalar(String name, long value) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value);
        }
    }

    public final void setOutputScalar(String name, double value) {
        Objects.requireNonNull(name, "Null output port name");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value);
        }
    }

    public final void setOutputScalar(String name, Supplier<?> value) {
        Objects.requireNonNull(name, "Null output port name");
        Objects.requireNonNull(value, "Null value supplier");
        if (this.hasOutputPort(name)) {
            this.getScalar(name).setTo(value.get());
        }
    }

    public final void setOutputScalarIfNecessary(String name, Supplier<?> value) {
        Objects.requireNonNull(name, "Null output port name");
        Objects.requireNonNull(value, "Null value supplier");
        if (this.isOutputNecessary(name)) {
            this.getScalar(name).setTo(value.get());
        }
    }

    public final void putScalar(String name, SScalar scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final void putStringScalar(String name, String scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final void putJsonScalar(String name, JsonObject scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final void putIntScalar(String name, int scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final void putLongScalar(String name, long scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final void putDoubleScalar(String name, double scalar) {
        this.addInputScalar(name);
        this.getInputScalarContainer(name).setTo(scalar);
    }

    public final SScalar getInputScalar() {
        return this.getInputScalar(this.defaultInputPortName());
    }

    public final SScalar getInputScalar(boolean allowUninitializedData) {
        return this.getInputScalar(this.defaultInputPortName(), allowUninitializedData);
    }

    public final SScalar getInputScalarContainer() {
        return this.getInputScalarContainer(this.defaultInputPortName());
    }

    public final SScalar getScalar() {
        return this.getScalar(this.defaultOutputPortName());
    }

    public final String getStringScalar() {
        return this.getScalar().getValue();
    }

    public final int getIntScalar() {
        return this.getScalar().toInt();
    }

    public final long getLongScalar() {
        return this.getScalar().toLong();
    }

    public final double getDoubleScalar() {
        return this.getScalar().toDouble();
    }

    public final void putScalar(SScalar scalar) {
        this.putScalar(this.defaultInputPortName(), scalar);
    }

    public final void putStringScalar(String value) {
        this.putStringScalar(this.defaultInputPortName(), value);
    }

    public final void putJsonScalar(JsonObject value) {
        this.putJsonScalar(this.defaultInputPortName(), value);
    }

    public final void putIntScalar(int value) {
        this.putIntScalar(this.defaultInputPortName(), value);
    }

    public final void putLongScalar(long value) {
        this.putLongScalar(this.defaultInputPortName(), value);
    }

    public final void putDoubleScalar(double value) {
        this.putDoubleScalar(this.defaultInputPortName(), value);
    }

    @UsedForExternalCommunication
    public final Parameters parameters() {
        return this.parameters;
    }

    public final void setParameters(Parameters parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public final void setBooleanParameter(String name, boolean value) {
        this.parameters.setBoolean(name, value);
        this.onChangeParameter(name);
    }

    public final void setIntParameter(String name, int value) {
        this.parameters.setInteger(name, value);
        this.onChangeParameter(name);
    }

    public final void setLongParameter(String name, long value) {
        this.parameters.setLong(name, value);
        this.onChangeParameter(name);
    }

    public final void setDoubleParameter(String name, double value) {
        this.parameters.setDouble(name, value);
        this.onChangeParameter(name);
    }

    public final void setStringParameter(String name, String value) {
        this.parameters.setString(name, value);
        this.onChangeParameter(name);
    }

    public final void setParameter(String name, Object value) {
        this.parameters.put(name, value);
        this.onChangeParameter(name);
    }

    @UsedForExternalCommunication
    public final boolean isVisibleResultNecessary() {
        return this.visibleResultNecessary;
    }

    @UsedForExternalCommunication
    public final void setVisibleResultNecessary(boolean visibleResultNecessary) {
        this.visibleResultNecessary = visibleResultNecessary;
    }

    @UsedForExternalCommunication
    public final boolean isAllOutputsNecessary() {
        return this.allOutputsNecessary;
    }

    @UsedForExternalCommunication
    public final void setAllOutputsNecessary(boolean allOutputsNecessary) {
        this.allOutputsNecessary = allOutputsNecessary;
    }

    public final ExecutionBlock getRootCaller() {
        return this.rootCaller;
    }

    public final ExecutionBlock getCaller() {
        return this.caller;
    }

    public final void setCaller(ExecutionBlock caller) {
        this.caller = caller;
        this.rootCaller = caller == null ? this : caller.rootCaller;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(String sessionId) {
        if (this.sessionId != null) {
            throw new IllegalStateException("sessionId can be assigned only once");
        }
        this.sessionId = sessionId;
    }

    public static <T extends ExecutionBlock> T setSession(T executor, String sessionId) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(sessionId, "Null sessionId");
        executor.setSessionId(sessionId);
        return executor;
    }

    public static <T extends ExecutionBlock> T setShared(T executor) {
        return ExecutionBlock.setSession(executor, GLOBAL_SHARED_SESSION_ID);
    }

    public final String getExecutorId() {
        return this.specification == null ? null : this.specification.getId();
    }

    public final ExecutorSpecification getSpecification() {
        return this.specification;
    }

    public final void setSpecification(ExecutorSpecification specification) {
        if (this.specification != null) {
            throw new IllegalStateException("Executor specification can be assigned only once");
        }
        this.specification = specification;
    }

    public final String getPlatformId() {
        return this.specification == null ? null : this.specification.getPlatformId();
    }

    public final String getOwnerId() {
        return this.ownerId;
    }

    @UsedForExternalCommunication
    public final void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public final Object getContextId() {
        return this.contextId;
    }

    public final void setContextId(Object contextId) {
        this.contextId = contextId;
    }

    @UsedForExternalCommunication
    public final void setContextId(long contextId) {
        this.setContextId((Object)contextId);
    }

    public final String getContextName() {
        return this.contextName;
    }

    @UsedForExternalCommunication
    public final void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public final String getContextPath() {
        return this.contextPath;
    }

    @UsedForExternalCommunication
    public final void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public final Path contextPath() {
        try {
            return this.contextPath == null ? null : Paths.get(this.contextPath, new String[0]);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @UsedForExternalCommunication
    public final Path getCurrentDirectory() {
        return this.currentDirectory;
    }

    @UsedForExternalCommunication
    public final void setCurrentDirectory(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public final Path translateCurrentDirectory(Path path) {
        Objects.requireNonNull(path, "Null path");
        return !path.isAbsolute() && this.currentDirectory != null ? this.currentDirectory.resolve(path).toAbsolutePath() : path;
    }

    @UsedForExternalCommunication
    public Object status() {
        return null;
    }

    @UsedForExternalCommunication
    public String statusData(int dataCode) {
        return null;
    }

    public boolean isInterruptionRequested() {
        return this.interruptionRequested;
    }

    @UsedForExternalCommunication
    public void setInterruptionRequested(boolean interruptionRequested) {
        this.interruptionRequested = interruptionRequested;
    }

    public boolean isInterrupted() {
        return this.interruptionRequested || this.rootCaller.interruptionRequested;
    }

    @UsedForExternalCommunication
    public void interrupt() {
        this.setInterruptionRequested(true);
    }

    @UsedForExternalCommunication
    public void onChangeParameter(String name) {
    }

    @UsedForExternalCommunication
    public void reset() {
    }

    @UsedForExternalCommunication
    public abstract void execute();

    public void execute(ExecutionMode executionMode) {
        Objects.requireNonNull(executionMode, "Null executionMode");
        this.execute();
    }

    @UsedForExternalCommunication
    public String translateLegacyParameterAlias(String name) {
        return null;
    }

    public final boolean isReadOnlyInput() {
        return this instanceof ReadOnlyExecutionInput && ((ReadOnlyExecutionInput)((Object)this)).isReadOnly();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @UsedForExternalCommunication
    public boolean needToRepeat() {
        return false;
    }

    @UsedForExternalCommunication
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return new ExecutionVisibleResultsInformation().setPorts(this.getOutputPort(this.defaultOutputPortName()));
    }

    public void freeAllInputPortData() {
        for (Port port : this.inputPorts()) {
            port.removeData();
        }
    }

    public void freeAllOutputPortData() {
        for (Port port : this.outputPorts()) {
            port.removeData();
        }
    }

    public void freeAllPortData() {
        this.freeAllInputPortData();
        this.freeAllOutputPortData();
    }

    @Override
    @UsedForExternalCommunication
    public void close() {
        this.closed = true;
        this.caller = null;
    }

    @UsedForExternalCommunication
    public static void initializeExecutionSystem() {
        Initialization.initializeExecutionSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedForExternalCommunication
    public static void beforeExecutingAll() {
        Map<Integer, Runnable> map = tasksBeforeExecutingAll;
        synchronized (map) {
            for (Runnable task : tasksBeforeExecutingAll.values()) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedForExternalCommunication
    public static void afterExecutingAll() {
        Map<Integer, Runnable> map = oneTimeTasksAfterExecutingAll;
        synchronized (map) {
            for (Runnable task : oneTimeTasksAfterExecutingAll.values()) {
                task.run();
            }
            oneTimeTasksAfterExecutingAll.clear();
        }
        map = tasksAfterExecutingAll;
        synchronized (map) {
            for (Runnable task : tasksAfterExecutingAll.values()) {
                task.run();
            }
        }
    }

    public static boolean addTaskBeforeExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return tasksBeforeExecutingAll.put(System.identityHashCode(task), task) == null;
    }

    public static boolean removeTaskBeforeExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return tasksBeforeExecutingAll.remove(System.identityHashCode(task)) != null;
    }

    public static Collection<Runnable> allTasksBeforeExecutingAll() {
        return Collections.unmodifiableCollection(tasksBeforeExecutingAll.values());
    }

    public static boolean addTaskAfterExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return tasksAfterExecutingAll.put(System.identityHashCode(task), task) == null;
    }

    public static boolean removeTaskAfterExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return tasksAfterExecutingAll.remove(System.identityHashCode(task)) != null;
    }

    public static Collection<Runnable> allTasksAfterExecutingAll() {
        return Collections.unmodifiableCollection(tasksAfterExecutingAll.values());
    }

    public static boolean addOneTimeTaskAfterExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return oneTimeTasksAfterExecutingAll.put(System.identityHashCode(task), task) == null;
    }

    public static boolean removeOneTimeTaskAfterExecutingAll(Runnable task) {
        Objects.requireNonNull(task, "Null task");
        return oneTimeTasksAfterExecutingAll.remove(System.identityHashCode(task)) != null;
    }

    public static Collection<Runnable> allOneTimeTasksAfterExecutingAll() {
        return Collections.unmodifiableCollection(oneTimeTasksAfterExecutingAll.values());
    }

    public static String recommendedName(String className) {
        if (className == null) {
            return null;
        }
        int p = className.lastIndexOf(46);
        return className.substring(p + 1);
    }

    public static String recommendedCategory(String className) {
        if (className == null) {
            return null;
        }
        int p = className.lastIndexOf(46);
        return p == -1 ? null : className.substring(0, p);
    }

    public static ExecutionBlock newExecutor(String sessionId, ExecutorSpecification specification) throws ClassNotFoundException {
        return GLOBAL_LOADERS.newExecutor(sessionId, specification, CreateMode.REQUEST_DEFAULT);
    }

    @UsedForExternalCommunication
    public static ExecutionBlock newExecutor(String sessionId, String specification) throws ClassNotFoundException {
        Objects.requireNonNull(specification, "Null specification");
        return ExecutionBlock.newExecutor(sessionId, ExecutorSpecification.of(specification));
    }

    @UsedForExternalCommunication
    public static String[] allSerializedSpecificationsArray(String sessionId) {
        return GLOBAL_LOADERS.allSerializedSpecifications(sessionId, true).values().toArray(new String[0]);
    }

    @UsedForExternalCommunication
    public static void clearSession(String sessionId) {
        GLOBAL_LOADERS.clearSession(sessionId);
    }

    static {
        if (SHOW_INFO_ON_STARTUP) {
            String javaLibraryPath;
            System.out.printf("%nJava executors system started%s%n", EXTENDED_MODE ? " in extended mode" : "");
            System.out.printf("Java version: %s%n", Arrays.SystemSettings.getStringProperty((String)"java.version", null));
            String arch = Arrays.SystemSettings.getStringProperty((String)"os.arch", null);
            boolean java32 = arch != null && !arch.contains("64") && arch.toLowerCase().contains("x86");
            System.out.printf("Architecture: %s (%d-bit)%n", arch, java32 ? 32 : 64);
            if (Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.showLibraryPath", (boolean)false) && (javaLibraryPath = Arrays.SystemSettings.getStringProperty((String)"java.library.path", null)) != null) {
                javaLibraryPath = javaLibraryPath.replace(";", String.format(";%n    ", new Object[0]));
                System.out.printf("Native library path:%n    %s%n", javaLibraryPath);
            }
            Runtime rt = Runtime.getRuntime();
            System.out.printf("AlgART version: %s%n", Arrays.SystemSettings.version());
            System.out.printf("Available processors: %d%n", rt.availableProcessors());
            System.out.printf("Number of processors, used by AlgART: %d%n", Arrays.SystemSettings.cpuCount());
            System.out.printf("Maximal available memory: %.2f Mb%n", (double)rt.maxMemory() / 1048576.0);
        }
        STANDARD_JAVA_EXECUTOR_LOADER = ExecutorLoader.getStandardJavaExecutorLoader();
        GLOBAL_LOADERS = new ExecutorLoaderSet();
        GLOBAL_LOADERS.register(STANDARD_JAVA_EXECUTOR_LOADER);
        tasksBeforeExecutingAll = Collections.synchronizedMap(new LinkedHashMap());
        tasksAfterExecutingAll = Collections.synchronizedMap(new LinkedHashMap());
        oneTimeTasksAfterExecutingAll = Collections.synchronizedMap(new LinkedHashMap());
    }

    private static class Initialization {
        private static boolean initialized = false;

        private Initialization() {
        }

        private static synchronized void initializeExecutionSystem() {
            if (!initialized) {
                try {
                    ExecutorSpecificationSet.findAllBuiltIn();
                    STANDARD_JAVA_EXECUTOR_LOADER.addAllStandardJavaExecutorSpecifications();
                    UsingPython.initializePython();
                    UsingPython.useAllInstalledInSharedContext();
                    UseJS.useAllInstalledInSharedContext();
                    UseSettings.useAllInstalledInSharedContext();
                    UseChain.useAllInstalledInSharedContext();
                    UseMultiChain.useAllInstalledInSharedContext();
                    initialized = true;
                }
                catch (ExecutionSystemConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExecutionSystemConfigurationException("Some problem occurred while initialization; please check configuration files" + (e instanceof NoSuchFileException ? " (no such file/folder: " + ((NoSuchFileException)e).getFile() + ")" : " (" + e.getMessage() + ")"), e);
                }
            }
        }

        static void dummy() {
        }
    }

    public static enum ExecutionMode {
        NORMAL,
        SILENT;


        public boolean isNormalLogging() {
            return this == NORMAL;
        }
    }
}

