/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.external.UsedForExternalCommunication;

public enum DataType {
    MAT("mat", UUID.fromString("031FC202-0193-4933-AB2E-D81492CE67E0")){

        @Override
        public Class<? extends Data> typeClass() {
            return SMat.class;
        }

        @Override
        public Data createEmpty() {
            return new SMat();
        }
    }
    ,
    SCALAR("scalar", UUID.fromString("869bc442-bd01-4094-afc1-783b9ed1c24e")){

        @Override
        public Class<? extends Data> typeClass() {
            return SScalar.class;
        }

        @Override
        public Data createEmpty() {
            return new SScalar();
        }
    }
    ,
    NUMBERS("numbers", UUID.fromString("C72A2A31-75BA-4E09-A02B-A9CBC4AC62D2")){

        @Override
        public Class<? extends Data> typeClass() {
            return SNumbers.class;
        }

        @Override
        public Data createEmpty() {
            return new SNumbers();
        }
    };

    private final String typeName;
    @UsedForExternalCommunication
    private final UUID uuid;

    private DataType(String name, UUID uuid) {
        this.typeName = Objects.requireNonNull(name, "Null type name");
        this.uuid = Objects.requireNonNull(uuid, "Null uuid");
    }

    @UsedForExternalCommunication
    public final String typeName() {
        return this.typeName;
    }

    @UsedForExternalCommunication
    public final UUID uuid() {
        return this.uuid;
    }

    public abstract Data createEmpty();

    public abstract Class<? extends Data> typeClass();

    public static Collection<String> typeNames() {
        return Arrays.stream(DataType.values()).map(DataType::typeName).toList();
    }

    @UsedForExternalCommunication
    public static DataType ofTypeName(String typeName) {
        Objects.requireNonNull(typeName, "Null type name");
        return DataType.fromTypeName(typeName).orElseThrow(() -> new IllegalArgumentException("Unknown type name \"" + typeName + "\""));
    }

    public static Optional<DataType> fromTypeName(String typeName) {
        for (DataType type : DataType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<DataType> fromUUID(UUID uuid) {
        for (DataType type : DataType.values()) {
            if (!type.uuid.equals(uuid)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<DataType> fromUUID(String uuid) {
        for (DataType type : DataType.values()) {
            if (!type.uuid.toString().equalsIgnoreCase(uuid)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

