/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public class JSSpecification
extends ExecutorSpecification {
    private JS js = null;

    public JSSpecification() {
    }

    protected JSSpecification(JsonObject json, Path file) {
        super(json, file);
        JsonObject jsJson = json.getJsonObject("js");
        if (this.isJSExecutor() && jsJson == null) {
            throw new JsonException("Invalid executor configuration JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"js\" section required when \"language\" is \"js\"");
        }
        this.js = jsJson == null ? null : new JS(jsJson, file);
    }

    public static JSSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new JSSpecification(json, specificationFile);
    }

    public static JSSpecification readIfValid(Path specificationFile) {
        JsonObject json;
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        try {
            json = Jsons.readJson(specificationFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (!JSSpecification.isExecutorSpecification(json)) {
            return null;
        }
        return new JSSpecification(json, specificationFile);
    }

    public static List<JSSpecification> readAllIfValid(Path containingJsonPath) throws IOException {
        return JSSpecification.readAllIfValid(null, containingJsonPath);
    }

    public static List<JSSpecification> readAllIfValid(List<JSSpecification> result, Path containingJsonPath) throws IOException {
        return ExecutorSpecification.readAllJsonIfValid(result, containingJsonPath, JSSpecification::readIfValid);
    }

    public static JSSpecification of(JsonObject specificationJson) {
        return new JSSpecification(specificationJson, null);
    }

    public static JSSpecification of(String specificationString) {
        Objects.requireNonNull(specificationString, "Null specificationString");
        JsonObject executorSpecification = Jsons.toJson(specificationString);
        return new JSSpecification(executorSpecification, null);
    }

    public final boolean isJSExecutor() {
        return "js".equals(this.getLanguage());
    }

    public JS getJS() {
        return this.js;
    }

    public JSSpecification setJS(JS js) {
        this.js = js;
        return this;
    }

    @Override
    public void checkCompleteness() {
        super.checkCompleteness();
        if (this.isJSExecutor()) {
            this.checkNull(this.js, "js");
        }
    }

    @Override
    public String toString() {
        return "JSSpecification{js=" + String.valueOf(this.js) + "}, extending " + super.toString();
    }

    @Override
    protected void buildLanguageJson(JsonObjectBuilder builder) {
        if (this.js != null) {
            builder.add("js", (JsonValue)this.js.toJson());
        }
        super.buildLanguageJson(builder);
    }

    public static final class JS
    extends AbstractConvertibleToJson {
        public static final String DEFAULT_FUNCTION = "execute";
        private String module;
        private String function = "execute";

        public JS() {
        }

        private JS(JsonObject json, Path file) {
            this.module = Jsons.reqString(json, "module", file);
            this.function = json.getString("function", this.function);
        }

        public String getModule() {
            return this.module;
        }

        public JS setModule(String module) {
            this.module = JS.nonEmpty(module);
            return this;
        }

        public String getFunction() {
            return this.function;
        }

        public JS setFunction(String function) {
            this.function = JS.nonEmpty(function);
            return this;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.module, "module");
        }

        public String toString() {
            return "JS{module='" + this.module + "', function='" + this.function + "'}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("module", this.module);
            builder.add("function", this.function);
        }
    }
}

