/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.graalvm.GraalAPI;
import net.algart.executors.api.graalvm.GraalSafety;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.JSInterpretation;
import org.graalvm.polyglot.Value;

public abstract class AbstractCallJS
extends Executor {
    private static final List<String> PARAMETERS_NAMES = List.of("a", "b", "c", "d", "e", "f", "p", "q", "r", "s", "t", "u");
    private static final List<String> INPUTS_NAMES = List.of("x1", "x2", "x3", "x4", "x5", "m1", "m2", "m3", "m4", "m5");
    private static final List<String> OUTPUTS_NAMES = List.of(DEFAULT_OUTPUT_PORT, "a", "b", "c", "d", "e", "f", "x1", "x2", "x3", "x4", "x5", "m1", "m2", "m3", "m4", "m5");
    public static final String INPUT_X1 = "x1";
    public static final String INPUT_X2 = "x2";
    public static final String INPUT_X3 = "x3";
    public static final String INPUT_X4 = "x4";
    public static final String INPUT_X5 = "x5";
    public static final String INPUT_M1 = "m1";
    public static final String INPUT_M2 = "m2";
    public static final String INPUT_M3 = "m3";
    public static final String INPUT_M4 = "m4";
    public static final String INPUT_M5 = "m5";
    public static final String OUTPUT_A = "a";
    public static final String OUTPUT_B = "b";
    public static final String OUTPUT_C = "c";
    public static final String OUTPUT_D = "d";
    public static final String OUTPUT_E = "e";
    public static final String OUTPUT_F = "f";
    public static final String OUTPUT_X1 = "x1";
    public static final String OUTPUT_X2 = "x2";
    public static final String OUTPUT_X3 = "x3";
    public static final String OUTPUT_X4 = "x4";
    public static final String OUTPUT_X5 = "x5";
    public static final String OUTPUT_M1 = "m1";
    public static final String OUTPUT_M2 = "m2";
    public static final String OUTPUT_M3 = "m3";
    public static final String OUTPUT_M4 = "m4";
    public static final String OUTPUT_M5 = "m5";
    public static final String OUTPUT_CODE = "code";
    private String mainFunctionName = "execute";
    private String workingDirectory = "";
    private String a = "";
    private String b = "";
    private String c = "";
    private String d = "";
    private String e = "";
    private String f = "";
    private double p = 0.0;
    private double q = 0.0;
    private double r = 0.0;
    private double s = 0.0;
    private double t = 0.0;
    private double u = 0.0;
    private final GraalAPI graalAPI = GraalAPI.getInstance();
    private GraalSafety safety = GraalSafety.SAFE;
    private final GraalSourceContainer jsCodeContainer = GraalSourceContainer.newLiteralContainer();
    private final GraalPerformerContainer.Local performerContainer = GraalPerformerContainer.getLocalPure();
    private volatile Path translatedDirectory = null;
    private volatile Value createEmptyObjectFunction = null;
    volatile Value mainFunction = null;

    public AbstractCallJS() {
        this.useVisibleResultParameter();
        this.addInputNumbers("x1");
        this.addInputNumbers("x2");
        this.addInputNumbers("x3");
        this.addInputNumbers("x4");
        this.addInputNumbers("x5");
        this.addInputMat("m1");
        this.addInputMat("m2");
        this.addInputMat("m3");
        this.addInputMat("m4");
        this.addInputMat("m5");
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_A);
        this.addOutputScalar(OUTPUT_B);
        this.addOutputScalar(OUTPUT_C);
        this.addOutputScalar(OUTPUT_D);
        this.addOutputScalar(OUTPUT_E);
        this.addOutputScalar(OUTPUT_F);
        this.addOutputNumbers("x1");
        this.addOutputNumbers("x2");
        this.addOutputNumbers("x3");
        this.addOutputNumbers("x4");
        this.addOutputNumbers("x5");
        this.addOutputMat("m1");
        this.addOutputMat("m2");
        this.addOutputMat("m3");
        this.addOutputMat("m4");
        this.addOutputMat("m5");
    }

    public String getMainFunctionName() {
        return this.mainFunctionName;
    }

    public AbstractCallJS setMainFunctionName(String mainFunctionName) {
        this.mainFunctionName = AbstractCallJS.nonEmptyTrimmed(mainFunctionName);
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public AbstractCallJS setWorkingDirectory(String workingDirectory) {
        if (!(workingDirectory = AbstractCallJS.nonNull(workingDirectory).trim()).equals(this.workingDirectory)) {
            this.closePerformerContainer();
            this.workingDirectory = workingDirectory;
        }
        return this;
    }

    public String getA() {
        return this.a;
    }

    public AbstractCallJS setA(String a) {
        this.a = a;
        return this;
    }

    public String getB() {
        return this.b;
    }

    public AbstractCallJS setB(String b) {
        this.b = b;
        return this;
    }

    public String getC() {
        return this.c;
    }

    public AbstractCallJS setC(String c) {
        this.c = c;
        return this;
    }

    public String getD() {
        return this.d;
    }

    public AbstractCallJS setD(String d) {
        this.d = d;
        return this;
    }

    public String getE() {
        return this.e;
    }

    public AbstractCallJS setE(String e) {
        this.e = e;
        return this;
    }

    public String getF() {
        return this.f;
    }

    public AbstractCallJS setF(String f) {
        this.f = f;
        return this;
    }

    public double getP() {
        return this.p;
    }

    public AbstractCallJS setP(double p) {
        this.p = p;
        return this;
    }

    public double getQ() {
        return this.q;
    }

    public AbstractCallJS setQ(double q) {
        this.q = q;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public AbstractCallJS setR(double r) {
        this.r = r;
        return this;
    }

    public double getS() {
        return this.s;
    }

    public AbstractCallJS setS(double s) {
        this.s = s;
        return this;
    }

    public double getT() {
        return this.t;
    }

    public AbstractCallJS setT(double t) {
        this.t = t;
        return this;
    }

    public double getU() {
        return this.u;
    }

    public AbstractCallJS setU(double u) {
        this.u = u;
        return this;
    }

    public boolean isConvertInputScalarToNumber() {
        return this.graalAPI.isConvertInputScalarToNumber();
    }

    public AbstractCallJS setConvertInputScalarToNumber(boolean convertInputScalarToNumber) {
        this.graalAPI.setConvertInputScalarToNumber(convertInputScalarToNumber);
        return this;
    }

    public boolean isConvertInputNumbersToArray() {
        return this.graalAPI.isConvertInputNumbersToArray();
    }

    public AbstractCallJS setConvertInputNumbersToArray(boolean convertInputNumbersToArray) {
        this.graalAPI.setConvertInputNumbersToArray(convertInputNumbersToArray);
        return this;
    }

    public boolean isConvertInputArraysToDouble() {
        return this.graalAPI.isConvertInputArraysToDouble();
    }

    public AbstractCallJS setConvertInputArraysToDouble(boolean convertInputArraysToDouble) {
        this.graalAPI.setConvertInputArraysToDouble(convertInputArraysToDouble);
        return this;
    }

    public boolean isConvertOutputIntegerToBriefForm() {
        return this.graalAPI.isConvertOutputIntegerToBriefForm();
    }

    public AbstractCallJS setConvertOutputIntegersToBriefForm(boolean convertOutputIntegersToBriefForm) {
        this.graalAPI.setConvertOutputIntegersToBriefForm(convertOutputIntegersToBriefForm);
        return this;
    }

    public GraalSafety getSafety() {
        return this.safety;
    }

    public AbstractCallJS setSafety(GraalSafety safety) {
        AbstractCallJS.nonNull(safety);
        if (safety != this.safety) {
            this.closePerformerContainer();
            this.safety = safety;
        }
        return this;
    }

    @Override
    public void initialize() {
        long t1 = AbstractCallJS.debugTime();
        this.compileSource(this.performerContainer.isJsEsmEvalReturnsExports());
        long t2 = AbstractCallJS.debugTime();
        this.translatedDirectory = this.translateWorkingDirectory();
        this.performerContainer.setCustomizer(this.safety);
        this.performerContainer.setWorkingDirectory(this.safety.isWorkingDirectorySupported() ? this.translatedDirectory : null);
        GraalAPI.JS.initializeJS(this.performerContainer);
        GraalPerformer performer = this.performerContainer.performer();
        long t3 = AbstractCallJS.debugTime();
        this.executeSource(performer);
        this.createEmptyObjectFunction = GraalAPI.JS.storedCreateEmptyObjectFunction(performer);
        long t4 = AbstractCallJS.debugTime();
        AbstractCallJS.logDebug(() -> String.format(Locale.US, "%s \"%s\" initialized in %.5f ms: %.6f ms recompiling + %.6f ms getting performer + %.6f ms executing module", this.executorName(), this.mainFunctionName, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
    }

    @Override
    public void process() {
        long t1 = AbstractCallJS.debugTime();
        if (this.createEmptyObjectFunction == null) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " is not initialized");
        }
        Value parameters = this.createEmptyObjectFunction.execute(new Object[0]);
        Value inputs = this.createEmptyObjectFunction.execute(new Object[0]);
        Value outputs = this.createEmptyObjectFunction.execute(new Object[0]);
        if (this.safety.isJavaAccessSupported()) {
            this.graalAPI.loadSystemParameters(this, parameters, this.translatedDirectory);
        }
        this.graalAPI.loadParameters(AbstractCallJS.subMap(this.parameters(), PARAMETERS_NAMES), parameters);
        this.graalAPI.readInputPorts(AbstractCallJS.subSet(this.inputPorts(), INPUTS_NAMES), inputs);
        long t2 = AbstractCallJS.debugTime();
        Value result = this.callFunction(parameters, inputs, outputs);
        long t3 = AbstractCallJS.debugTime();
        this.graalAPI.writeOutputPorts(AbstractCallJS.subSet(this.outputPorts(), OUTPUTS_NAMES), outputs);
        this.graalAPI.writeOutputPort(this.getOutputPort(DEFAULT_OUTPUT_PORT), result, true);
        long t4 = AbstractCallJS.debugTime();
        AbstractCallJS.logDebug(() -> String.format(Locale.US, "%s \"%s\" executed in %.5f ms: %.6f ms loading inputs + %.6f ms calling + %.6f ms returning outputs", this.executorName(), this.mainFunctionName, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
    }

    @Override
    public void close() {
        super.close();
        this.closePerformerContainer();
    }

    protected abstract String code(boolean var1);

    protected Value mainFunction() {
        return this.mainFunction;
    }

    protected void compileSource(boolean jsEsmEvalReturnsExports) {
        String mainFunctionName = this.getMainFunctionName();
        String code = this.code(jsEsmEvalReturnsExports);
        String script = JSInterpretation.addJSExportFunction(code, mainFunctionName, jsEsmEvalReturnsExports);
        this.jsCodeContainer.setModuleJS(script, "main_code");
        boolean changed = this.jsCodeContainer.changed();
        if (changed) {
            AbstractCallJS.logDebug(() -> "Changing code/settings of \"" + mainFunctionName + "\" detected: rebuilding performer");
            this.closePerformerContainer();
        }
        this.setOutputScalar(OUTPUT_CODE, script);
    }

    protected void executeSource(GraalPerformer performer) {
        if (this.mainFunction == null) {
            Value module = performer.perform(this.jsCodeContainer);
            this.mainFunction = JSInterpretation.addedJSModuleMember(module, this.getMainFunctionName(), performer);
        }
    }

    protected Value callFunction(Value graalParameters, Value graalInputs, Value graalOutputs) {
        Value mainFunction = this.mainFunction();
        if (mainFunction == null) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " is not properly initialized");
        }
        return mainFunction.execute(new Object[]{graalParameters, graalInputs, graalOutputs});
    }

    protected abstract String executorName();

    protected void closePerformerContainer() {
        this.mainFunction = null;
        this.performerContainer.freeResources();
    }

    private Path translateWorkingDirectory() {
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory(this.workingDirectory, this);
    }

    private static <K, V> Map<K, V> subMap(Map<K, V> map, Collection<K> requestedKeys) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (K key : requestedKeys) {
            V value = map.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    private static Collection<Port> subSet(Collection<Port> ports, Collection<String> requested) {
        return AbstractCallJS.subMap(ports.stream().collect(Collectors.toMap(Port::getName, p1 -> p1)), requested).values();
    }
}

