/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.mappings;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import net.algart.executors.api.Executor;
import net.algart.executors.api.mappings.MappingSpecification;
import net.algart.executors.api.mappings.core.UseMapping;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.parameters.ValueType;
import net.algart.math.IRange;

public final class MappingBuilder
implements Cloneable {
    private final MappingSpecification specification;
    private final List<String> keys;
    private final List<String> keyCaptions;
    private final List<String> enumItems;
    private final List<String> enumItemCaptions;

    private MappingBuilder(MappingSpecification specification, List<String> keys, List<String> keyCaptions, List<String> enumItems, List<String> enumItemCaptions) {
        this.specification = Objects.requireNonNull(specification, "Null specification");
        Objects.requireNonNull(keys, "Null keys");
        Set<String> ignoredKeys = specification.getIgnoredKeys();
        this.keys = new ArrayList<String>();
        this.keyCaptions = new ArrayList<String>();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            String keyOrRange = keys.get(i);
            Objects.requireNonNull(keyOrRange, "Null key #" + i);
            String caption = keyCaptions == null || i >= keyCaptions.size() ? null : keyCaptions.get(i);
            IRange range = this.keysRange(keyOrRange);
            if (range != null) {
                int max = (int)range.max();
                for (int key = (int)range.min(); key <= max; ++key) {
                    this.addKey(Integer.toString(key), caption, ignoredKeys);
                }
                continue;
            }
            this.addKey(keyOrRange, caption, ignoredKeys);
        }
        if (this.keys.isEmpty()) {
            throw new IllegalArgumentException("Empty list of keys");
        }
        for (String key : this.keys) {
            this.checkKey(key);
        }
        if (specification.isEnum()) {
            this.enumItems = new ArrayList<String>((Collection)Objects.requireNonNull(enumItems, "Null enum items"));
            ArrayList<String> arrayList = this.enumItemCaptions = enumItemCaptions == null ? null : new ArrayList<String>(enumItemCaptions);
            if (this.enumItems.isEmpty()) {
                throw new IllegalArgumentException("Empty list of enum items, but value type is " + String.valueOf((Object)specification.getControlTemplate().getValueType()));
            }
        } else {
            this.enumItems = null;
            this.enumItemCaptions = null;
        }
    }

    public static MappingBuilder read(Path specificationFile) throws IOException {
        MappingSpecification specification = MappingSpecification.read(specificationFile);
        return new UseMapping().mappingBuilder(specification, false);
    }

    public static MappingBuilder of(MappingSpecification specification, List<String> keys, List<String> keyCaptions, List<String> enumItems, List<String> enumItemCaptions) {
        return new MappingBuilder(specification, keys, keyCaptions, enumItems, enumItemCaptions);
    }

    public MappingSpecification specification() {
        return this.specification;
    }

    public Path specificationFile() {
        return this.specification.getSpecificationFile();
    }

    public String id() {
        return this.specification.getId();
    }

    public String category() {
        return this.specification.getCategory();
    }

    public String name() {
        return this.specification.getName();
    }

    public String className() {
        return this.specification.className();
    }

    public String description() {
        return this.specification.getDescription();
    }

    public int numberOfKeys() {
        return this.keys.size();
    }

    public List<String> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public String key(int k) {
        return this.keys.get(k);
    }

    public List<String> keyCaptions() {
        return Collections.unmodifiableList(this.keyCaptions);
    }

    public String keyCaption(int k) {
        return this.keyCaptions.get(k);
    }

    public List<String> enumItems() {
        return this.enumItems == null ? null : Collections.unmodifiableList(this.enumItems);
    }

    public List<String> enumItemCaptions() {
        return this.enumItemCaptions == null ? null : Collections.unmodifiableList(this.enumItemCaptions);
    }

    public JsonObject build(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        return this.build(executor.parameters());
    }

    public JsonObject build(Parameters parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        MappingSpecification.ControlTemplate controlTemplate = this.specification.getControlTemplate();
        for (String key : this.keys) {
            JsonValue jsonValue = MappingBuilder.getJsonValue(key, controlTemplate, parameters);
            assert (jsonValue != null);
            builder.add(key, jsonValue);
        }
        return builder.build();
    }

    public String toString() {
        return "mapping \"" + this.category() + "." + this.name() + "')";
    }

    public MappingBuilder clone() {
        try {
            return (MappingBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void checkKey(String key) {
        try {
            Long.parseLong(key);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (!SourceVersion.isIdentifier(key)) {
                throw new JsonException("Key \"" + key + "\" in mapping \"" + this.name() + "\" is not a valid Java identifier, not an integer number and not a correct integer range min..max; such keys are not allowed");
            }
            return;
        }
    }

    private IRange keysRange(String key) {
        int p = key.indexOf("..");
        if (p == -1) {
            return null;
        }
        try {
            int min = Integer.parseInt(key.substring(0, p));
            int max = Integer.parseInt(key.substring(p + 2));
            return IRange.of((long)min, (long)max);
        }
        catch (NumberFormatException e) {
            throw new JsonException("Key \"" + key + "\" in mapping \"" + this.name() + "\" is not a correct integer range min..max", (Throwable)e);
        }
    }

    private void addKey(String key, String caption, Set<String> ignoredKeys) {
        if (ignoredKeys == null || !ignoredKeys.contains(key)) {
            this.keys.add(key);
            if (caption != null) {
                caption = caption.replace("$$$", key);
            }
            this.keyCaptions.add(caption);
        }
    }

    public static String readNames(Path file) throws IOException {
        Objects.requireNonNull(file, "Null file");
        return Files.readString(file);
    }

    private static JsonValue getJsonValue(String name, MappingSpecification.ControlTemplate controlTemplate, Parameters parameters) {
        ValueType valueType = controlTemplate.getValueType();
        JsonValue jsonValue = null;
        if (parameters.containsKey(name)) {
            jsonValue = valueType.toJsonValue(parameters, name);
        }
        if (jsonValue == null) {
            jsonValue = controlTemplate.getDefaultJsonValue();
        }
        if (jsonValue == null) {
            jsonValue = valueType.emptyJsonValue();
        }
        return jsonValue;
    }
}

