/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.IncompatibleChainException;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.io.MatrixIO;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class MultiChainSpecification
extends AbstractConvertibleToJson {
    public static final String APP_NAME = "multi-chain";
    public static final String CURRENT_VERSION = "1.0";
    public static final String DEFAULT_MULTICHAIN_CATEGORY = "multichains";
    public static final String DEFAULT_MULTICHAIN_CATEGORY_PREFIX = "multichains.";
    public static final String DEFAULT_MULTICHAIN_NAME = "multichain";
    public static final String MULTICHAIN_FILE_PATTERN = ".*\\.(json|mchain)$";
    private static final boolean DEFAULT_PREFER_SELECTION_BY_ID = false;
    private static final String DEFAULT_MULTICHAIN_SETTINGS_NAME = "Multi-settings";
    private static final String DEFAULT_MULTICHAIN_SETTINGS_PREFIX = "Multi-settings ";
    private static final Pattern COMPILED_MULTICHAIN_FILE_PATTERN = Pattern.compile(".*\\.(json|mchain)$");
    private Path specificationFile = null;
    private String version = "1.0";
    private boolean autogeneratedCategory = false;
    private String category;
    private boolean autogeneratedSettingsCategory = false;
    private String settingsCategory;
    private boolean autogeneratedName = false;
    private String name;
    private boolean autogeneratedSettingsName = false;
    private String settingsName;
    private String description = null;
    private String settingsDescription = null;
    private String id;
    private String settingsId;
    private Options options = null;
    private List<String> chainVariantPaths = new ArrayList<String>();
    private String defaultChainVariantId = null;
    private String defaultChainVariantName = null;
    private Map<String, PortSpecification> inputPorts = new LinkedHashMap<String, PortSpecification>();
    private Map<String, PortSpecification> outputPorts = new LinkedHashMap<String, PortSpecification>();
    private Map<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();

    public MultiChainSpecification() {
    }

    private MultiChainSpecification(JsonObject json, boolean strictMode, Path file) {
        PortSpecification port;
        if (!MultiChainSpecification.isMultiChainSpecification(json) && strictMode) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a multi-chain configuration: no \"app\":\"multi-chain\" element");
        }
        this.specificationFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        String fileName = file == null ? null : MatrixIO.removeExtension((String)file.getFileName().toString());
        String recommendedName = ExecutionBlock.recommendedName(fileName);
        String recommendedCategory = ExecutionBlock.recommendedCategory(fileName);
        this.category = json.getString("category", null);
        if (this.category == null) {
            this.category = recommendedCategory != null ? DEFAULT_MULTICHAIN_CATEGORY_PREFIX + recommendedCategory : DEFAULT_MULTICHAIN_CATEGORY;
            this.autogeneratedCategory = true;
        }
        this.settingsCategory = json.getString("settings_category", null);
        if (this.settingsCategory == null) {
            this.settingsCategory = recommendedCategory != null ? "settings." + recommendedCategory : "settings";
            this.autogeneratedSettingsCategory = true;
        }
        this.name = json.getString("name", null);
        if (this.name == null) {
            this.name = recommendedName != null ? recommendedName : DEFAULT_MULTICHAIN_NAME;
            this.autogeneratedName = true;
        }
        this.settingsName = json.getString("settings_name", null);
        if (this.settingsName == null) {
            this.settingsName = recommendedName != null ? DEFAULT_MULTICHAIN_SETTINGS_PREFIX + recommendedName : DEFAULT_MULTICHAIN_SETTINGS_NAME;
            this.autogeneratedSettingsName = true;
        }
        this.description = json.getString("description", null);
        this.settingsDescription = json.getString("settings_description", null);
        this.id = Jsons.reqString(json, "id", file);
        String settingsId = json.getString("settings_id", null);
        this.settingsId = settingsId != null ? settingsId : MultiChainSpecification.modifyIdForSettings(this.id);
        JsonObject optionsJson = json.getJsonObject("options");
        if (optionsJson != null) {
            this.options = new Options(optionsJson, file);
        }
        this.chainVariantPaths = MultiChainSpecification.toFileNames(new ArrayList(), Jsons.reqJsonArray(json, "chain_variant_paths", file), "chain_variant_paths");
        this.defaultChainVariantId = json.getString("default_variant_id", null);
        this.defaultChainVariantName = json.getString("default_variant_name", null);
        for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "in_ports", file)) {
            port = new PortSpecification(jsonObject, file);
            ExecutorSpecification.putOrException(this.inputPorts, port.getName(), port, file, "in_ports");
        }
        for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "out_ports", file)) {
            port = new PortSpecification(jsonObject, file);
            ExecutorSpecification.putOrException(this.outputPorts, port.getName(), port, file, "out_ports");
        }
        for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "controls", file)) {
            ControlSpecification control = new ControlSpecification(jsonObject, file);
            ExecutorSpecification.putOrException(this.controls, control.getName(), control, file, "controls");
        }
    }

    public static MultiChainSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new MultiChainSpecification(json, true, specificationFile);
    }

    public static MultiChainSpecification readIfValid(Path specificationFile) {
        JsonObject json;
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        try {
            json = Jsons.readJson(specificationFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (!MultiChainSpecification.isMultiChainSpecification(json)) {
            return null;
        }
        return new MultiChainSpecification(json, true, specificationFile);
    }

    public static List<MultiChainSpecification> readAllIfValid(Path containingJsonPath) throws IOException {
        return ExecutorSpecification.readAllIfValid(null, containingJsonPath, true, MultiChainSpecification::readIfValid, MultiChainSpecification::isMultiChainSpecificationFile);
    }

    public void write(Path specificationFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        Files.writeString(specificationFile, (CharSequence)Jsons.toPrettyString(this.toJson()), options);
    }

    public static MultiChainSpecification of(JsonObject specificationJson, boolean strictMode) {
        return new MultiChainSpecification(specificationJson, strictMode, null);
    }

    public static boolean isMultiChainSpecificationFile(Path specificationFile) {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        return COMPILED_MULTICHAIN_FILE_PATTERN.matcher(specificationFile.getFileName().toString().toLowerCase()).matches();
    }

    public static boolean isMultiChainSpecification(JsonObject specificationJson) {
        Objects.requireNonNull(specificationJson, "Null specificationJson");
        return APP_NAME.equals(specificationJson.getString("app", null));
    }

    public static void checkIdDifference(Collection<MultiChainSpecification> specifications) {
        Objects.requireNonNull(specifications, "Null specifications");
        HashSet<String> ids = new HashSet<String>();
        for (MultiChainSpecification multiChainSpecification : specifications) {
            String id = multiChainSpecification.getId();
            String settingsId = multiChainSpecification.getSettingsId();
            assert (id != null);
            if (id.equals(settingsId)) {
                throw new AssertionError((Object)("Identical id and settingsId for multi-chain \"" + multiChainSpecification.getName() + "\": " + id));
            }
            if (!ids.add(id)) {
                throw new IllegalArgumentException("Two multi-chain JSONs have identical IDs " + id + ", one of them is \"" + multiChainSpecification.getName() + "\"");
            }
            if (settingsId == null || ids.add(settingsId)) continue;
            throw new IllegalArgumentException("Two settings JSONs have identical IDs " + settingsId + ", one of them is \"" + multiChainSpecification.getName() + "\"");
        }
    }

    public static void checkNameDifference(Collection<ChainSpecification> chains) {
        Objects.requireNonNull(chains, "Null chain JSONs collection");
        HashSet<String> names = new HashSet<String>();
        for (ChainSpecification chain : chains) {
            if (names.add(chain.chainName())) continue;
            Path file = chain.getSpecificationFile();
            throw new IllegalArgumentException("Two chain variants have identical name \"" + chain.chainName() + "\", but it is prohibited inside the single multi-chain! (One of 2 chain variants has ID \"" + chain.chainId() + "\"" + (String)(file == null ? "" : " and loaded from the file " + String.valueOf(file) + ".)"));
        }
    }

    public Path getSpecificationFile() {
        return this.specificationFile;
    }

    public String getVersion() {
        return this.version;
    }

    public MultiChainSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public boolean isAutogeneratedCategory() {
        return this.autogeneratedCategory;
    }

    public String getCategory() {
        return this.category;
    }

    public MultiChainSpecification setCategory(String category, boolean autogeneratedCategory) {
        this.category = Objects.requireNonNull(category, "Null category");
        this.autogeneratedCategory = autogeneratedCategory;
        return this;
    }

    public boolean isAutogeneratedSettingsCategory() {
        return this.autogeneratedSettingsCategory;
    }

    public String getSettingsCategory() {
        return this.settingsCategory;
    }

    public MultiChainSpecification setSettingsCategory(String settingsCategory, boolean autogeneratedSettingsCategory) {
        this.settingsCategory = Objects.requireNonNull(settingsCategory, "Null settingsCategory");
        this.autogeneratedSettingsCategory = autogeneratedSettingsCategory;
        return this;
    }

    public boolean isAutogeneratedName() {
        return this.autogeneratedName;
    }

    public String getName() {
        return this.name;
    }

    public MultiChainSpecification setName(String name, boolean autogeneratedName) {
        this.name = Objects.requireNonNull(name, "Null name");
        this.autogeneratedName = autogeneratedName;
        return this;
    }

    public boolean isAutogeneratedSettingsName() {
        return this.autogeneratedSettingsName;
    }

    public String getSettingsName() {
        return this.settingsName;
    }

    public MultiChainSpecification setSettingsName(String settingsName) {
        this.settingsName = Objects.requireNonNull(settingsName, "Null settingsName");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MultiChainSpecification setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getSettingsDescription() {
        return this.settingsDescription;
    }

    public MultiChainSpecification setSettingsDescription(String settingsDescription) {
        this.settingsDescription = settingsDescription;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public MultiChainSpecification setId(String id) {
        this.id = Objects.requireNonNull(id, "Null id");
        return this;
    }

    public MultiChainSpecification setIdAndSettingsId(String id) {
        this.id = Objects.requireNonNull(id, "Null id");
        this.settingsId = MultiChainSpecification.modifyIdForSettings(this.id);
        return this;
    }

    public String getSettingsId() {
        return this.settingsId;
    }

    public MultiChainSpecification setSettingsId(String settingsId) {
        this.settingsId = Objects.requireNonNull(settingsId, "Null settingsId");
        return this;
    }

    public Options getOptions() {
        return this.options;
    }

    public MultiChainSpecification setOptions(Options options) {
        this.options = options;
        return this;
    }

    public boolean isBehaviourSkippable() {
        return this.options != null && this.options.behavior != null && this.options.behavior.skippable;
    }

    public boolean isBehaviourSettingsRequired() {
        return this.options != null && this.options.behavior != null && this.options.behavior.settingsRequired;
    }

    public boolean isBehaviourStrictPorts() {
        return this.options != null && this.options.behavior != null && this.options.behavior.strictPorts;
    }

    public boolean isBehaviourStrictParameters() {
        return this.options != null && this.options.behavior != null && this.options.behavior.strictParameters;
    }

    public boolean isBehaviourPreferSelectionById() {
        return this.options != null && this.options.behavior != null ? this.options.behavior.preferSelectionById : false;
    }

    public List<String> getChainVariantPaths() {
        return Collections.unmodifiableList(this.chainVariantPaths);
    }

    public MultiChainSpecification setChainVariantPaths(List<String> chainVariantPaths) {
        this.chainVariantPaths = MultiChainSpecification.checkChainVariantPaths(chainVariantPaths);
        return this;
    }

    public String getDefaultChainVariantId() {
        return this.defaultChainVariantId;
    }

    public MultiChainSpecification setDefaultChainVariantId(String defaultChainVariantId) {
        this.defaultChainVariantId = defaultChainVariantId;
        return this;
    }

    public String getDefaultChainVariantName() {
        return this.defaultChainVariantName;
    }

    public MultiChainSpecification setDefaultChainVariantName(String defaultChainVariantName) {
        this.defaultChainVariantName = defaultChainVariantName;
        return this;
    }

    public Map<String, PortSpecification> getInputPorts() {
        return Collections.unmodifiableMap(this.inputPorts);
    }

    public MultiChainSpecification setInputPorts(Map<String, PortSpecification> inputPorts) {
        this.inputPorts = ExecutorSpecification.checkInputPorts(inputPorts);
        return this;
    }

    public Map<String, PortSpecification> getOutputPorts() {
        return Collections.unmodifiableMap(this.outputPorts);
    }

    public MultiChainSpecification setOutputPorts(Map<String, PortSpecification> outputPorts) {
        this.outputPorts = ExecutorSpecification.checkOutputPorts(outputPorts);
        return this;
    }

    public Map<String, ControlSpecification> getControls() {
        return Collections.unmodifiableMap(this.controls);
    }

    public MultiChainSpecification setControls(Map<String, ControlSpecification> controls) {
        this.controls = ExecutorSpecification.checkControls(controls);
        return this;
    }

    public String canonicalName() {
        return ExecutorSpecification.className(this.category, this.name);
    }

    public List<Path> resolveChainVariantPaths() {
        return this.chainVariantPaths.stream().map(p -> this.resolve((String)p, "chain path")).toList();
    }

    public List<ChainSpecification> readChainVariants() throws IOException {
        ArrayList<ChainSpecification> result = new ArrayList<ChainSpecification>();
        List<Path> paths = this.resolveChainVariantPaths();
        for (Path path : paths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                List<ChainSpecification> folderChains = ChainSpecification.readAllIfValid(path, false);
                folderChains.sort(Comparator.comparing(ChainSpecification::chainName));
                result.addAll(folderChains);
                continue;
            }
            if (Files.exists(path, new LinkOption[0])) {
                result.add(ChainSpecification.read(path));
                continue;
            }
            throw new NoSuchFileException("Cannot load multi-chain \"" + this.canonicalName() + "\", because the file/folder of the chain variant does not exist: " + String.valueOf(path));
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException("No valid chains found for multi-chain \"" + this.name + "\" among the following paths: " + String.valueOf(paths));
        }
        ChainSpecification.checkIdDifference(result);
        MultiChainSpecification.checkNameDifference(result);
        return result;
    }

    public void checkImplementationCompatibility(ExecutorSpecification specification, boolean enforceAllChecks) {
        Objects.requireNonNull(specification, "Null specification");
        if (enforceAllChecks || this.isBehaviourStrictPorts()) {
            PortSpecification implementationPort;
            for (PortSpecification port : this.inputPorts.values()) {
                implementationPort = specification.getInputPort(port.getName());
                if (implementationPort == null || port.isCompatible(implementationPort)) continue;
                throw new IncompatibleChainException(this.checkImplementationMessageStart(specification) + " has incompatible input port \"" + port.getName() + "\"");
            }
            for (PortSpecification port : this.outputPorts.values()) {
                implementationPort = specification.getOutputPort(port.getName());
                if (implementationPort == null) {
                    throw new IncompatibleChainException(this.checkImplementationMessageStart(specification) + " has no output port \"" + port.getName() + "\"");
                }
                if (port.isCompatible(implementationPort)) continue;
                throw new IncompatibleChainException(this.checkImplementationMessageStart(specification) + " has incompatible output port \"" + port.getName() + "\"");
            }
        }
        if (enforceAllChecks || this.isBehaviourStrictParameters()) {
            for (ControlSpecification control : this.controls.values()) {
                ControlSpecification implementationControl = specification.getControl(control.getName());
                if (implementationControl != null) continue;
                throw new IncompatibleChainException(this.checkImplementationMessageStart(specification) + " has no parameter \"" + control.getName() + "\"");
            }
        }
    }

    private String checkImplementationMessageStart(ExecutorSpecification implementationSpecification) {
        return "Implementation \"" + implementationSpecification.getName() + "\" (ID \"" + implementationSpecification.getId() + "\") of multi-chain \"" + this.name + "\" (ID \"" + this.id + "\")";
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.category, "category");
        this.checkNull(this.name, "name");
        this.checkNull(this.id, "id");
        this.checkNull(this.settingsId, "settingsId");
    }

    public String toString() {
        return "MultiChainSpecification{specificationFile=" + String.valueOf(this.specificationFile) + ", version='" + this.version + "', category='" + this.category + "', settingsCategory='" + this.settingsCategory + "', name='" + this.name + "', settingsName='" + this.settingsName + "', description='" + this.description + "', settingsDescription='" + this.settingsDescription + "', id='" + this.id + "', settingsId='" + this.settingsId + "', options=" + String.valueOf(this.options) + ", chainVariantPaths=" + String.valueOf(this.chainVariantPaths) + ", defaultChainVariantId='" + this.defaultChainVariantId + "', defaultChainVariantName='" + this.defaultChainVariantName + "', inputPorts=" + String.valueOf(this.inputPorts) + ", outputPorts=" + String.valueOf(this.outputPorts) + ", controls=" + String.valueOf(this.controls) + "}";
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        builder.add("app", APP_NAME);
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        if (!this.autogeneratedCategory) {
            builder.add("category", this.category);
        }
        if (!this.autogeneratedSettingsCategory && this.settingsCategory != null) {
            builder.add("settings_category", this.settingsCategory);
        }
        if (!this.autogeneratedName) {
            builder.add("name", this.name);
        }
        if (!this.autogeneratedSettingsName && this.settingsName != null) {
            builder.add("settings_name", this.settingsName);
        }
        if (this.description != null) {
            builder.add("description", this.description);
        }
        if (this.settingsDescription != null) {
            builder.add("settings_description", this.settingsDescription);
        }
        builder.add("id", this.id);
        builder.add("settings_id", this.settingsId);
        if (this.options != null) {
            builder.add("options", (JsonValue)this.options.toJson());
        }
        JsonArrayBuilder chainVariantPathsBuilder = Json.createArrayBuilder();
        for (String string : this.chainVariantPaths) {
            chainVariantPathsBuilder.add(string);
        }
        builder.add("chain_variant_paths", (JsonValue)chainVariantPathsBuilder.build());
        if (this.defaultChainVariantId != null) {
            builder.add("default_variant_id", this.defaultChainVariantId);
        }
        if (this.defaultChainVariantName != null) {
            builder.add("default_variant_name", this.defaultChainVariantName);
        }
        JsonArrayBuilder inputPortsBuilder = Json.createArrayBuilder();
        for (PortSpecification portSpecification : this.inputPorts.values()) {
            inputPortsBuilder.add((JsonValue)portSpecification.toJson());
        }
        builder.add("in_ports", (JsonValue)inputPortsBuilder.build());
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (PortSpecification port : this.outputPorts.values()) {
            jsonArrayBuilder.add((JsonValue)port.toJson());
        }
        builder.add("out_ports", (JsonValue)jsonArrayBuilder.build());
        JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
        for (ControlSpecification control : this.controls.values()) {
            jsonArrayBuilder2.add((JsonValue)control.toJson());
        }
        builder.add("controls", (JsonValue)jsonArrayBuilder2.build());
    }

    private Path resolve(String path, String whatFile) {
        Path p = Paths.get(path = PathPropertyReplacement.translateProperties(path, this.specificationFile), new String[0]);
        if (p.isAbsolute()) {
            return p;
        }
        if (this.specificationFile == null) {
            throw new IllegalStateException("The " + whatFile + " is relative and cannot be resolved, because multi-chain JSON was not loaded from file; you must use absolute paths in this case");
        }
        return this.specificationFile.getParent().resolve(p);
    }

    private static List<String> checkChainVariantPaths(List<String> chainFileNames) {
        Objects.requireNonNull(chainFileNames, "Null array of chain file names");
        chainFileNames = new ArrayList<String>(chainFileNames);
        if (chainFileNames.isEmpty()) {
            throw new IllegalArgumentException("Empty array of chain file names");
        }
        int n = chainFileNames.size();
        for (int k = 0; k < n; ++k) {
            Objects.requireNonNull(chainFileNames.get(k), "Null element #" + k + " in list \"" + String.valueOf(chainFileNames) + "\"");
        }
        return chainFileNames;
    }

    private static <C extends Collection<String>> C toFileNames(C result, JsonArray fileNames, String whatList) {
        assert (fileNames != null);
        for (JsonValue value : fileNames) {
            if (!(value instanceof JsonString)) {
                throw new JsonException("Illegal value \"" + String.valueOf(value) + "\"in the list \"" + whatList + "\": it is not JSON string");
            }
            result.add((String)((JsonString)value).getString());
        }
        if (result.isEmpty()) {
            throw new JsonException("Empty list \"" + whatList + "\"");
        }
        return result;
    }

    private static String modifyIdForSettings(String id) {
        UUID uuid;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception e) {
            return id + "-settings";
        }
        uuid = new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits() ^ 0x73657474L);
        return uuid.toString();
    }

    public static void main(String[] args) throws IOException {
        String id = "9eb7f278-20dc-4d05-abdb-1c2a73657474";
        System.out.println(id);
        System.out.println(MultiChainSpecification.modifyIdForSettings(id));
        id = "some-non-uuid";
        System.out.println(id);
        System.out.println(MultiChainSpecification.modifyIdForSettings(id));
        MultiChainSpecification multiChainSpecification = MultiChainSpecification.read(Paths.get(args[0], new String[0]));
        System.out.println("Multi-chain:");
        System.out.println(multiChainSpecification);
        System.out.println("Chain paths:");
        System.out.println(multiChainSpecification.resolveChainVariantPaths());
        System.out.println("JSON:");
        System.out.println(Jsons.toPrettyString(multiChainSpecification.toJson()));
    }

    public static final class Options
    extends AbstractConvertibleToJson {
        private Behavior behavior = null;

        public Options() {
        }

        public Options(JsonObject json, Path file) {
            JsonObject behaviorJson = json.getJsonObject("behavior");
            if (behaviorJson != null) {
                this.behavior = new Behavior(behaviorJson, file);
            }
        }

        public Behavior getBehavior() {
            return this.behavior;
        }

        public Options setBehavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public void checkCompleteness() {
        }

        public String toString() {
            return "Options{behavior=" + String.valueOf(this.behavior) + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            if (this.behavior != null) {
                builder.add("behavior", (JsonValue)this.behavior.toJson());
            }
        }

        public static final class Behavior
        extends AbstractConvertibleToJson {
            private boolean skippable = false;
            private boolean settingsRequired = false;
            private boolean strictPorts = false;
            private boolean strictParameters = false;
            private boolean preferSelectionById = false;

            public Behavior() {
            }

            public Behavior(JsonObject json, Path file) {
                this.skippable = json.getBoolean("skippable", false);
                this.settingsRequired = json.getBoolean("settings_required", false);
                this.strictPorts = json.getBoolean("strict_ports", false);
                this.strictParameters = json.getBoolean("strict_parameters", false);
                this.preferSelectionById = json.getBoolean("prefer_selection_by_id", false);
            }

            public boolean isSkippable() {
                return this.skippable;
            }

            public Behavior setSkippable(boolean skippable) {
                this.skippable = skippable;
                return this;
            }

            public boolean isSettingsRequired() {
                return this.settingsRequired;
            }

            public Behavior setSettingsRequired(boolean settingsRequired) {
                this.settingsRequired = settingsRequired;
                return this;
            }

            public boolean isStrictPorts() {
                return this.strictPorts;
            }

            public Behavior setStrictPorts(boolean strictPorts) {
                this.strictPorts = strictPorts;
                return this;
            }

            public boolean isStrictParameters() {
                return this.strictParameters;
            }

            public Behavior setStrictParameters(boolean strictParameters) {
                this.strictParameters = strictParameters;
                return this;
            }

            public boolean isPreferSelectionById() {
                return this.preferSelectionById;
            }

            public Behavior setPreferSelectionById(boolean preferSelectionById) {
                this.preferSelectionById = preferSelectionById;
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Behavior{skippable=" + this.skippable + ", settingsRequired=" + this.settingsRequired + ", strictPorts=" + this.strictPorts + ", strictParameters=" + this.strictParameters + ", preferSelectionById=" + this.preferSelectionById + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("skippable", this.skippable);
                builder.add("settings_required", this.settingsRequired);
                builder.add("strict_ports", this.strictPorts);
                builder.add("strict_parameters", this.strictParameters);
                builder.add("prefer_selection_by_id", this.preferSelectionById);
            }
        }
    }
}

