/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains.core;

import jakarta.json.JsonObject;
import java.nio.file.Path;
import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.multichains.MultiChain;
import net.algart.executors.api.multichains.core.MultiChainExecutor;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.modules.core.common.FunctionTiming;
import net.algart.executors.modules.core.common.TimingStatistics;
import net.algart.json.Jsons;

public class InterpretMultiChain
extends MultiChainExecutor
implements ReadOnlyExecutionInput {
    public static final String SETTINGS = "settings";
    private final FunctionTiming timing = FunctionTiming.newDisabledInstance();

    public InterpretMultiChain() {
        this.addInputScalar(SETTINGS);
        this.addOutputScalar(SETTINGS);
        this.disableOnChangeParametersAutomatic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        long t6;
        long t5;
        long t4;
        String selectedChainSettingsString;
        long t3;
        long t2;
        long t1 = System.nanoTime();
        boolean doAction = this.parameters().getBoolean("_mch___doAction", true);
        if (!doAction) {
            ChainExecutor.copyInputToOutput(this);
            return;
        }
        JsonObject inputSettings = Jsons.toJson(this.getInputScalar(SETTINGS, true).getValue(), true);
        boolean absolutePaths = this.parameters().getBoolean("_cs___absolutePaths", true);
        boolean extractSubSettings = this.parameters().getBoolean("_mch___extractSubSettings", true);
        boolean ignoreParameters = this.parameters().getBoolean("_mch___ignoreInputParameter", false);
        MultiChain multiChain = this.multiChain();
        multiChain.setExtractSubSettings(extractSubSettings);
        SettingsBuilder multiChainSettingsBuilder = multiChain.settingsBuilder();
        multiChainSettingsBuilder.setAbsolutePaths(absolutePaths);
        String defaultChainVariant = ignoreParameters ? multiChain.defaultChainVariant() : this.parameters().getString(multiChain.selectedChainParameter());
        String selectedChainVariant = multiChain.getSelectedChainVariant(inputSettings, defaultChainVariant);
        JsonObject executorSettings = ignoreParameters ? Jsons.newEmptyJson() : multiChainSettingsBuilder.build(this);
        Chain selectedChain = multiChain.findSelectedChain(selectedChainVariant);
        this.status().setExecutorSimpleClassName(multiChain.name() + ":" + (selectedChain.name() == null ? "" : selectedChain.name()));
        JsonObject multiChainSettings = multiChain.multiChainSettings(inputSettings);
        JsonObject selectedChainSettings = multiChain.selectedChainSettings(executorSettings, inputSettings, selectedChain);
        selectedChain.reinitializeAll();
        selectedChain.setCaller(this);
        System.Logger.Level timingLogLevel = InterpretMultiChain.ofLogLevel(this.parameters().getString("_mch___timingLogLevel", UseChain.TIMING_LOG_LEVEL_DEFAULT));
        int timingNumberOfCalls = LOG.isLoggable(timingLogLevel) ? this.parameters().getInteger("_mch___timingNumberOfCalls", 10) : 0;
        int timingNumberOfPercentiles = this.parameters().getInteger("_mch___timingNumberOfPercentiles", 5);
        TimingStatistics.Settings timingConfiguration = new TimingStatistics.Settings();
        timingConfiguration.setUniformPercentileLevels(timingNumberOfPercentiles);
        selectedChain.setTimingSettings(timingNumberOfCalls, timingConfiguration);
        this.timing.setSettings(timingNumberOfCalls, timingConfiguration);
        try {
            Parameters parametersCopy = new Parameters(this.parameters());
            multiChainSettingsBuilder.parseSettingsToParameters(parametersCopy, multiChainSettings);
            selectedChain.setParameters(parametersCopy);
            t2 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            selectedChain.readInputPortsFromExecutor(this);
            t3 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            selectedChainSettingsString = selectedChain.setSettings(selectedChainSettings);
            t4 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            selectedChain.executeNecessary(this);
            t5 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            selectedChain.writeOutputPortsToExecutor(this);
            t6 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
        }
        finally {
            selectedChain.freeData();
        }
        long t7 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
        this.timing.updatePassingData(t3 - t2 + t6 - t5);
        this.timing.updateExecution(t5 - t4);
        this.timing.updateSummary(t7 - t1);
        if (timingNumberOfCalls > 0 && this.parameters().getBoolean("_mch___logTiming", true)) {
            this.timing.analyse();
            Path file = multiChain.specification().getSpecificationFile();
            LOG.log(timingLogLevel, () -> String.format(Locale.US, "Multi-chain \"%s\", variant \"%s\" executed%s%s in %.3f ms:%n  %.5f ms initializing, %.5f ms loading inputs, %.5f ms set chain settings, %.5f ms process, %.5f ms returning outputs, %.5f ms freeing%n  multi-chain specification file: %s%n%s  All multi-chain \"%s\", %s", multiChain.name(), selectedChain.name(), selectedChain.isMultithreading() ? " (multithreading mode)" : " (single-thread mode)", selectedChain.isExecuteAll() ? " (ALL blocks)" : "", (double)(t7 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6, file == null ? "n/a" : "\"" + String.valueOf(file) + "\"", selectedChain.timingInfo(), multiChain.name(), this.timing));
        }
        System.Logger.Level settingsLogLevel = this.parameters().getBoolean("_mch___logSettings", false) ? System.Logger.Level.WARNING : System.Logger.Level.DEBUG;
        LOG.log(settingsLogLevel, () -> String.format(Locale.US, "Customizing multi-chain \"%s\", variant \"%s\" with help of %s (called from %s):\n%s", multiChain.name(), selectedChain.name(), extractSubSettings ? "extracted sub-settings" : "json-settings", InterpretMultiChain.quoteContextName(this), selectedChainSettings == null ? "    [this chain has no settings]" : selectedChainSettingsString));
        this.setOutputScalar(SETTINGS, selectedChainSettingsString);
        this.setOutputScalar("_ss___settings_id", multiChain.settingsId());
    }

    @Override
    public String visibleOutputPortName() {
        return this.parameters().getString("_mch___visibleResult", this.defaultOutputPortName());
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }

    private static String quoteContextName(Executor e) {
        String contextName = e.getContextName();
        return contextName == null ? "unnamed context #" + String.valueOf(e.getContextId()) : "\"" + contextName + "\"";
    }
}

