/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains.core;

import jakarta.json.JsonException;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.algart.executors.api.chains.ChainLoadingException;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.extensions.InstalledPlatformsForTechnology;
import net.algart.executors.api.multichains.MultiChain;
import net.algart.executors.api.multichains.MultiChainSpecification;
import net.algart.executors.api.multichains.core.InterpretMultiChain;
import net.algart.executors.api.multichains.core.MultiChainExecutor;
import net.algart.executors.api.multichains.core.UseMultiChainSettings;
import net.algart.executors.api.parameters.ValueType;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.json.Jsons;

public final class UseMultiChain
extends FileOperation {
    public static final String MULTICHAIN_TECHNOLOGY = "multichain";
    public static final String MULTICHAIN_LANGUAGE = "multichain";
    public static final String DO_ACTION_NAME = "_mch___doAction";
    public static final String DO_ACTION_CAPTION = "Do actions";
    public static final String DO_ACTION_DESCRIPTION = "If set, function is executed normally. If cleared, this function just copies all input data to the output ports with the same names and types (if they exist) and does not anything else.";
    public static final String LOG_TIMING_NAME = "_mch___logTiming";
    public static final String TIMING_LOG_LEVEL_NAME = "_mch___timingLogLevel";
    public static final String TIMING_NUMBER_OF_CALLS_NAME = "_mch___timingNumberOfCalls";
    public static final String TIMING_NUMBER_OF_PERCENTILES_NAME = "_mch___timingNumberOfPercentiles";
    public static final String VISIBLE_RESULT_PARAMETER_NAME = "_mch___visibleResult";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_NAME = "_mch___extractSubSettings";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_CAPTION = "Extract sub-settings \"%%%\" from source JSON";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_DESCRIPTION = "If set, the parameters of this multi-chain are determined by the section \"@%%%\" of the input settings JSON (when it exists). If cleared, the parameters of this multi-chain are always extracted directly from the top level of the input settings JSON. Parameters below have less priority than the contents of input settings.";
    public static final boolean EXTRACT_SUB_SETTINGS_PARAMETER_DEFAULT = true;
    public static final String LOG_SETTINGS_PARAMETER_NAME = "_mch___logSettings";
    public static final String LOG_SETTINGS_PARAMETER_CAPTION = "Log settings";
    public static final String LOG_SETTINGS_PARAMETER_DESCRIPTION = "If set, all settings, passed to the selected chain variant of this multi-chain, are logged with level WARNING.";
    public static final String IGNORE_PARAMETERS_PARAMETER_NAME = "_mch___ignoreInputParameter";
    public static final String IGNORE_PARAMETERS_PARAMETER_CAPTION = "Ignore parameters below";
    public static final String IGNORE_PARAMETERS_PARAMETER_DESCRIPTION = "If set, the behavior is fully determined by the input settings port and internal settings of the chain. All parameters below are not included into the settings JSON even if they are not specified in the section \"@%%%\" of the input settings JSON.\nHowever: if there are parameters in the selected chain that are specified in the chain blocks and not in the JSON, they are copied from the corresponding parameters below in any case.";
    public static final boolean IGNORE_PARAMETERS_PARAMETER_DEFAULT = false;
    static final String RECURSIVE_LOADING_BLOCKED_MESSAGE = "[recursive loading blocked]";
    private static final InstalledPlatformsForTechnology MULTI_CHAIN_PLATFORMS = InstalledPlatformsForTechnology.of("multichain");
    private static final DefaultExecutorLoader<MultiChain> MULTI_CHAIN_LOADER = new DefaultExecutorLoader("multi-chains loader");
    private boolean alsoSubChains = false;
    private boolean strictMode = false;

    public UseMultiChain() {
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public static UseMultiChain getInstance(String sessionId) {
        return UseMultiChain.setSession(new UseMultiChain(), sessionId);
    }

    public static UseMultiChain getSharedInstance() {
        return UseMultiChain.setShared(new UseMultiChain());
    }

    public static DefaultExecutorLoader<MultiChain> multiChainLoader() {
        return MULTI_CHAIN_LOADER;
    }

    public boolean isAlsoSubChains() {
        return this.alsoSubChains;
    }

    public UseMultiChain setAlsoSubChains(boolean alsoSubChains) {
        this.alsoSubChains = alsoSubChains;
        return this;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public UseMultiChain setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    public static MultiChainExecutor newSharedExecutor(Path file) throws IOException {
        return UseMultiChain.newSharedExecutor(file, CreateMode.REQUEST_ALL);
    }

    public static MultiChainExecutor newSharedExecutor(Path file, CreateMode createMode) throws IOException {
        return UseMultiChain.newSharedExecutor(MultiChainSpecification.read(file), createMode);
    }

    public static MultiChainExecutor newSharedExecutor(MultiChainSpecification specification, CreateMode createMode) throws IOException {
        return UseMultiChain.getSharedInstance().newExecutor(specification, createMode);
    }

    public MultiChainExecutor newExecutor(Path file, CreateMode createMode) throws IOException {
        return this.newExecutor(MultiChainSpecification.read(file), createMode);
    }

    public MultiChainExecutor newExecutor(MultiChainSpecification specification, CreateMode createMode) throws IOException {
        return this.use(specification).newExecutor(createMode);
    }

    @Override
    public void process() {
        try {
            this.useSeveralPaths(this.completeSeveralFilePaths());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void useSeveralPaths(List<Path> multiChainSpecificationPaths) throws IOException {
        Objects.requireNonNull(multiChainSpecificationPaths, "Null multi-chains paths");
        StringBuilder sb = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? new StringBuilder() : null;
        for (Path path : multiChainSpecificationPaths) {
            this.usePath(path, sb);
        }
        if (sb != null) {
            this.getScalar().setTo(sb.toString());
        }
    }

    public int usePath(Path multiChainSpecificationPath) throws IOException {
        return this.usePath(multiChainSpecificationPath, null);
    }

    public int usePath(Path path, StringBuilder report) throws IOException {
        List<ChainSpecification> chainSpecifications;
        List<MultiChainSpecification> multiChainSpecifications;
        Objects.requireNonNull(path, "Null multi-chain specifications path");
        if (this.skipIfMissingOrThrow(path, false, () -> "Multi-chain file or multi-chains folder " + String.valueOf(path) + " does not exist")) {
            return 0;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            multiChainSpecifications = MultiChainSpecification.readAllIfValid(path);
            chainSpecifications = this.alsoSubChains ? ChainSpecification.readAllIfValid(path, true) : Collections.emptyList();
        } else if (!this.alsoSubChains) {
            multiChainSpecifications = Collections.singletonList(MultiChainSpecification.read(path));
            chainSpecifications = Collections.emptyList();
        } else {
            MultiChainSpecification multiChainSpecification = MultiChainSpecification.readIfValid(path);
            multiChainSpecifications = multiChainSpecification == null ? Collections.emptyList() : Collections.singletonList(multiChainSpecification);
            ChainSpecification chainSpecification = ChainSpecification.readIfValid(path);
            List<Object> list = chainSpecifications = chainSpecification == null ? Collections.emptyList() : Collections.singletonList(chainSpecification);
            if (multiChainSpecification == null && chainSpecification == null) {
                throw new JsonException("JSON " + String.valueOf(path) + " is not a valid multi-chain or chain configuration");
            }
        }
        this.use(multiChainSpecifications, report);
        try (UseChain chainFactory = this.createChainFactory();){
            chainFactory.use(chainSpecifications, report);
        }
        return multiChainSpecifications.size();
    }

    public void use(List<MultiChainSpecification> multiChainSpecifications, StringBuilder report) throws IOException {
        MultiChainSpecification.checkIdDifference(multiChainSpecifications);
        UseChain chainFactory = this.createChainFactory();
        UseMultiChainSettings settingsFactory = this.createSettingsFactory();
        int n = multiChainSpecifications.size();
        for (int i = 0; i < n; ++i) {
            MultiChain multiChain;
            MultiChainSpecification multiChainSpecification = multiChainSpecifications.get(i);
            long t1 = UseMultiChain.infoTime();
            try {
                multiChain = this.use(multiChainSpecification, chainFactory, settingsFactory);
            }
            catch (ChainLoadingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ChainLoadingException("Cannot load multi-chain " + String.valueOf(multiChainSpecification.getSpecificationFile()), e);
            }
            long t2 = UseMultiChain.infoTime();
            List<ChainSpecification> chainSpecifications = multiChain.chainSpecifications();
            Set<String> blockedChainModelNames = multiChain.blockedChainSpecificationNames();
            int index = i;
            boolean hasBlocked = !blockedChainModelNames.isEmpty();
            LOG.log(hasBlocked ? System.Logger.Level.WARNING : System.Logger.Level.DEBUG, () -> String.format(Locale.US, "Multi-chain %s\"%s\" loaded from %s in %.3f ms;%n%d chain variants%s:%n%s", n > 1 ? index + 1 + "/" + n + " " : "", multiChainSpecification.getName(), multiChainSpecification.getSpecificationFile().toAbsolutePath(), (double)(t2 - t1) * 1.0E-6, chainSpecifications.size(), hasBlocked ? " (some of them were NOT loaded now due to recursive loading)" : "", chainSpecifications.stream().map(m -> String.format("  \"%s\"%s from %s", m.chainName(), blockedChainModelNames.contains(m.chainName()) ? " [recursive loading blocked]" : "", m.getSpecificationFile())).collect(Collectors.joining(String.format("%n", new Object[0])))));
        }
        if (report != null) {
            for (MultiChainSpecification multiChainSpecification : multiChainSpecifications) {
                Path file = multiChainSpecification.getSpecificationFile();
                Object message = file != null ? file.toString() : multiChainSpecification.canonicalName() + " (no file)";
                report.append((String)message).append("\n");
            }
        }
    }

    public MultiChain use(MultiChainSpecification multiChainSpecification) throws IOException {
        UseChain chainFactory = this.createChainFactory();
        UseMultiChainSettings settingsFactory = this.createSettingsFactory();
        return this.use(multiChainSpecification, chainFactory, settingsFactory);
    }

    public MultiChain use(MultiChainSpecification multiChainSpecification, UseChain chainFactory, UseMultiChainSettings settingsFactory) throws IOException {
        MultiChain multiChain = MultiChain.of(multiChainSpecification, chainFactory, settingsFactory);
        multiChain.checkImplementationCompatibility(this.strictMode);
        MULTI_CHAIN_LOADER.registerWorker(this.getSessionId(), UseMultiChain.buildMultiChainSpecification(multiChain), multiChain);
        return multiChain;
    }

    public static ExecutorSpecification buildMultiChainSpecification(MultiChain multiChain) {
        Objects.requireNonNull(multiChain, "Null multiChain");
        MultiChainSpecification specification = multiChain.specification();
        ExecutorSpecification result = new ExecutorSpecification();
        result.setTo(new InterpretMultiChain());
        result.setSourceInfo(multiChain.multiChainSpecificationFile(), null);
        result.setId(multiChain.id());
        result.setCategory(ExecutorSpecification.correctDynamicCategory(multiChain.category()));
        result.setName(multiChain.name());
        result.setDescription(multiChain.description());
        result.setLanguage("multichain");
        result.setInputPorts(specification.getInputPorts());
        result.setOutputPorts(specification.getOutputPorts());
        UseChain.addSettingsPorts(result);
        SettingsBuilder multiChainSettingsBuilder = multiChain.settingsBuilder();
        UseMultiChain.addSystemParameters(result, multiChain);
        UseSettings.addMultiChainControlsAndPorts(result, multiChain.multiChainOnlyCommonSettingsBuilder());
        result.setSettings(multiChainSettingsBuilder.specification());
        ExecutorSpecification.Options options = result.createOptionsIfAbsent();
        options.createControllingIfAbsent().setGrouping(true).setGroupSelector(multiChain.selectedChainParameter());
        options.createServiceIfAbsent().setSettingsId(multiChainSettingsBuilder.id());
        ControlSpecification visibleResult = UseChain.createVisibleResultControl(result, VISIBLE_RESULT_PARAMETER_NAME);
        if (visibleResult != null) {
            result.addControl(visibleResult);
        }
        return result;
    }

    public static void useAllInstalledInSharedContext() throws IOException {
        UseMultiChain useMultiChain = UseMultiChain.getSharedInstance();
        for (String folder : MULTI_CHAIN_PLATFORMS.installedSpecificationFolders()) {
            long t1 = System.nanoTime();
            int n = useMultiChain.usePath(Paths.get(folder, new String[0]));
            long t2 = System.nanoTime();
            UseMultiChain.logInfo(() -> String.format(Locale.US, "Loading %d installed multi-chain specifications from %s: %.3f ms", n, folder, (double)(t2 - t1) * 1.0E-6));
        }
    }

    private static void addSystemParameters(ExecutorSpecification result, MultiChain multiChain) {
        String multiChainName = multiChain.name();
        if (multiChain.specification().isBehaviourSkippable()) {
            result.addControl(new ControlSpecification().setName(DO_ACTION_NAME).setCaption(DO_ACTION_CAPTION).setDescription(DO_ACTION_DESCRIPTION).setValueType(ValueType.BOOLEAN).setDefaultJsonValue(JsonValue.TRUE).setAdvanced(false));
        }
        result.addControl(UseChain.createLogTimingControl(LOG_TIMING_NAME));
        result.addControl(UseChain.createTimingLogLevelControl(TIMING_LOG_LEVEL_NAME));
        result.addControl(UseChain.createTimingNumberOfCallsControl(TIMING_NUMBER_OF_CALLS_NAME));
        result.addControl(UseChain.createTimingNumberOfPercentilesControl(TIMING_NUMBER_OF_PERCENTILES_NAME));
        result.addControl(new ControlSpecification().setName(EXTRACT_SUB_SETTINGS_PARAMETER_NAME).setCaption(EXTRACT_SUB_SETTINGS_PARAMETER_CAPTION.replace("%%%", multiChainName)).setDescription(EXTRACT_SUB_SETTINGS_PARAMETER_DESCRIPTION.replace("%%%", multiChainName)).setValueType(ValueType.BOOLEAN).setDefaultJsonValue(Jsons.booleanValue(true)).setAdvanced(true));
        result.addControl(new ControlSpecification().setName(LOG_SETTINGS_PARAMETER_NAME).setCaption(LOG_SETTINGS_PARAMETER_CAPTION).setDescription(LOG_SETTINGS_PARAMETER_DESCRIPTION).setValueType(ValueType.BOOLEAN).setDefaultJsonValue(JsonValue.FALSE).setAdvanced(true));
        result.addControl(new ControlSpecification().setName(IGNORE_PARAMETERS_PARAMETER_NAME).setCaption(IGNORE_PARAMETERS_PARAMETER_CAPTION).setDescription(IGNORE_PARAMETERS_PARAMETER_DESCRIPTION.replace("%%%", multiChainName)).setValueType(ValueType.BOOLEAN).setDefaultJsonValue(JsonValue.FALSE).setAdvanced(true));
    }

    private UseChain createChainFactory() {
        UseChain chainFactory = new UseChain();
        chainFactory.setSessionId(this.getSessionId());
        return chainFactory;
    }

    private UseMultiChainSettings createSettingsFactory() {
        UseMultiChainSettings settingsFactory = new UseMultiChainSettings();
        settingsFactory.setSessionId(this.getSessionId());
        return settingsFactory;
    }

    static {
        UseMultiChain.globalLoaders().register(MULTI_CHAIN_LOADER);
    }
}

