/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.parameters;

import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.algart.executors.api.parameters.NoValidParameterException;
import net.algart.executors.api.parameters.Parameters;
import net.algart.json.Jsons;

public enum ValueType {
    INT("int", (Class)Integer.TYPE, new String[]{"int32"}){

        @Override
        public Integer toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Parameters.smartParseInt(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Integer toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.intValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.intValue(0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            int v;
            try {
                v = Parameters.smartParseInt(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.intValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.intValue(parameters.getInteger(name));
        }
    }
    ,
    LONG("long", (Class)Long.TYPE, new String[]{"int64"}){

        @Override
        public Long toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Parameters.smartParseLong(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Long toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.longValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.intValue(0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            long v;
            try {
                v = Parameters.smartParseLong(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.longValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.longValue(parameters.getLong(name));
        }
    }
    ,
    FLOAT("float", (Class)Float.TYPE, new String[0]){

        @Override
        public Float toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Float.valueOf((float)Double.parseDouble(stringValue));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Float toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return Float.valueOf((float)jsonNumber.doubleValue());
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.doubleValue(0.0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return DOUBLE.toJsonValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return DOUBLE.toJsonValue(parameters, name);
        }
    }
    ,
    DOUBLE("double", (Class)Double.TYPE, new String[0]){

        @Override
        public Double toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Double toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                return jsonNumber.doubleValue();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.doubleValue(0.0);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            double v;
            try {
                v = Double.parseDouble(scalar);
            }
            catch (NumberFormatException e) {
                return this.emptyJsonValue();
            }
            return Jsons.doubleValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.doubleValue(parameters.getDouble(name));
        }
    }
    ,
    BOOLEAN("boolean", (Class)Boolean.TYPE, new String[0]){

        @Override
        public Boolean toParameter(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            return Parameters.smartParseBoolean(stringValue);
        }

        @Override
        public Boolean toParameter(JsonValue jsonValue) {
            if (jsonValue == null) {
                return null;
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                return Boolean.FALSE;
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.booleanValue(false);
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            Boolean v = Parameters.smartParseBoolean(scalar);
            if (v == null) {
                return this.emptyJsonValue();
            }
            return Jsons.booleanValue(v);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.booleanValue(parameters.getBoolean(name));
        }
    }
    ,
    STRING("String", (Class)String.class, new String[]{"scalar"}){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public String toParameter(JsonValue jsonValue) {
            if (jsonValue == null) {
                return null;
            }
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                return "false";
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                return "true";
            }
            if (jsonValue instanceof JsonNumber) {
                return jsonValue.toString();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.stringValue("");
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return Jsons.stringValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.stringValue(parameters.getString(name));
        }
    }
    ,
    ENUM_STRING("String", (Class)Enum.class, new String[]{"scalar"}){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public Object toParameter(JsonValue jsonValue) {
            return STRING.toParameter(jsonValue);
        }

        @Override
        public JsonValue emptyJsonValue() {
            return STRING.emptyJsonValue();
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            return STRING.toJsonValue(scalar);
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return STRING.toJsonValue(parameters, name);
        }
    }
    ,
    SETTINGS("settings", (Class)JsonObject.class, new String[0]){

        @Override
        public String toParameter(String stringValue) {
            return stringValue;
        }

        @Override
        public Object toParameter(JsonValue jsonValue) {
            if (jsonValue instanceof JsonObject) {
                return jsonValue;
            }
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            return null;
        }

        @Override
        public JsonValue emptyJsonValue() {
            return Jsons.newEmptyJson();
        }

        @Override
        public JsonValue toJsonValue(String scalar) {
            Objects.requireNonNull(scalar, "Null scalar");
            try {
                return Jsons.toJson(scalar, true);
            }
            catch (JsonException e) {
                return this.emptyJsonValue();
            }
        }

        @Override
        public JsonValue toJsonValue(Parameters parameters, String name) throws NoValidParameterException {
            return Jsons.toJson(parameters.getString(name, null), true);
        }
    };

    private final String typeName;
    private final Class<?> javaType;
    private final String[] typeNameAliases;
    private static final Map<String, ValueType> ALL_TYPES;
    private static final List<String> ALL_RECOMMENDED_TYPE_NAMES;
    private static final ValueType[] FOR_SUITABLE_JAVA_OBJECT;

    private ValueType(String typeName, Class<?> javaType, String ... typeNameAliases) {
        this.typeName = Objects.requireNonNull(typeName);
        this.javaType = Objects.requireNonNull(javaType);
        this.typeNameAliases = Objects.requireNonNull(typeNameAliases);
    }

    public static Collection<String> typeNames() {
        return Collections.unmodifiableList(ALL_RECOMMENDED_TYPE_NAMES);
    }

    public String typeName() {
        return this.typeName;
    }

    public List<String> aliases() {
        return List.of(this.typeNameAliases);
    }

    public Class<?> javaType() {
        return this.javaType;
    }

    public abstract Object toParameter(String var1);

    public abstract Object toParameter(JsonValue var1);

    public Object toSmartParameter(JsonValue jsonValue) {
        Object probe = this.toParameter(jsonValue);
        if (probe != null) {
            return probe;
        }
        for (ValueType valueType : FOR_SUITABLE_JAVA_OBJECT) {
            probe = valueType.toParameter(jsonValue);
            if (probe == null) continue;
            return probe;
        }
        return null;
    }

    public abstract JsonValue emptyJsonValue();

    public abstract JsonValue toJsonValue(Parameters var1, String var2) throws NoValidParameterException;

    public abstract JsonValue toJsonValue(String var1);

    public boolean isAllowedInExecutor() {
        return this != SETTINGS;
    }

    public boolean isSettings() {
        return this == SETTINGS;
    }

    public static ValueType ofTypeName(String typeName) {
        Objects.requireNonNull(typeName, "Null type name");
        return ValueType.fromTypeName(typeName).orElseThrow(() -> new IllegalArgumentException("Unknown parameter value type \"" + typeName + "\""));
    }

    public static Optional<ValueType> fromTypeName(String typeName) {
        return Optional.ofNullable(ALL_TYPES.get(typeName));
    }

    static {
        ALL_TYPES = new LinkedHashMap<String, ValueType>();
        ALL_RECOMMENDED_TYPE_NAMES = new ArrayList<String>();
        FOR_SUITABLE_JAVA_OBJECT = new ValueType[]{SETTINGS, STRING, DOUBLE, BOOLEAN};
        for (ValueType type : ValueType.values()) {
            if (type == ENUM_STRING) continue;
            ALL_RECOMMENDED_TYPE_NAMES.add(type.typeName);
            ALL_TYPES.put(type.typeName, type);
            for (String alias : type.typeNameAliases) {
                ALL_TYPES.put(alias, type);
            }
        }
    }
}

