/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.settings.ReplaceExistingSettingsMode;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.json.Jsons;

public final class AddSubSettings
extends Executor
implements ReadOnlyExecutionInput {
    public static final String SETTINGS = "settings";
    public static final String SUB_SETTINGS = "sub-settings";
    private String subSettingsName = "subsettings";
    private ReplaceExistingSettingsMode replaceExistingSettingsMode = ReplaceExistingSettingsMode.OVERRIDE;
    private boolean useSubSettingsPrefix = true;

    public AddSubSettings() {
        this.setDefaultInputScalar(SETTINGS);
        this.addInputScalar(SUB_SETTINGS);
        this.setDefaultOutputScalar(SETTINGS);
    }

    public String getSubSettingsName() {
        return this.subSettingsName;
    }

    public AddSubSettings setSubSettingsName(String subSettingsName) {
        this.subSettingsName = AddSubSettings.nonEmpty(subSettingsName);
        return this;
    }

    public ReplaceExistingSettingsMode getReplaceExistingSettingsMode() {
        return this.replaceExistingSettingsMode;
    }

    public AddSubSettings setReplaceExistingSettingsMode(ReplaceExistingSettingsMode replaceExistingSettingsMode) {
        this.replaceExistingSettingsMode = AddSubSettings.nonNull(replaceExistingSettingsMode);
        return this;
    }

    public boolean isUseSubSettingsPrefix() {
        return this.useSubSettingsPrefix;
    }

    public AddSubSettings setUseSubSettingsPrefix(boolean useSubSettingsPrefix) {
        this.useSubSettingsPrefix = useSubSettingsPrefix;
        return this;
    }

    @Override
    public void process() {
        JsonObject settings = AddSubSettings.scalarToJson(this.getInputScalar(SETTINGS, true));
        JsonObject addedSubSettings = AddSubSettings.scalarToJson(this.getInputScalar(SUB_SETTINGS, true));
        String subSettingsKey = this.useSubSettingsPrefix ? ControlSpecification.settingsKey(this.subSettingsName) : this.subSettingsName;
        JsonObject existingSubSettings = settings.getJsonObject(subSettingsKey);
        JsonObject newSubSettings = this.replaceExistingSettingsMode.replace(existingSubSettings, addedSubSettings);
        JsonObject result = Jsons.createObjectBuilder(settings).add(subSettingsKey, (JsonValue)newSubSettings).build();
        this.getScalar(SETTINGS).setTo(Jsons.toPrettyString(result));
    }

    static JsonObject scalarToJson(SScalar scalar) {
        String s = scalar.getValueOrDefault("").trim();
        return s.isEmpty() ? Jsons.newEmptyJson() : Jsons.toJson(s);
    }
}

