/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.JsonObject;
import java.util.Locale;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.executors.api.settings.core.SettingsExecutor;
import net.algart.json.Jsons;

public class CombineSettings
extends SettingsExecutor
implements ReadOnlyExecutionInput {
    public CombineSettings() {
        this.addInputScalar("settings");
        this.setDefaultOutputScalar("settings");
        this.disableOnChangeParametersAutomatic();
    }

    public String combine() {
        this.execute();
        String s = this.getScalar("settings").getValue();
        if (s == null) {
            throw new IllegalStateException("CombineSettings does not return any settings");
        }
        return s;
    }

    public JsonObject combineJson() {
        return Jsons.toJson(this.combine());
    }

    @Override
    public void process() {
        this.setSystemOutputs();
        long t1 = CombineSettings.debugTime();
        SettingsBuilder settingsBuilder = this.settingsBuilder();
        SScalar inputSettings = this.getInputScalar("settings", true);
        settingsBuilder.setAbsolutePaths(this.parameters().getBoolean("_cs___absolutePaths", true));
        boolean extractSubSettings = this.parameters().getBoolean("_cs___extractSubSettings", false);
        settingsBuilder.setExtractSubSettings(extractSubSettings);
        String allSettings = !inputSettings.isInitialized() ? this.parameters().getString("settings", "").trim() : inputSettings.getValue();
        JsonObject executorSettings = settingsBuilder.build(this);
        JsonObject parentSettings = Jsons.toJson(allSettings, true);
        JsonObject overriddenSettings = settingsBuilder.overrideSettings(executorSettings, parentSettings);
        JsonObject resultSettings = this.correctSettings(overriddenSettings, settingsBuilder);
        settingsBuilder.splitSettingsToOutputPorts(this, resultSettings);
        String settingsString = Jsons.toPrettyString(resultSettings);
        this.getScalar("settings").setTo(settingsString);
        long t2 = CombineSettings.debugTime();
        CombineSettings.logDebug(() -> String.format(Locale.US, "Combining%s %ssettings \"%s\": %.3f ms%s", !inputSettings.isInitialized() ? "" : " and overriding" + (extractSubSettings ? " extracted " : ""), this instanceof CombineChainSettings ? "chain " : "", settingsBuilder.name(), (double)(t2 - t1) * 1.0E-6, LOGGABLE_TRACE ? "\n" + settingsString + (String)(!inputSettings.isInitialized() ? "" : "\nOriginal settings (from parameters):\n" + Jsons.toPrettyString(executorSettings) + "\nInput settings (that override parameters):\n" + inputSettings.getValue()) : ""));
    }

    @Override
    public String toString() {
        return "Combine " + String.valueOf(this.settingsBuilder != null ? this.settingsBuilder : "some non-initialized settings");
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }

    protected JsonObject correctSettings(JsonObject settingsJson, SettingsBuilder settingsBuilder) {
        return settingsJson;
    }
}

