/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledPlatformsForTechnology;
import net.algart.executors.api.parameters.ValueType;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.executors.api.settings.core.CombineSettings;
import net.algart.executors.api.settings.core.GetNamesOfChainSettings;
import net.algart.executors.api.settings.core.GetNamesOfSettings;
import net.algart.executors.api.settings.core.SettingsExecutor;
import net.algart.executors.api.settings.core.SplitChainSettings;
import net.algart.executors.api.settings.core.SplitSettings;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.json.Jsons;

public class UseSettings
extends FileOperation {
    public static final String SETTINGS_TECHNOLOGY = "settings";
    public static final String SETTINGS_LANGUAGE = "settings";
    public static final String OUTPUT_COMBINE_SPECIFICATION = "combine-specification";
    public static final String OUTPUT_SPLIT_SPECIFICATION = "split-specification";
    public static final String OUTPUT_GET_NAMES_SPECIFICATION = "get-names-specification";
    public static final String SETTINGS_NAME_OUTPUT_NAME = "_ss___settings_name";
    public static final String SETTINGS_NAME_OUTPUT_CAPTION = "settings_name";
    public static final String SETTINGS_ID_OUTPUT_NAME = "_ss___settings_id";
    public static final String SETTINGS_ID_OUTPUT_CAPTION = "Settings\u00a0ID";
    public static final String SETTINGS_ID_OUTPUT_HINT = "ID of the corresponding settings executor";
    public static final String ALL_SETTINGS_PARAMETER_NAME = "settings";
    public static final String ALL_SETTINGS_PARAMETER_CAPTION = "settings (all)";
    public static final String ALL_SETTINGS_PARAMETER_DESCRIPTION = "If contains non-empty string and if the input \"settings\" port is NOT initialized, it should be a JSON containing ALL settings for this function (in other words, the full settings set for the chain). If the input \"settings\" port is initialized, it plays the same role: ALL settings. In both cases, all parameters below and all other input ports (with sub-settings sections) are overridden by this JSON.\nNote: \"overriding\" does not mean \"replacing\": if the JSON does not contain some settings, this function will use the settings from the parameters below / other input settings ports.";
    public static final String ABSOLUTE_PATHS_NAME_PARAMETER_NAME = "_cs___absolutePaths";
    public static final String ABSOLUTE_PATHS_NAME_PARAMETER_CAPTION = "Auto-replace paths to absolute";
    public static final String ABSOLUTE_PATHS_NAME_PARAMETER_DESCRIPTION = "If set, all parameters below, describing paths to files or folders, are automatically replaced with full absolute disk paths. It can be useful if you need to pass these parameters to other chains, that probably work in other \"current\" directories.\nAlso, in this case you can use in such parameters Java system properties: \"${name}\", like \"${java.io.tmpdir}\", and executor system properties \"${path.name.ext}\", \"${path.name}\", \"${file.name.ext}\", \"${file.name}\" (chain path/file name with/without extension).\nNOTE: this flag does not affect the settings JSON passed via \"settings (all)\" parameter or via the input \"settings\" port.";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_NAME = "_cs___extractSubSettings";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_CAPTION = "Extract sub-settings \"%%%\" from input \"settings\" JSON";
    public static final String EXTRACT_SUB_SETTINGS_PARAMETER_FOR_CHAIN_DESCRIPTION = "If set, the parameters of this chain are determined by the section \"@%%%\" of the input settings JSON. If cleared, the parameters of this chain are extracted directly from the top level of the input settings JSON. Parameters below have less priority, they are used only if there are no parameters with same names in the input settings JSON or its section \"@%%%\" and if the flag \"Ignore parameters below\" is not set.\nNormal state of this flag \u2014 set to true. Usually every chain B1, B2, ... of your chain B is customized by some sub-settings of main JSON settings, specifying behaviour of the chain B.However, sometimes you need just to pass all settings to next chaining level without changes; then you can clear this flag.";
    public static final boolean EXTRACT_SUB_SETTINGS_PARAMETER_FOR_CHAIN_DEFAULT = true;
    public static final String IGNORE_PARAMETERS_PARAMETER_NAME = "_cs___ignoreInputParameter";
    public static final String IGNORE_PARAMETERS_PARAMETER_CAPTION = "Ignore parameters below";
    public static final String IGNORE_PARAMETERS_PARAMETER_DESCRIPTION = "If set, the behavior is completely determined by the input settings port and internal settings of the chain. All parameters below are not included into the settings JSON even if there is no input settings.\nHowever: if there are parameters in the chain that are specified in the chain blocks and not in the JSON, they are copied from the corresponding parameters below in any case.";
    public static final boolean IGNORE_PARAMETERS_PARAMETER_DEFAULT = false;
    public static final String LOG_SETTINGS_PARAMETER_NAME = "_cs___logSettings";
    public static final String LOG_SETTINGS_PARAMETER_CAPTION = "Log settings";
    public static final String LOG_SETTINGS_PARAMETER_DESCRIPTION = "If set, all settings, passed to the chain, are logged with level WARNING. Can be used for debugging needs.";
    public static final String PATH_PARENT_FOLDER_HINT = "Parent folder of the previous path.";
    public static final String PATH_FILE_NAME_HINT = "File/subfolder name of the previous path (without parent folders).";
    private static final InstalledPlatformsForTechnology SETTINGS_PLATFORMS = InstalledPlatformsForTechnology.of("settings");
    private static final DefaultExecutorLoader<SettingsBuilder> SETTINGS_LOADER = new DefaultExecutorLoader("settings loader");
    private boolean recursiveScanning = true;
    private String settingsSpecification = "";
    private boolean mainSettings;
    private SettingsBuilder settingsBuilder = null;
    private ExecutorSpecification combineExecutorSpecification = null;
    private ExecutorSpecification splitExecutorSpecification = null;
    private ExecutorSpecification getNamesExecutorSpecification = null;

    public UseSettings() {
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_COMBINE_SPECIFICATION);
        this.addOutputScalar(OUTPUT_SPLIT_SPECIFICATION);
        this.addOutputScalar(OUTPUT_GET_NAMES_SPECIFICATION);
    }

    public static UseSettings getInstance(String sessionId) {
        return UseSettings.setSession(new UseSettings(), sessionId);
    }

    public static UseSettings getSharedInstance() {
        return UseSettings.setShared(new UseSettings());
    }

    public static DefaultExecutorLoader<SettingsBuilder> settingsLoader() {
        return SETTINGS_LOADER;
    }

    public final boolean isRecursiveScanning() {
        return this.recursiveScanning;
    }

    public final UseSettings setRecursiveScanning(boolean recursiveScanning) {
        this.recursiveScanning = recursiveScanning;
        return this;
    }

    public final String getSettingsSpecification() {
        return this.settingsSpecification;
    }

    public final UseSettings setSettingsSpecification(String settingsSpecification) {
        this.settingsSpecification = UseSettings.nonNull(settingsSpecification);
        return this;
    }

    @Override
    public final UseSettings setFile(String file) {
        super.setFile(file);
        return this;
    }

    public SettingsBuilder settingsBuilder() {
        if (this.settingsBuilder == null) {
            throw new IllegalStateException("Settings were not registered yet");
        }
        return this.settingsBuilder;
    }

    public static CombineSettings newSharedExecutor(ExecutorFactory factory, Path file) throws IOException {
        return UseSettings.newSharedExecutor(factory, SettingsSpecification.read(file));
    }

    public static CombineSettings newSharedExecutor(ExecutorFactory factory, SettingsSpecification specification) {
        return UseSettings.getSharedInstance().newExecutor(factory, specification);
    }

    public CombineSettings newExecutor(ExecutorFactory factory, Path file) throws IOException {
        Objects.requireNonNull(factory, "Null executor factory");
        return this.newExecutor(factory, SettingsSpecification.read(file));
    }

    public CombineSettings newExecutor(ExecutorFactory factory, SettingsSpecification specification) {
        Objects.requireNonNull(factory, "Null executor factory");
        return factory.newExecutor(CombineSettings.class, this.use(specification).id(), CreateMode.REQUEST_DEFAULT);
    }

    @Override
    public void process() {
        if (this.hasFile()) {
            try {
                this.useSeveralPaths(this.completeSeveralFilePaths());
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            return;
        }
        String settingsSpecification = this.settingsSpecification.trim();
        if (!settingsSpecification.isEmpty()) {
            this.useContent(settingsSpecification);
            return;
        }
        throw new IllegalArgumentException("One of arguments \"Settings JSON file/folder\" or \"Settings specification\" must be non-empty");
    }

    public void useSeveralPaths(List<Path> settingsSpecificationPaths) throws IOException {
        Objects.requireNonNull(settingsSpecificationPaths, "Null settings paths");
        this.mainSettings = false;
        if (this.isMainChainSettings() && settingsSpecificationPaths.size() > 1) {
            throw new IllegalArgumentException("Processing several paths is not allowed here, but you specified " + settingsSpecificationPaths.size() + " paths: " + String.valueOf(settingsSpecificationPaths));
        }
        StringBuilder sb = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? new StringBuilder() : null;
        for (Path path : settingsSpecificationPaths) {
            this.usePath(path, null, sb);
        }
        if (sb != null) {
            this.getScalar().setTo(sb.toString());
        }
    }

    public void usePath(Path settingsSpecificationPath) throws IOException {
        this.usePath(settingsSpecificationPath, null, null);
    }

    public int usePath(Path path, ExtensionSpecification.Platform platform, StringBuilder report) throws IOException {
        List<SettingsSpecification> settingsSpecifications;
        Objects.requireNonNull(path, "Null settings specification path");
        this.mainSettings = false;
        if (this.skipIfMissingOrThrow(path, false, () -> "Settings specification file or folder " + String.valueOf(path) + " does not exist")) {
            return 0;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            settingsSpecifications = SettingsSpecification.readAllIfValid(path, this.recursiveScanning, this.isMainChainSettings());
            if (this.isExistingSettingsRequired() && settingsSpecifications.isEmpty()) {
                throw new IllegalArgumentException("No any main chain settings was found in a folder " + String.valueOf(path));
            }
        } else {
            settingsSpecifications = Collections.singletonList(SettingsSpecification.read(path));
        }
        SettingsSpecification.checkIdDifference(settingsSpecifications);
        int n = settingsSpecifications.size();
        boolean showContent = this.isMainChainSettings() && n == 1;
        for (int i = 0; i < n; ++i) {
            SettingsSpecification settingsSpecification = settingsSpecifications.get(i);
            UseSettings.logDebug("Loading settings " + (String)(n > 1 ? i + 1 + "/" + n + " " : "") + "from " + String.valueOf(settingsSpecification.getSpecificationFile().toAbsolutePath()) + "...");
            if (platform != null) {
                settingsSpecification.addTags(platform.getTags());
                settingsSpecification.setPlatformId(platform.getId());
                settingsSpecification.setPlatformCategory(platform.getCategory());
            }
            this.use(settingsSpecification);
            if (!showContent || report == null) continue;
            report.append(settingsSpecification.jsonString());
        }
        if (!showContent && report != null) {
            for (SettingsSpecification settingsSpecification : settingsSpecifications) {
                report.append(settingsSpecification.getSpecificationFile()).append("\n");
            }
        }
        if (n == 1) {
            if (this.combineExecutorSpecification != null) {
                this.getScalar(OUTPUT_COMBINE_SPECIFICATION).setTo(this.combineExecutorSpecification.jsonString());
            }
            if (this.splitExecutorSpecification != null) {
                this.getScalar(OUTPUT_SPLIT_SPECIFICATION).setTo(this.splitExecutorSpecification.jsonString());
            }
            if (this.getNamesExecutorSpecification != null) {
                this.getScalar(OUTPUT_GET_NAMES_SPECIFICATION).setTo(this.getNamesExecutorSpecification.jsonString());
            }
        }
        return n;
    }

    public void useContent(String settingsSpecificationContent) {
        SettingsSpecification settingsSpecification = SettingsSpecification.of(Jsons.toJson(settingsSpecificationContent), false);
        UseSettings.logDebug("Using settings '" + settingsSpecification.getName() + "' from the text argument...");
        this.use(settingsSpecification);
        if (this.isOutputNecessary(DEFAULT_OUTPUT_PORT)) {
            this.getScalar().setTo(settingsSpecification.jsonString());
        }
    }

    public SettingsBuilder use(SettingsSpecification settingsSpecification) {
        ExecutorSpecification getNamesSpecification;
        this.mainSettings = settingsSpecification.isMain();
        settingsSpecification.updateAutogeneratedCategory(this.isMainChainSettings());
        String sessionId = this.getSessionId();
        SettingsBuilder settingsBuilder = this.newSettings(settingsSpecification);
        ExecutorSpecification combineSpecification = this.buildCombineSpecification(settingsBuilder);
        SETTINGS_LOADER.registerWorker(sessionId, combineSpecification, settingsBuilder);
        ExecutorSpecification splitSpecification = this.buildSplitSpecification(settingsBuilder);
        if (splitSpecification != null) {
            SETTINGS_LOADER.registerWorker(sessionId, splitSpecification, settingsBuilder);
        }
        if ((getNamesSpecification = this.buildGetNamesSpecification(settingsBuilder)) != null) {
            SETTINGS_LOADER.registerWorker(sessionId, getNamesSpecification, settingsBuilder);
        }
        this.settingsBuilder = settingsBuilder;
        return this.settingsBuilder;
    }

    public void useAllInstalled() throws IOException {
        for (ExtensionSpecification.Platform platform : SETTINGS_PLATFORMS.installedPlatforms()) {
            if (!platform.hasSpecifications()) continue;
            long t1 = System.nanoTime();
            int n = this.usePath(platform.specificationsFolder(), platform, null);
            long t2 = System.nanoTime();
            UseSettings.logInfo(() -> String.format(Locale.US, "Loading %d %s from %s: %.3f ms", n, this.installedSpecificationsCaption(), platform.specificationsFolder(), (double)(t2 - t1) * 1.0E-6));
        }
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("settingsCombinerJsonContent") ? "settingsSpecification" : name;
    }

    public ExecutorSpecification buildCombineSpecification(SettingsBuilder settingsBuilder) {
        Objects.requireNonNull(settingsBuilder, "Null settings");
        ExecutorSpecification result = UseSettings.buildCommon(this.newCombineSettings(), settingsBuilder);
        result.setId(settingsBuilder.id());
        result.setName(settingsBuilder.combineName());
        result.setDescription(settingsBuilder.combineDescription());
        this.addOwner(result, settingsBuilder);
        result.createOptionsIfAbsent().createRoleIfAbsent().setClassName(settingsBuilder.className()).setSettings(true).setResultPort("settings").setMain(this.isMainChainSettings());
        UseSettings.addInputControlsAndPorts(result, settingsBuilder, this.isMainChainSettings(), false, false);
        result.setSettings(settingsBuilder.specification());
        UseSettings.addOutputPorts(result, settingsBuilder);
        UseSettings.addSpecialOutputPorts(result);
        this.combineExecutorSpecification = result;
        return this.combineExecutorSpecification;
    }

    public ExecutorSpecification buildSplitSpecification(SettingsBuilder settingsBuilder) {
        Objects.requireNonNull(settingsBuilder, "Null settings");
        if (settingsBuilder.splitId() == null) {
            this.splitExecutorSpecification = null;
            return null;
        }
        ExecutorSpecification result = UseSettings.buildCommon(this.newSplitSettings(), settingsBuilder);
        result.setId(settingsBuilder.splitId());
        result.setName(settingsBuilder.splitName());
        result.setDescription(settingsBuilder.splitDescription());
        this.addOwner(result, settingsBuilder);
        UseSettings.addOutputPorts(result, settingsBuilder);
        UseSettings.addSpecialOutputPorts(result);
        this.splitExecutorSpecification = result;
        return this.splitExecutorSpecification;
    }

    public ExecutorSpecification buildGetNamesSpecification(SettingsBuilder settingsBuilder) {
        Objects.requireNonNull(settingsBuilder, "Null settings");
        if (settingsBuilder.getNamesId() == null) {
            this.getNamesExecutorSpecification = null;
            return null;
        }
        ExecutorSpecification result = UseSettings.buildCommon(this.newGetNamesOfSettings(), settingsBuilder);
        LinkedHashMap<String, ControlSpecification> executorControls = new LinkedHashMap<String, ControlSpecification>(result.getControls());
        ((ControlSpecification)executorControls.get("resultType")).setCaption("Result type");
        ((ControlSpecification)executorControls.get("resultJsonKey")).setCaption("Key in result JSON").setDefaultStringValue("names");
        for (ControlSpecification controlSpecification : executorControls.values()) {
            if (controlSpecification.getValueType() != ValueType.BOOLEAN || !controlSpecification.getName().startsWith("extract")) continue;
            controlSpecification.setDefaultJsonValue(JsonValue.TRUE);
        }
        result.setControls(executorControls);
        result.setId(settingsBuilder.getNamesId());
        result.setName(settingsBuilder.getNamesName());
        result.setDescription(settingsBuilder.getNamesDescription());
        this.addOwner(result, settingsBuilder);
        UseSettings.addSpecialOutputPorts(result);
        this.getNamesExecutorSpecification = result;
        return this.getNamesExecutorSpecification;
    }

    public static void useAllInstalledInSharedContext() throws IOException {
        UseSettings.getSharedInstance().useAllInstalled();
    }

    public static void addChainControlsAndPorts(ExecutorSpecification result, SettingsBuilder settingsBuilder) {
        boolean withSettings;
        boolean bl = withSettings = settingsBuilder != null;
        if (withSettings) {
            UseSettings.addInputControlsAndPorts(result, settingsBuilder, false, true, false);
        }
        UseSettings.addSystemOutputPorts(result, withSettings);
    }

    public static void addMultiChainControlsAndPorts(ExecutorSpecification result, SettingsBuilder settingsBuilder) {
        boolean withSettings;
        boolean bl = withSettings = settingsBuilder != null;
        if (withSettings) {
            UseSettings.addInputControlsAndPorts(result, settingsBuilder, false, false, true);
        }
        UseSettings.addSystemOutputPorts(result, withSettings);
    }

    protected boolean isMainChainSettings() {
        return this.mainSettings;
    }

    protected boolean isNeedToAddOwner() {
        return this.isMainChainSettings();
    }

    protected boolean isExistingSettingsRequired() {
        return this.isMainChainSettings();
    }

    protected SettingsBuilder newSettings(SettingsSpecification settingsSpecification) {
        return SettingsBuilder.of(settingsSpecification);
    }

    protected CombineSettings newCombineSettings() {
        return this.isMainChainSettings() ? new CombineChainSettings() : new CombineSettings();
    }

    protected SplitSettings newSplitSettings() {
        return this.isMainChainSettings() ? new SplitChainSettings() : new SplitSettings();
    }

    protected GetNamesOfSettings newGetNamesOfSettings() {
        return this.isMainChainSettings() ? new GetNamesOfChainSettings() : new GetNamesOfSettings();
    }

    protected Object customSettingsInformation() {
        return null;
    }

    String installedSpecificationsCaption() {
        return "installed settings specifications";
    }

    private void addOwner(ExecutorSpecification result, SettingsBuilder settingsBuilder) {
        if (this.isNeedToAddOwner()) {
            Object contextId = this.getContextId();
            String ownerId = this.getOwnerId();
            if (contextId != null || ownerId != null) {
                result.createOptionsIfAbsent().createOwnerIfAbsent().setName(this.getContextName()).setId(ownerId).setContextId(contextId == null ? null : contextId.toString());
            }
        }
    }

    private static ExecutorSpecification buildCommon(SettingsExecutor executor, SettingsBuilder settingsBuilder) {
        ExecutorSpecification result = new ExecutorSpecification();
        result.setTo(executor);
        result.setSourceInfo(settingsBuilder.specificationFile(), null);
        if (settingsBuilder.hasPlatformId()) {
            result.setPlatformId(settingsBuilder.platformId());
        }
        result.setLanguage("settings");
        result.setTags(settingsBuilder.tags());
        result.setCategory(ExecutorSpecification.correctDynamicCategory(settingsBuilder.category()));
        result.createOptionsIfAbsent().createServiceIfAbsent().setSettingsId(settingsBuilder.id());
        result.updateCategoryPrefix(settingsBuilder.platformCategory());
        return result;
    }

    private static void addInputControlsAndPorts(ExecutorSpecification result, SettingsBuilder settingsBuilder, boolean mainForChain, boolean chainMode, boolean noSystemFlags) {
        if (mainForChain) {
            result.addControl(new ControlSpecification().setName("settings").setCaption(ALL_SETTINGS_PARAMETER_CAPTION).setDescription(ALL_SETTINGS_PARAMETER_DESCRIPTION).setValueType(ValueType.SETTINGS).setDefaultJsonValue((JsonValue)Jsons.newEmptyJson()).setAdvanced(true));
        }
        if (!noSystemFlags) {
            String settingsName = settingsBuilder.name();
            if (chainMode) {
                UseSettings.addBooleanControl(result, EXTRACT_SUB_SETTINGS_PARAMETER_NAME, EXTRACT_SUB_SETTINGS_PARAMETER_CAPTION.replace("%%%", settingsName), EXTRACT_SUB_SETTINGS_PARAMETER_FOR_CHAIN_DESCRIPTION.replace("%%%", settingsName), true, false);
            }
            if (settingsBuilder.hasPathControl()) {
                UseSettings.addBooleanControl(result, ABSOLUTE_PATHS_NAME_PARAMETER_NAME, ABSOLUTE_PATHS_NAME_PARAMETER_CAPTION, ABSOLUTE_PATHS_NAME_PARAMETER_DESCRIPTION, true, false);
            }
        }
        if (chainMode && !noSystemFlags) {
            UseSettings.addBooleanControl(result, LOG_SETTINGS_PARAMETER_NAME, LOG_SETTINGS_PARAMETER_CAPTION, LOG_SETTINGS_PARAMETER_DESCRIPTION, false, true);
            UseSettings.addBooleanControl(result, IGNORE_PARAMETERS_PARAMETER_NAME, IGNORE_PARAMETERS_PARAMETER_CAPTION, IGNORE_PARAMETERS_PARAMETER_DESCRIPTION, false, true);
        }
        SettingsSpecification specification = settingsBuilder.specification();
        for (Map.Entry<String, ControlSpecification> entry : specification.getControls().entrySet()) {
            String name = entry.getKey();
            ControlSpecification controlSpecification = entry.getValue().clone();
            if (controlSpecification.getValueType().isSettings() && !chainMode) {
                PortSpecification portSpecification = new PortSpecification();
                portSpecification.setName(name);
                portSpecification.setCaption(controlSpecification.getCaption());
                portSpecification.setHint(controlSpecification.getDescription());
                portSpecification.setValueType(DataType.SCALAR);
                result.addInputPort(portSpecification);
            }
            result.addControl(controlSpecification);
        }
    }

    private static void addOutputPorts(ExecutorSpecification result, SettingsBuilder settingsBuilder) {
        Map<String, ControlSpecification> controls = settingsBuilder.specification().getControls();
        for (ControlSpecification controlSpecification : controls.values()) {
            String name = SettingsBuilder.portName(controlSpecification);
            PortSpecification portSpecification = new PortSpecification().setName(name).setCaption(controlSpecification.getCaption()).setHint(controlSpecification.getDescription()).setValueType(DataType.SCALAR).setAdvanced(controlSpecification.isAdvanced() && !controlSpecification.getValueType().isSettings());
            result.addOutputPort(portSpecification);
            if (controlSpecification.getValueType() != ValueType.STRING || !controlSpecification.getEditionType().isPath()) continue;
            result.addOutputPort(new PortSpecification().setName(name + "_parent").setHint(PATH_PARENT_FOLDER_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
            result.addOutputPort(new PortSpecification().setName(name + "_name").setHint(PATH_FILE_NAME_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    private static void addSystemOutputPorts(ExecutorSpecification result, boolean addSettingsIdPort) {
        result.addSystemExecutorIdPort();
        if (addSettingsIdPort) {
            result.addOutputPort(new PortSpecification().setName(SETTINGS_ID_OUTPUT_NAME).setCaption(SETTINGS_ID_OUTPUT_CAPTION).setHint(SETTINGS_ID_OUTPUT_HINT).setValueType(DataType.SCALAR).setAdvanced(true));
        }
        if (result.hasPlatformId()) {
            result.addSystemPlatformIdPort();
            result.addSystemResourceFolderPort();
        }
    }

    private static void addSpecialOutputPorts(ExecutorSpecification result) {
        UseSettings.addSystemOutputPorts(result, false);
        if (!result.getOutputPorts().containsKey(SETTINGS_NAME_OUTPUT_NAME)) {
            result.addOutputPort(new PortSpecification().setName(SETTINGS_NAME_OUTPUT_NAME).setCaption(SETTINGS_NAME_OUTPUT_CAPTION).setValueType(DataType.SCALAR).setAdvanced(true));
        }
    }

    private static void addBooleanControl(ExecutorSpecification result, String name, String caption, String description, boolean defaultValue, boolean advanced) {
        result.addControl(new ControlSpecification().setName(name).setCaption(caption).setDescription(description).setValueType(ValueType.BOOLEAN).setDefaultJsonValue(Jsons.booleanValue(defaultValue)).setAdvanced(advanced));
    }

    static {
        UseSettings.globalLoaders().register(SETTINGS_LOADER);
    }
}

