/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.parameters.ValueType;
import net.algart.executors.api.system.EditionType;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class ControlSpecification
extends AbstractConvertibleToJson
implements Cloneable {
    public static final String SUPPRESS_WARNING_NO_SETTER = "no_setter";
    private String name;
    private String description = null;
    private String caption = null;
    private String hint = null;
    private ValueType valueType;
    private volatile String valueClassName = null;
    private EditionType editionType = EditionType.VALUE;
    private volatile String settingsId = null;
    private boolean multiline = false;
    private Integer editionRows = null;
    private boolean resources = false;
    private boolean advanced = false;
    private List<EnumItem> items = null;
    private String itemsFile = null;
    private List<String> itemNamesInFile = null;
    private List<String> itemCaptionsInFile = null;
    private List<String> suppressWarnings = null;
    private JsonValue defaultJsonValue = null;

    public ControlSpecification() {
    }

    public ControlSpecification(JsonObject json, Path file) {
        JsonArray itemsJson;
        this.name = Jsons.reqString(json, "name", file);
        this.description = json.getString("description", null);
        this.caption = json.getString("caption", null);
        this.hint = json.getString("hint", null);
        String valueTypeName = Jsons.reqString(json, "value_type", file);
        this.valueType = ValueType.fromTypeName(valueTypeName).orElseThrow(() -> Jsons.badValue(json, "value_type", valueTypeName, ValueType.typeNames(), file));
        this.valueClassName = json.getString("value_class_name", null);
        String editionTypeName = json.getString("edition_type", EditionType.VALUE.typeName());
        this.editionType = EditionType.fromTypeName(editionTypeName).orElseThrow(() -> Jsons.badValue(json, "edition_type", editionTypeName, EditionType.typeNames(), file));
        this.settingsId = json.getString("settings_id", null);
        this.multiline = json.getBoolean("multiline", false);
        JsonNumber editionRows = json.getJsonNumber("edition_rows");
        Integer n = this.editionRows = editionRows == null ? null : Integer.valueOf(editionRows.intValue());
        if (this.editionRows != null && this.editionRows <= 0) {
            throw new IllegalArgumentException("Zero or negative number of rows = " + this.editionRows);
        }
        this.resources = json.getBoolean("resources", this.editionType.isResources());
        this.advanced = json.getBoolean("advanced", false);
        if (this.editionType == EditionType.ENUM && this.valueType == ValueType.STRING) {
            this.valueType = ValueType.ENUM_STRING;
        }
        if ((itemsJson = json.getJsonArray("items")) != null) {
            this.items = new ArrayList<EnumItem>();
            for (Object jsonValue : itemsJson) {
                if (!(jsonValue instanceof JsonObject)) {
                    throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": in control \"" + this.name + "\", \"items\" array contains non-object element " + String.valueOf(jsonValue));
                }
                this.items.add(new EnumItem((JsonObject)jsonValue, file));
            }
        }
        this.itemsFile = json.getString("items_file", null);
        JsonArray suppressWarningsJson = json.getJsonArray("suppress_warnings");
        if (suppressWarningsJson != null) {
            this.suppressWarnings = new ArrayList<String>();
            for (JsonValue jsonValue : suppressWarningsJson) {
                if (!(jsonValue instanceof JsonString)) {
                    throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": in control \"" + this.name + "\", \"suppress_warnings\" array contains non-string element " + String.valueOf(jsonValue));
                }
                JsonString jsonString = (JsonString)jsonValue;
                this.suppressWarnings.add(jsonString.getString());
            }
        }
        this.loadExternalData(file);
        try {
            this.setDefaultJsonValue((JsonValue)json.get((Object)"default"));
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": invalid control \"" + this.name + "\" (" + e.getMessage() + ")", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public ControlSpecification setName(String name) {
        this.name = Objects.requireNonNull(name, "Null name");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ControlSpecification setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public ControlSpecification setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public ControlSpecification setHint(String hint) {
        this.hint = hint;
        return this;
    }

    public ValueType getValueType() {
        assert (this.valueType != null) : "valueType cannot be null";
        return this.valueType;
    }

    public ControlSpecification setValueType(ValueType valueType) {
        this.valueType = Objects.requireNonNull(valueType, "Null valueType");
        return this;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public ControlSpecification setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
        return this;
    }

    public EditionType getEditionType() {
        return this.editionType;
    }

    public ControlSpecification setEditionType(EditionType editionType) {
        this.editionType = Objects.requireNonNull(editionType, "Null editionType");
        return this;
    }

    public String getSettingsId() {
        return this.settingsId;
    }

    public ControlSpecification setSettingsId(String settingsId) {
        this.settingsId = settingsId;
        return this;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public ControlSpecification setMultiline(boolean multiline) {
        this.multiline = multiline;
        return this;
    }

    public Integer getEditionRows() {
        return this.editionRows;
    }

    public ControlSpecification setEditionRows(Integer editionRows) {
        if (editionRows != null && editionRows <= 0) {
            throw new IllegalArgumentException("Zero or negative number of rows = " + editionRows);
        }
        this.editionRows = editionRows;
        return this;
    }

    public boolean isResources() {
        return this.resources;
    }

    public ControlSpecification setResources(boolean resources) {
        this.resources = resources;
        return this;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public ControlSpecification setAdvanced(boolean advanced) {
        this.advanced = advanced;
        return this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public List<EnumItem> getItems() {
        return this.items == null ? null : Collections.unmodifiableList(this.items);
    }

    public ControlSpecification setItems(List<EnumItem> items) {
        this.items = items == null ? null : new ArrayList<EnumItem>(items);
        return this;
    }

    public String getItemsFile() {
        return this.itemsFile;
    }

    public ControlSpecification setItemsFile(String itemsFile) {
        this.itemsFile = itemsFile;
        return this;
    }

    public Path itemsFile(Path siblingSpecificationFile) {
        return this.itemsFile == null ? null : ControlSpecification.resolveAgainstParent(siblingSpecificationFile, Paths.get(this.itemsFile, new String[0]));
    }

    public List<String> itemNamesInFile() {
        return this.itemNamesInFile;
    }

    public List<String> itemCaptionsInFile() {
        return this.itemCaptionsInFile;
    }

    public List<String> getSuppressWarnings() {
        return this.suppressWarnings == null ? null : Collections.unmodifiableList(this.suppressWarnings);
    }

    public ControlSpecification setSuppressWarnings(List<String> suppressWarnings) {
        this.suppressWarnings = suppressWarnings == null ? null : new ArrayList<String>(suppressWarnings);
        return this;
    }

    public boolean hasDefaultJsonValue() {
        return this.defaultJsonValue != null;
    }

    public JsonValue getDefaultJsonValue() {
        return this.defaultJsonValue;
    }

    public Object getDefaultValue() {
        return this.getValueType().toParameter(this.defaultJsonValue);
    }

    public ControlSpecification setDefaultJsonValue(JsonValue defaultJsonValue) {
        assert (this.valueType != null);
        if (defaultJsonValue != null && this.valueType.toParameter(defaultJsonValue) == null) {
            throw new IllegalArgumentException("Incorrect default JSON value \"" + String.valueOf(defaultJsonValue) + "\": it is not " + String.valueOf((Object)this.valueType));
        }
        this.defaultJsonValue = defaultJsonValue;
        return this;
    }

    public ControlSpecification setDefaultStringValue(String defaultStringValue) {
        this.defaultJsonValue = defaultStringValue == null ? null : Jsons.stringValue(defaultStringValue);
        return this;
    }

    public void setItemsFromLists(List<String> itemValues, List<String> itemCaptions) {
        Objects.requireNonNull(itemValues, "Null itemValues");
        int itemCaptionsSize = itemCaptions == null ? 0 : itemCaptions.size();
        this.items = new ArrayList<EnumItem>();
        int n = itemValues.size();
        for (int i = 0; i < n; ++i) {
            String enumItem = itemValues.get(i);
            EnumItem item = new EnumItem(enumItem);
            if (i < itemCaptionsSize) {
                item.setCaption(itemCaptions.get(i));
            }
            this.items.add(item);
        }
        if (this.defaultJsonValue == null && !this.items.isEmpty()) {
            this.setDefaultJsonValue(this.items.get((int)0).value);
        }
    }

    public boolean isSubSettings() {
        return this.getValueType().isSettings() && !"settings".equals(this.name);
    }

    public String key() {
        return this.getValueType().isSettings() ? ControlSpecification.settingsKey(this.name) : this.name;
    }

    public static String settingsKey(String subSettingsName) {
        Objects.requireNonNull(subSettingsName, "Null sub-settings name");
        return "@" + subSettingsName;
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.name, "name");
        this.checkNull((Object)this.valueType, "valueType");
        assert (this.editionType != null);
    }

    public String toString() {
        return "ControlSpecification{name='" + this.name + "', description='" + this.description + "', caption='" + this.caption + "', hint='" + this.hint + "', valueType=" + String.valueOf((Object)this.valueType) + ", valueClassName='" + this.valueClassName + "', editionType=" + String.valueOf((Object)this.editionType) + ", settingsID='" + this.settingsId + "', multiline=" + this.multiline + ", editionRows=" + this.editionRows + ", resources=" + this.resources + ", advanced=" + this.advanced + ", items=" + String.valueOf(this.items) + ", itemsFile='" + this.itemsFile + "', suppressWarnings=" + String.valueOf(this.suppressWarnings) + ", defaultJsonValue=" + String.valueOf(this.defaultJsonValue) + "}";
    }

    public ControlSpecification clone() {
        try {
            ControlSpecification result = (ControlSpecification)super.clone();
            if (this.items != null) {
                result.items = this.items.stream().map(EnumItem::clone).collect(Collectors.toList());
            }
            if (this.suppressWarnings != null) {
                result.suppressWarnings = new ArrayList<String>(this.suppressWarnings);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        JsonArrayBuilder arrayBuilder;
        builder.add("name", this.name);
        if (this.description != null) {
            builder.add("description", this.description);
        }
        if (this.caption != null) {
            builder.add("caption", this.caption);
        }
        if (this.hint != null) {
            builder.add("hint", this.hint);
        }
        builder.add("value_type", this.valueType.typeName());
        if (this.valueClassName != null) {
            builder.add("value_class_name", this.valueClassName);
        }
        builder.add("edition_type", this.editionType.typeName());
        if (this.settingsId != null) {
            builder.add("settings_id", this.settingsId);
        }
        if (this.multiline) {
            builder.add("multiline", this.multiline);
        }
        if (this.editionRows != null) {
            builder.add("edition_rows", this.editionRows.intValue());
        }
        if (this.resources) {
            builder.add("resources", this.resources);
        }
        if (this.advanced) {
            builder.add("advanced", this.advanced);
        }
        if (this.items != null) {
            arrayBuilder = Json.createArrayBuilder();
            for (EnumItem enumItem : this.items) {
                arrayBuilder.add((JsonValue)enumItem.toJson());
            }
            builder.add("items", (JsonValue)arrayBuilder.build());
        }
        if (this.itemsFile != null) {
            builder.add("items_file", this.itemsFile);
        }
        if (this.suppressWarnings != null) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.suppressWarnings) {
                arrayBuilder.add(string);
            }
            builder.add("suppress_warnings", (JsonValue)arrayBuilder.build());
        }
        if (this.defaultJsonValue != null) {
            builder.add("default", this.defaultJsonValue);
        }
    }

    public void loadExternalData(Path siblingSpecificationFile) {
        Path file;
        if (siblingSpecificationFile == null) {
            return;
        }
        if (this.items == null && (file = this.itemsFile(siblingSpecificationFile)) != null) {
            try {
                this.loadItems(file);
            }
            catch (IOException e) {
                throw new JsonException("Cannot load items file " + String.valueOf(file.toAbsolutePath()), (Throwable)e);
            }
            assert (this.items != null) : "items were not correctly loaded";
        }
    }

    public void loadItems(Path itemsFile) throws IOException {
        Objects.requireNonNull(itemsFile, "Null items file");
        String s = Files.readString(itemsFile);
        SScalar.MultiLineOrJsonSplitter items = SScalar.splitJsonOrTrimmedLinesWithComments(s);
        if (items.numberOfLines() == 0) {
            throw new JsonException("No enum items in the file " + String.valueOf(itemsFile.toAbsolutePath()));
        }
        this.itemNamesInFile = items.lines();
        this.itemCaptionsInFile = items.comments();
        assert (this.itemNamesInFile != null);
        assert (this.itemCaptionsInFile != null);
        this.setItemsFromLists(this.itemNamesInFile, this.itemCaptionsInFile);
    }

    private static Path resolveAgainstParent(Path siblingSpecificationFile, Path path) {
        Objects.requireNonNull(siblingSpecificationFile, "Null sibling specification file");
        if (path.isAbsolute()) {
            return path;
        }
        Path parent = siblingSpecificationFile.getParent();
        return parent == null ? path : parent.resolve(path);
    }

    public static final class EnumItem
    extends AbstractConvertibleToJson
    implements Cloneable {
        private JsonValue value;
        private String caption = null;

        public EnumItem() {
        }

        public EnumItem(JsonValue value) {
            this.setValue(value);
        }

        public EnumItem(String value) {
            this.setValue(value);
        }

        public EnumItem(JsonObject json, Path file) {
            this.value = Jsons.reqJsonValue(json, "value", file);
            this.caption = json.getString("caption", null);
        }

        public JsonValue getValue() {
            return this.value;
        }

        public EnumItem setValue(JsonValue value) {
            this.value = Objects.requireNonNull(value, "Null value");
            return this;
        }

        public EnumItem setValue(String value) {
            Objects.requireNonNull(value, "Null value");
            this.value = Jsons.stringValue(value);
            return this;
        }

        public String getCaption() {
            return this.caption;
        }

        public EnumItem setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.value, "value");
        }

        public String toString() {
            return "EnumItem{value='" + String.valueOf(this.value) + "', caption='" + this.caption + "'}";
        }

        public EnumItem clone() {
            try {
                return (EnumItem)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("value", this.value);
            if (this.caption != null) {
                builder.add("caption", this.caption);
            }
        }
    }
}

