/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Map;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.json.AbstractConvertibleToJson;

public enum CreateMode {
    NO_ACTIONS{

        @Override
        void customizeExecutor(ExecutionBlock result, String sessionId, ExecutorSpecification specification) {
        }
    }
    ,
    MINIMAL{

        @Override
        void customizeExecutor(ExecutionBlock result, String sessionId, ExecutorSpecification specification) {
            result.setSessionId(sessionId);
            result.setSpecification(specification);
        }
    }
    ,
    NO_REQUEST{

        @Override
        void customizeExecutor(ExecutionBlock result, String sessionId, ExecutorSpecification specification) {
            MINIMAL.customizeExecutor(result, sessionId, specification);
            Parameters parameters = result.parameters();
            for (Map.Entry<String, ControlSpecification> entry : specification.controls.entrySet()) {
                String name = entry.getKey();
                ControlSpecification controlSpecification = entry.getValue();
                Object defaultValue = controlSpecification.getDefaultValue();
                if (defaultValue == null) continue;
                parameters.put(name, defaultValue);
            }
            for (Map.Entry<String, AbstractConvertibleToJson> entry : specification.getInputPorts().entrySet()) {
                result.addPort(Port.newInput(entry.getKey(), ((PortSpecification)entry.getValue()).getValueType()));
            }
            for (Map.Entry<String, AbstractConvertibleToJson> entry : specification.getOutputPorts().entrySet()) {
                result.addPort(Port.newOutput(entry.getKey(), ((PortSpecification)entry.getValue()).getValueType()));
            }
        }
    }
    ,
    REQUEST_DEFAULT{

        @Override
        void customizeExecutor(ExecutionBlock result, String sessionId, ExecutorSpecification specification) {
            NO_REQUEST.customizeExecutor(result, sessionId, specification);
            result.requestDefaultOutput();
        }
    }
    ,
    REQUEST_ALL{

        @Override
        void customizeExecutor(ExecutionBlock result, String sessionId, ExecutorSpecification specification) {
            NO_REQUEST.customizeExecutor(result, sessionId, specification);
            result.setAllOutputsNecessary(true);
        }
    };


    abstract void customizeExecutor(ExecutionBlock var1, String var2, ExecutorSpecification var3);
}

