/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common;

import java.util.Locale;
import net.algart.executors.modules.core.common.TimingStatistics;

public class FunctionTiming {
    private int maximalNumberOfAnalysedCalls;
    private TimingStatistics execution;
    private TimingStatistics passingData;
    private TimingStatistics summary;

    private FunctionTiming(int maximalNumberOfAnalysedCalls) {
        if (maximalNumberOfAnalysedCalls < 0) {
            throw new IllegalArgumentException("Negative number of analysed calls for timing execution: " + maximalNumberOfAnalysedCalls);
        }
        this.maximalNumberOfAnalysedCalls = maximalNumberOfAnalysedCalls;
        this.resetStatistics();
    }

    public static FunctionTiming newDisabledInstance() {
        return new FunctionTiming(0);
    }

    public static FunctionTiming newInstance(int maximalNumberOfAnalysedCalls) {
        return new FunctionTiming(maximalNumberOfAnalysedCalls);
    }

    public int getMaximalNumberOfAnalysedCalls() {
        return this.maximalNumberOfAnalysedCalls;
    }

    public FunctionTiming setMaximalNumberOfAnalysedCalls(int maximalNumberOfAnalysedCalls) {
        if (maximalNumberOfAnalysedCalls != this.maximalNumberOfAnalysedCalls) {
            this.maximalNumberOfAnalysedCalls = maximalNumberOfAnalysedCalls;
            this.resetStatistics();
        }
        return this;
    }

    public FunctionTiming setSettings(TimingStatistics.Settings settings) {
        this.execution.setSettings(settings);
        this.passingData.setSettings(settings);
        this.summary.setSettings(settings);
        return this;
    }

    public FunctionTiming setSettings(int maximalNumberOfAnalysedCalls, TimingStatistics.Settings settings) {
        this.setMaximalNumberOfAnalysedCalls(maximalNumberOfAnalysedCalls);
        this.setSettings(settings);
        return this;
    }

    public final void resetStatistics() {
        this.execution = TimingStatistics.newInstance(this.maximalNumberOfAnalysedCalls);
        this.passingData = TimingStatistics.newInstance(this.maximalNumberOfAnalysedCalls);
        this.summary = TimingStatistics.newInstance(this.maximalNumberOfAnalysedCalls);
    }

    public long currentTime() {
        return this.execution.currentTime();
    }

    public void updateExecution(long time) {
        this.execution.update(time);
    }

    public void updatePassingData(long time) {
        this.passingData.update(time);
    }

    public void updateSummary(long time) {
        this.summary.update(time);
    }

    public void analyse() {
        this.execution.analyse();
        this.passingData.analyse();
        this.summary.analyse();
    }

    public TimingStatistics execution() {
        return this.execution;
    }

    public TimingStatistics passingData() {
        return this.passingData;
    }

    public TimingStatistics summary() {
        return this.summary;
    }

    public double summaryTimeOfLastAnalysedCalls() {
        return this.summary.summaryTimeOfLastAnalysedCalls();
    }

    public boolean isEmpty() {
        return this.execution.isEmpty();
    }

    public String toSimpleStringForSummary() {
        return this.toSimpleStringForSummary(null);
    }

    public String toSimpleStringForSummary(Double totalTimeOfLastAnalysedCalls) {
        return this.isEmpty() ? "was not executed" : "summary: " + this.summary.toSimpleString(totalTimeOfLastAnalysedCalls);
    }

    public String toString(String lineSeparator) {
        int n = this.execution.numberOfStoredTimes();
        return n == 0 ? "was not executed" : "timing for " + n + " last calls:" + lineSeparator + "summary:   " + String.valueOf(this.summary) + ", including" + lineSeparator + "execution: " + String.valueOf(this.execution) + " and" + lineSeparator + "copying:   " + String.valueOf(this.passingData);
    }

    public String toString() {
        return this.toString(String.format("%n      ", new Object[0]));
    }

    public static void main(String[] args) {
        TimingStatistics.Settings settings = new TimingStatistics.Settings().setUniformPercentileLevels(5);
        FunctionTiming timing = FunctionTiming.newInstance(100).setSettings(settings);
        for (int k = 1; k < 20; ++k) {
            if (k % 5 == 0) {
                timing.analyse();
            }
            System.out.println(timing.toString(String.format("%n    ", new Object[0])));
            timing.updateExecution(100 * k);
            timing.updatePassingData(30 - k);
            timing.updateSummary(200 * k);
        }
        for (int test = 1; test <= 15; ++test) {
            System.out.println();
            long info = 0L;
            int n = 1000000;
            long t1 = System.nanoTime();
            for (int k = 0; k < 1000000; ++k) {
                timing.updateExecution(100L);
                timing.updatePassingData(100L);
                timing.updateSummary(100L);
                info += timing.execution.sumOfAllCalls + timing.passingData.sumOfAllCalls + timing.summary.sumOfAllCalls;
            }
            long t2 = System.nanoTime();
            for (int k = 0; k < 1000000; ++k) {
                long tt1 = timing.currentTime();
                long tt2 = timing.currentTime();
                long tt3 = timing.currentTime();
                timing.updateExecution(tt1 - tt2);
                timing.updatePassingData(tt3 - tt2);
                timing.updateSummary(tt3 - tt1);
                info += timing.execution.sumOfAllCalls + timing.passingData.sumOfAllCalls + timing.summary.sumOfAllCalls;
            }
            long t3 = System.nanoTime();
            System.out.printf(Locale.US, "%d timings without actual currentTime: %.3f ms, %.2f ns/call%n", 1000000, (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1000000.0);
            System.out.printf(Locale.US, "%d normal timings: %.3f ms, %.2f ns/call (dummy: %d)%n", 1000000, (double)(t3 - t2) * 1.0E-6, (double)(t3 - t2) / 1000000.0, info);
        }
    }
}

