/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.awt;

import java.awt.image.BufferedImage;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SMat;
import net.algart.multimatrix.MultiMatrix;

public abstract class AWTFilter
extends Executor {
    private boolean convertMonoToColor = false;

    protected AWTFilter() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public boolean isConvertMonoToColor() {
        return this.convertMonoToColor;
    }

    public AWTFilter setConvertMonoToColor(boolean convertMonoToColor) {
        this.convertMonoToColor = convertMonoToColor;
        return this;
    }

    @Override
    public final void process() {
        SMat input = this.getInputMat();
        if (this.convertMonoToColor) {
            input = AWTFilter.convertMonoToColor(input);
        }
        BufferedImage source = input.toBufferedImage();
        BufferedImage target = this.process(source);
        this.getMat().setTo(target);
    }

    public abstract BufferedImage process(BufferedImage var1);

    public static SMat convertMonoToColor(SMat input) {
        Objects.requireNonNull(input, "Null input");
        if (input.getNumberOfChannels() == 1) {
            MultiMatrix source = input.toMultiMatrix2D().asOtherNumberOfChannels(3);
            if (source.bitsPerElement() == 1) {
                source = source.asPrecision((Class)Byte.TYPE);
            }
            input = SMat.of(source);
        }
        return input;
    }
}

