/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public abstract class MultiMatrixChannel2DFilter
extends MultiMatrix2DFilter
implements ChannelOperation {
    private int currentChannel = 0;
    private int numberOfChannels = 0;

    protected MultiMatrixChannel2DFilter() {
    }

    @Override
    public final int currentChannel() {
        return this.currentChannel;
    }

    @Override
    public final int numberOfChannels() {
        return this.numberOfChannels;
    }

    @Override
    public MultiMatrix2D process(MultiMatrix2D source) {
        List<Matrix<? extends PArray>> sourceChannels = source.allChannels();
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        this.numberOfChannels = sourceChannels.size();
        this.currentChannel = 0;
        while (this.currentChannel < this.numberOfChannels) {
            Matrix<? extends PArray> m = sourceChannels.get(this.currentChannel);
            result.add(this.processChannel(m));
            ++this.currentChannel;
        }
        return MultiMatrix.of2D(result);
    }

    protected abstract Matrix<? extends PArray> processChannel(Matrix<? extends PArray> var1);
}

