/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.multimatrix.MultiMatrix;

public abstract class MultiMatrixChannelGenerator
extends MultiMatrixGenerator
implements ChannelOperation {
    private int currentChannel = 0;

    protected MultiMatrixChannelGenerator() {
    }

    @Override
    public final int currentChannel() {
        return this.currentChannel;
    }

    @Override
    public final int numberOfChannels() {
        return this.getNumberOfChannels();
    }

    @Override
    public MultiMatrix create() {
        MultiMatrixChannelGenerator.logDebug(() -> "Creating image " + String.valueOf(this.getElementType()) + "[" + this.getNumberOfChannels() + "x" + this.getDimX() + "x" + this.getDimY() + "], creator \"" + this.getClass().getSimpleName() + "\"");
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        this.currentChannel = 0;
        while (this.currentChannel < this.numberOfChannels()) {
            result.add(this.createChannel());
            ++this.currentChannel;
        }
        return MultiMatrix.of(result);
    }

    protected abstract Matrix<? extends PArray> createChannel();
}

