/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.files.FileSortOrder;
import net.algart.executors.modules.core.files.ListOfFiles;
import net.algart.executors.modules.core.matrices.io.ReadImage;

public final class FindNextFile
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_INDEX = "file_index";
    public static final String OUTPUT_NUMBER_OF_FILES = "number_of_files";
    public static final String OUTPUT_LIST_OF_FILES = "list_of_files";
    public static final String OUTPUT_LAST = "last";
    private String globPattern = "*.{jpeg,jpg,png,gif,bmp}";
    private String regularExpression = "";
    private FileSortOrder sortOrder = FileSortOrder.SUBDIRECTORIES_FIRST;
    private boolean singlePath = false;
    private boolean recursiveScanning = true;
    private boolean clearFileIndexOnReset = true;
    private final List<Path> sortedFiles = new ArrayList<Path>();
    private String sortedFilesString = "";
    private int currentFileIndex = 0;

    public FindNextFile() {
        this.setFileExistenceRequired(false);
        this.addInputScalar("file");
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("absolute_path");
        this.addOutputScalar("parent_folder");
        this.addOutputScalar("file_name");
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public FindNextFile setGlobPattern(String globPattern) {
        this.globPattern = FindNextFile.nonEmpty(globPattern);
        return this;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public FindNextFile setRegularExpression(String regularExpression) {
        this.regularExpression = FindNextFile.nonNull(regularExpression);
        return this;
    }

    public FileSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public FindNextFile setSortOrder(FileSortOrder sortOrder) {
        this.sortOrder = FindNextFile.nonNull(sortOrder);
        return this;
    }

    public boolean isSinglePath() {
        return this.singlePath;
    }

    public FindNextFile setSinglePath(boolean singlePath) {
        this.singlePath = singlePath;
        return this;
    }

    public boolean isRecursiveScanning() {
        return this.recursiveScanning;
    }

    public FindNextFile setRecursiveScanning(boolean recursiveScanning) {
        this.recursiveScanning = recursiveScanning;
        return this;
    }

    public boolean isClearFileIndexOnReset() {
        return this.clearFileIndexOnReset;
    }

    public FindNextFile setClearFileIndexOnReset(boolean clearFileIndexOnReset) {
        this.clearFileIndexOnReset = clearFileIndexOnReset;
        return this;
    }

    public int currentFileIndex() {
        return this.currentFileIndex;
    }

    public int numberOfFiles() {
        return this.sortedFiles.size();
    }

    @Override
    public void initialize() {
        try {
            this.sortedFiles.clear();
            Path fileOrFolder = this.completeFilePath();
            if (this.singlePath || Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
                this.sortedFiles.add(fileOrFolder);
            } else {
                String regularExpression = this.regularExpression.trim();
                Pattern pattern = regularExpression.isEmpty() ? null : Pattern.compile(regularExpression);
                ListOfFiles.findFiles(this.sortedFiles, fileOrFolder, this.globPattern, pattern, this.recursiveScanning);
                if (this.isFileExistenceRequired() && this.sortedFiles.isEmpty()) {
                    throw new FileNotFoundException("No files in " + String.valueOf(fileOrFolder) + ", corresponding to pattern " + this.globPattern);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Collections.sort(this.sortedFiles);
        this.sortedFilesString = this.sortedFiles.stream().map(String::valueOf).collect(Collectors.joining("\n"));
        if (this.clearFileIndexOnReset) {
            this.currentFileIndex = 0;
        }
    }

    @Override
    public void process() {
        int numberOfFiles = this.sortedFiles.size();
        if (numberOfFiles == 0 && this.isFileExistenceRequired()) {
            throw new IllegalStateException("Illegal usage of process() method: initialize() was not successfully executed");
        }
        int fileIndex = this.currentFileIndex++;
        if (this.currentFileIndex >= numberOfFiles) {
            this.currentFileIndex = 0;
        }
        boolean last = this.currentFileIndex == 0;
        this.getScalar(OUTPUT_INDEX).setTo(fileIndex + 1);
        this.getScalar(OUTPUT_NUMBER_OF_FILES).setTo(numberOfFiles);
        this.getScalar(OUTPUT_LIST_OF_FILES).setTo(this.sortedFilesString);
        this.getScalar(OUTPUT_LAST).setTo(last);
        if (fileIndex >= numberOfFiles) {
            return;
        }
        Path fileToRead = this.sortedFiles.get(fileIndex).toAbsolutePath();
        Path absolutePath = fileToRead.toAbsolutePath();
        String result = absolutePath.toString();
        this.getScalar("absolute_path").setTo(result);
        this.getScalar("parent_folder").setTo(absolutePath.getParent().toString());
        this.getScalar("file_name").setTo(absolutePath.getFileName().toString());
        ReadImage readImage = ReadImage.getInstance();
        readImage.setFile(fileToRead.toString());
        this.getScalar().setTo(result);
    }

    @Override
    protected boolean nonEmptyPathRequired() {
        return true;
    }
}

