/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.executors.modules.core.files.RemoveFiles;

public final class RemoveFolder
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    private RemoveFiles.Stage stage = RemoveFiles.Stage.EXECUTE;
    private boolean doAction = true;

    public RemoveFolder() {
        this.addInputScalar("file");
        this.setDefaultOutputScalar("absolute_path");
    }

    public RemoveFiles.Stage getStage() {
        return this.stage;
    }

    public RemoveFolder setStage(RemoveFiles.Stage stage) {
        this.stage = RemoveFolder.nonNull(stage);
        return this;
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public RemoveFolder setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    @Override
    public void initialize() {
        Path fileOrFolder = this.completeFilePath().toAbsolutePath();
        if (this.stage == RemoveFiles.Stage.RESET) {
            this.removeFolder(fileOrFolder);
        }
    }

    @Override
    public void process() {
        Path fileOrFolder = this.completeFilePath().toAbsolutePath();
        if (this.stage == RemoveFiles.Stage.EXECUTE) {
            this.removeFolder(fileOrFolder);
        }
    }

    public void removeFolder(Path fileOrFolder) {
        block12: {
            if (!this.doAction) {
                return;
            }
            try {
                RemoveFolder.logDebug(() -> "Removing " + String.valueOf(fileOrFolder));
                if (Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
                    Files.delete(fileOrFolder);
                    break block12;
                }
                if (!Files.exists(fileOrFolder, new LinkOption[0])) {
                    if (this.isFileExistenceRequired()) {
                        throw new FileNotFoundException(String.valueOf(fileOrFolder) + " does not exist: nothing to remove");
                    }
                    return;
                }
                try (Stream<Path> walk = Files.walk(fileOrFolder, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).forEach(RemoveFolder::removeWithoutIOException);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private static void removeWithoutIOException(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

