/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import java.util.stream.DoubleStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.math.Point;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.Morphology;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixDifference
extends SeveralMultiMatricesChannelOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private static final Func SQR_FUNC = PowerFunc.getInstance((double)2.0, (double)1.0);
    private static final Func SQRT_FUNC = PowerFunc.getInstance((double)0.5, (double)1.0);
    private Operation operation = Operation.ABSOLUTE_DIFFERENCE;
    private double multiplier = 1.0;
    private Postprocessing postprocessing = Postprocessing.NONE;
    private int dilationSize = 0;
    private boolean floatResult = false;
    private boolean inputRequired = false;

    public MatrixDifference() {
        super(INPUT_X, INPUT_Y);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public MatrixDifference setOperation(Operation operation) {
        this.operation = MatrixDifference.nonNull(operation);
        return this;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public MatrixDifference setMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public Postprocessing getPostprocessing() {
        return this.postprocessing;
    }

    public MatrixDifference setPostprocessing(Postprocessing postprocessing) {
        this.postprocessing = MatrixDifference.nonNull(postprocessing);
        return this;
    }

    public int getDilationSize() {
        return this.dilationSize;
    }

    public MatrixDifference setDilationSize(int dilationSize) {
        this.dilationSize = MatrixDifference.nonNegative(dilationSize);
        return this;
    }

    public boolean isFloatResult() {
        return this.floatResult;
    }

    public MatrixDifference setFloatResult(boolean floatResult) {
        this.floatResult = floatResult;
        return this;
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public MatrixDifference setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix x = sources.get(0);
        MultiMatrix y = sources.get(1);
        if (x == null || y == null) {
            return null;
        }
        MultiMatrix result = this.multiplier == 1.0 && !this.floatResult ? x.asFunc(this.operation.diffFunc, y) : super.process(sources);
        if (this.operation == Operation.RGB_DISTANCE && result.numberOfChannels() > 1) {
            Matrix<? extends PArray> sum = MatrixDifference.sumOfChannelsSquares(result, false);
            result = MultiMatrix.ofMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)SQRT_FUNC, result.arrayType(), sum));
        }
        result = this.postprocessing.postprocess(result);
        if (this.dilationSize > 0) {
            BasicMorphology morphology = BasicMorphology.getInstance(null);
            UniformGridPattern pattern = Patterns.newSphereIntegerPattern((Point)Point.origin((int)result.dimCount()), (double)Math.max(0.0, 0.5 * (double)(this.dilationSize + 1) - 0.2));
            result = result.apply(arg_0 -> MatrixDifference.lambda$process$0((Morphology)morphology, (Pattern)pattern, arg_0));
        }
        return result;
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> m) {
        Matrix result;
        Class<? extends PArray> resultType = this.resultType(this.sampleType());
        if (this.multiplier == 1.0) {
            result = Matrices.asFuncMatrix((Func)this.operation.diffFunc, resultType, m);
        } else {
            Matrix difference = Matrices.asFuncMatrix((Func)this.operation.diffFunc, DoubleArray.class, m);
            result = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{this.multiplier}), resultType, (Matrix)difference);
        }
        double srcMaxValue = Arrays.maxPossibleValue(this.sampleType(), (double)1.0);
        double destMaxValue = Arrays.maxPossibleValue(resultType, (double)1.0);
        return srcMaxValue == destMaxValue ? result : Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{destMaxValue / srcMaxValue}), resultType, (Matrix)result);
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return !this.inputRequired;
    }

    static Matrix<? extends PArray> sumOfChannelsSquares(MultiMatrix matrix, boolean sqrtFromResult) {
        if (matrix.numberOfChannels() == 1) {
            return sqrtFromResult ? matrix.channel(0) : Matrices.asFuncMatrix((Func)SQR_FUNC, DoubleArray.class, matrix.channel(0));
        }
        LinearFunc sumFunc = LinearFunc.getInstance((double)0.0, (double[])DoubleStream.generate(() -> 1.0).limit(matrix.numberOfChannels()).toArray());
        MultiMatrix squares = matrix.apply(m -> Matrices.asFuncMatrix((Func)SQR_FUNC, DoubleArray.class, (Matrix)m));
        Matrix sum = Matrices.asFuncMatrix((Func)sumFunc, DoubleArray.class, squares.allChannels());
        return Matrices.clone((Matrix)(sqrtFromResult ? Matrices.asFuncMatrix((Func)SQRT_FUNC, DoubleArray.class, (Matrix)sum) : sum));
    }

    private Class<? extends PArray> resultType(Class<? extends PArray> sampleType) {
        return this.floatResult && !DoubleArray.class.isAssignableFrom(sampleType) ? FloatArray.class : sampleType;
    }

    private static /* synthetic */ Matrix lambda$process$0(Morphology morphology, Pattern pattern, Matrix m) {
        return morphology.dilation(m, pattern);
    }

    public static enum Operation {
        ABSOLUTE_DIFFERENCE(Func.ABS_DIFF),
        POSITIVE_DIFFERENCE(Func.POSITIVE_DIFF),
        SUBTRACT((Func)Func.X_MINUS_Y),
        REVERSE_SUBTRACT((Func)Func.Y_MINUS_X),
        RGB_DISTANCE(Func.ABS_DIFF);

        private final Func diffFunc;

        private Operation(Func diffFunc) {
            this.diffFunc = diffFunc;
        }
    }

    public static enum Postprocessing {
        NONE{

            @Override
            MultiMatrix postprocess(MultiMatrix result) {
                return result;
            }
        }
        ,
        CONTRAST{

            @Override
            MultiMatrix postprocess(MultiMatrix result) {
                return result.contrast();
            }
        }
        ,
        NONZERO_PIXELS{

            @Override
            MultiMatrix postprocess(MultiMatrix result) {
                return result.nonZeroPixels(false);
            }
        }
        ,
        ZERO_PIXELS{

            @Override
            MultiMatrix postprocess(MultiMatrix result) {
                return result.zeroPixels(false);
            }
        };


        abstract MultiMatrix postprocess(MultiMatrix var1);
    }
}

