/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.OptionalArguments;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public final class MatrixLinearCombination
extends SeveralMultiMatricesChannelOperation {
    private final Map<Integer, Double> a = new HashMap<Integer, Double>();
    private double b = 0.0;
    private boolean rawValues = false;
    private Class<?> elementType = null;

    public MatrixLinearCombination() {
        super(new String[0]);
    }

    public double getA(int index) {
        return this.a.getOrDefault(index, 0.0);
    }

    public MatrixLinearCombination setA(int index, double a) {
        this.a.put(index, a);
        return this;
    }

    public double getB() {
        return this.b;
    }

    public MatrixLinearCombination setB(double b) {
        this.b = b;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public MatrixLinearCombination setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public MatrixLinearCombination setElementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public MatrixLinearCombination setElementType(String elementType) {
        return this.setElementType(MultiMatrixGenerator.elementType(elementType, true));
    }

    @Override
    public void onChangeParameter(String name) {
        if (name.startsWith("a_")) {
            int index;
            try {
                index = Integer.parseInt(name.substring("a_".length())) - 1;
            }
            catch (NumberFormatException ignored) {
                return;
            }
            this.setA(index, this.parameters().getDouble(name));
            return;
        }
        super.onChangeParameter(name);
    }

    @Override
    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> m) {
        OptionalArguments<Matrix<? extends PArray>> arguments = new OptionalArguments<Matrix<? extends PArray>>(m);
        List<Matrix<? extends PArray>> mNonNull = arguments.extract();
        double[] aForNonNull = arguments.extractParallelDoubles(this.a, 1.0);
        Class requiredType = this.elementType != null ? Arrays.type(PArray.class, this.elementType) : this.sampleType();
        double scale = this.rawValues ? 1.0 : Arrays.maxPossibleValue((Class)requiredType, (double)1.0);
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)(scale * this.b), (double[])aForNonNull), (Class)requiredType, mNonNull));
    }
}

