/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.creation;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelGenerator;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public final class CreateBilinearFunction
extends MultiMatrixChannelGenerator {
    private String color = "#FFFFFF";
    private double cx2 = 0.0;
    private double cxy = 0.0;
    private double cy2 = 0.0;
    private double cx = 1.0;
    private double cy = 1.0;
    private double c = 0.0;
    private boolean sqrtOfResult = false;
    private double originX = 50.0;
    private double originY = 50.0;
    private boolean originInPercent = true;
    private boolean remainedOfDivisionByMaxValue = false;
    private boolean rawValues = false;

    public String getColor() {
        return this.color;
    }

    public CreateBilinearFunction setColor(String color) {
        this.color = CreateBilinearFunction.nonNull(color);
        return this;
    }

    public double getCx2() {
        return this.cx2;
    }

    public CreateBilinearFunction setCx2(double cx2) {
        this.cx2 = cx2;
        return this;
    }

    public double getCxy() {
        return this.cxy;
    }

    public CreateBilinearFunction setCxy(double cxy) {
        this.cxy = cxy;
        return this;
    }

    public double getCy2() {
        return this.cy2;
    }

    public CreateBilinearFunction setCy2(double cy2) {
        this.cy2 = cy2;
        return this;
    }

    public double getCx() {
        return this.cx;
    }

    public CreateBilinearFunction setCx(double cx) {
        this.cx = cx;
        return this;
    }

    public double getCy() {
        return this.cy;
    }

    public CreateBilinearFunction setCy(double cy) {
        this.cy = cy;
        return this;
    }

    public double getC() {
        return this.c;
    }

    public CreateBilinearFunction setC(double c) {
        this.c = c;
        return this;
    }

    public boolean isSqrtOfResult() {
        return this.sqrtOfResult;
    }

    public CreateBilinearFunction setSqrtOfResult(boolean sqrtOfResult) {
        this.sqrtOfResult = sqrtOfResult;
        return this;
    }

    public double getOriginX() {
        return this.originX;
    }

    public CreateBilinearFunction setOriginX(double originX) {
        this.originX = originX;
        return this;
    }

    public double getOriginY() {
        return this.originY;
    }

    public CreateBilinearFunction setOriginY(double originY) {
        this.originY = originY;
        return this;
    }

    public boolean isOriginInPercent() {
        return this.originInPercent;
    }

    public CreateBilinearFunction setOriginInPercent(boolean originInPercent) {
        this.originInPercent = originInPercent;
        return this;
    }

    public boolean isRemainedOfDivisionByMaxValue() {
        return this.remainedOfDivisionByMaxValue;
    }

    public CreateBilinearFunction setRemainedOfDivisionByMaxValue(boolean remainedOfDivisionByMaxValue) {
        this.remainedOfDivisionByMaxValue = remainedOfDivisionByMaxValue;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public CreateBilinearFunction setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    @Override
    protected Matrix<? extends PArray> createChannel() {
        Class destType = Arrays.type(PArray.class, this.getElementType());
        final double maxPossibleValue = Arrays.maxPossibleValue((Class)destType, (double)1.0);
        final double channelValue = this.colorChannel(this.color, this.rawValues ? 1.0 : maxPossibleValue);
        final double x0 = this.originInPercent ? this.originX * (double)this.getDimX() / 100.0 : this.originX;
        final double y0 = this.originInPercent ? this.originY * (double)this.getDimY() / 100.0 : this.originY;
        CreateBilinearFunction.logDebug(() -> "Creating bilinear " + String.valueOf(this.getElementType()) + "[" + this.getNumberOfChannels() + "x" + this.getDimX() + "x" + this.getDimY() + "], channel " + this.currentChannel() + ": channelValue " + channelValue);
        return Matrices.asCoordFuncMatrix((Func)new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0], x[1]);
            }

            public double get(double x, double y) {
                double v = (CreateBilinearFunction.this.cx2 * (x -= x0) + 2.0 * CreateBilinearFunction.this.cxy * (y -= y0) + CreateBilinearFunction.this.cx) * x + (CreateBilinearFunction.this.cy2 * y + CreateBilinearFunction.this.cy) * y + CreateBilinearFunction.this.c;
                double result = channelValue * (CreateBilinearFunction.this.sqrtOfResult ? StrictMath.sqrt(v) : v);
                return CreateBilinearFunction.this.remainedOfDivisionByMaxValue ? result % maxPossibleValue : result;
            }
        }, (Class)destType, (long[])new long[]{this.getDimX(), this.getDimY()});
    }
}

