/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.creation;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelGenerator;

public final class CreateConstantMatrix
extends MultiMatrixChannelGenerator {
    private String color = "#FFFFFF";

    public String getColor() {
        return this.color;
    }

    public CreateConstantMatrix setColor(String color) {
        this.color = CreateConstantMatrix.nonNull(color);
        return this;
    }

    @Override
    protected Matrix<? extends PArray> createChannel() {
        Class destType = Arrays.type(PArray.class, this.getElementType());
        double maxPossibleValue = Arrays.maxPossibleValue((Class)destType, (double)1.0);
        double value = this.colorChannel(this.color, maxPossibleValue);
        CreateConstantMatrix.logDebug(() -> "Creating constant " + String.valueOf(this.getElementType()) + "[" + this.getNumberOfChannels() + "x" + this.getDimX() + "x" + this.getDimY() + "], channel " + this.currentChannel() + ": filler " + value);
        return this.getDimZ() > 0L ? Matrices.constantMatrix((double)value, (Class)destType, (long[])new long[]{this.getDimX(), this.getDimY(), this.getDimZ()}) : Matrices.constantMatrix((double)value, (Class)destType, (long[])new long[]{this.getDimX(), this.getDimY()});
    }
}

