/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.drawing;

import java.util.Arrays;
import net.algart.executors.api.data.SNumbers;

public final class PositionsAndColors {
    final int xyBlockLength;
    final double[] xy;
    private final int colorBlockLength;
    private final int numberOfColors;
    private final float[] colorValues;
    private final double defaultColorValue;
    final int n;

    public PositionsAndColors(SNumbers positions, SNumbers colors, double defaultColorValue) {
        this(positions, colors, null, defaultColorValue, 2);
    }

    public PositionsAndColors(SNumbers positions, SNumbers colors, double[] defaultXYAndOthers, double defaultColorValue, int minBlockLength) {
        if (positions.isInitialized()) {
            this.xyBlockLength = positions.getBlockLength();
            if (this.xyBlockLength < minBlockLength) {
                throw new IllegalArgumentException("Positions must contain at least " + minBlockLength + " elements per block");
            }
            this.xy = positions.toDoubleArray();
            this.n = this.xy.length / this.xyBlockLength;
        } else {
            this.xyBlockLength = minBlockLength;
            this.xy = defaultXYAndOthers != null ? (double[])defaultXYAndOthers.clone() : new double[]{};
            this.n = 1;
        }
        if (colors.isInitialized()) {
            this.colorBlockLength = colors.getBlockLength();
            this.colorValues = colors.toFloatArray();
            this.numberOfColors = this.colorValues.length / this.colorBlockLength;
        } else {
            this.colorBlockLength = 1;
            this.colorValues = new float[0];
            this.numberOfColors = 0;
        }
        this.defaultColorValue = defaultColorValue;
    }

    public int n() {
        return this.n;
    }

    public double[] xyAndOthers(int index) {
        int disp = index * this.xyBlockLength;
        return Arrays.copyOfRange(this.xy, disp, disp + Math.min(4, this.xyBlockLength));
    }

    public float[] colorRGB(int index) {
        if (this.colorBlockLength < 3 || index >= this.numberOfColors) {
            return null;
        }
        int disp = index * this.colorBlockLength;
        return Arrays.copyOfRange(this.colorValues, disp, disp + 3);
    }

    public double x(int index) {
        return this.xy[index * this.xyBlockLength];
    }

    public double y(int index) {
        return this.xy[index * this.xyBlockLength + 1];
    }

    public double colorValue(int index, int channelIndex, double maxPossibleValue) {
        if (index >= this.numberOfColors) {
            return this.defaultColorValue;
        }
        if (channelIndex == 3 && this.colorBlockLength <= channelIndex) {
            return maxPossibleValue;
        }
        channelIndex = Math.min(channelIndex, this.colorBlockLength - 1);
        int disp = index * this.colorBlockLength + channelIndex;
        assert (disp < this.colorValues.length) : index + " * " + this.colorBlockLength + " + " + channelIndex + " >= " + this.colorValues.length;
        return (double)this.colorValues[disp] * maxPossibleValue;
    }
}

