/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.geometry;

import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;

public abstract class SubMatrixFilter
extends MultiMatrixChannelFilter {
    public static final String RECTANGULAR_AREA = "rectangular_area";
    private boolean percents = false;
    private double left = 0.0;
    private double top = 0.0;
    private double front = 0.0;
    private double right = 0.0;
    private double bottom = 0.0;
    private double rear = 0.0;
    private double width = 100.0;
    private double height = 100.0;
    private double depth = 100.0;

    public SubMatrixFilter() {
        this.addInputNumbers(RECTANGULAR_AREA);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public SubMatrixFilter setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getLeft() {
        return this.left;
    }

    public SubMatrixFilter setLeft(double left) {
        this.left = left;
        return this;
    }

    public double getTop() {
        return this.top;
    }

    public SubMatrixFilter setTop(double top) {
        this.top = top;
        return this;
    }

    public double getFront() {
        return this.front;
    }

    public SubMatrixFilter setFront(double front) {
        this.front = front;
        return this;
    }

    public double getRight() {
        return this.right;
    }

    public SubMatrixFilter setRight(double right) {
        this.right = right;
        return this;
    }

    public double getBottom() {
        return this.bottom;
    }

    public SubMatrixFilter setBottom(double bottom) {
        this.bottom = bottom;
        return this;
    }

    public double getRear() {
        return this.rear;
    }

    public SubMatrixFilter setRear(double rear) {
        this.rear = rear;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public SubMatrixFilter setWidth(double width) {
        this.width = SubMatrixFilter.nonNegative(width);
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public SubMatrixFilter setHeight(double height) {
        this.height = SubMatrixFilter.nonNegative(height);
        return this;
    }

    public double getDepth() {
        return this.depth;
    }

    public SubMatrixFilter setDepth(double depth) {
        this.depth = depth;
        return this;
    }

    public Matrix<? extends PArray> extractSubMatrix(Matrix<? extends PArray> m, Matrix.ContinuationMode continuationMode) {
        long dimX = m.dimX();
        long dimY = m.dimY();
        long dimZ = m.dimZ();
        IRectangularArea area = this.getInputNumbers(RECTANGULAR_AREA, true).toIRectangularArea();
        if (area != null) {
            if (area.coordCount() != m.dimCount()) {
                throw new IllegalArgumentException("Dimensions mismatch: rectangular area is " + area.coordCount() + "-dimensional, matrix is " + m.dimCount() + "-dimensional");
            }
            int coordCount = area.coordCount();
            IPoint to = area.max().add(IPoint.ofEqualCoordinates((int)coordCount, (long)1L));
            if (this.isOutputNecessary(RECTANGULAR_AREA)) {
                this.getNumbers(RECTANGULAR_AREA).setTo(area);
            }
            if (area.min().isOrigin() && to.equals((Object)IPoint.of((long[])m.dimensions()))) {
                this.logProcessing("whole area " + String.valueOf(m));
                return m;
            }
            this.logProcessing("submatrix in area " + String.valueOf(area) + " of " + String.valueOf(m));
            return m.subMatrix(area, continuationMode);
        }
        long x1 = Math.round(this.percents ? this.left / 100.0 * (double)Math.max(0L, dimX - 1L) : this.left);
        long x2 = Math.round(this.percents ? this.right / 100.0 * (double)Math.max(0L, dimX - 1L) : this.right);
        long y1 = Math.round(this.percents ? this.top / 100.0 * (double)Math.max(0L, dimY - 1L) : this.top);
        long y2 = Math.round(this.percents ? this.bottom / 100.0 * (double)Math.max(0L, dimY - 1L) : this.bottom);
        long z1 = Math.round(this.percents ? this.front / 100.0 * (double)Math.max(0L, dimZ - 1L) : this.front);
        long z2 = Math.round(this.percents ? this.rear / 100.0 * (double)Math.max(0L, dimZ - 1L) : this.rear);
        long sizeX = Math.round(this.percents ? this.width / 100.0 * (double)dimX : this.width);
        long sizeY = Math.round(this.percents ? this.height / 100.0 * (double)dimY : this.height);
        long sizeZ = Math.round(this.percents ? this.depth / 100.0 * (double)dimZ : this.depth);
        if (x2 < 0L) {
            x2 += dimX;
        }
        if (y2 < 0L) {
            y2 += dimY;
        }
        if (z2 < 0L) {
            z2 += dimZ;
        }
        if (sizeX > 0L) {
            x2 = Math.addExact(x1, sizeX) - 1L;
        }
        if (sizeY > 0L) {
            y2 = Math.addExact(y1, sizeY) - 1L;
        }
        if (sizeZ > 0L) {
            z2 = Math.addExact(z1, sizeZ) - 1L;
        }
        sizeX = x2 - x1 + 1L;
        sizeY = y2 - y1 + 1L;
        sizeZ = z2 - z1 + 1L;
        long[] sizes = m.dimensions();
        long[] from = new long[sizes.length];
        if (x2 < x1) {
            throw new IllegalArgumentException("Zero or negative sub-matrix X-size: " + x1 + ".." + x2);
        }
        from[0] = x1;
        sizes[0] = sizeX;
        if (from.length >= 2) {
            if (y2 < y1) {
                throw new IllegalArgumentException("Zero or negative sub-matrix Y-size: " + y1 + ".." + y2);
            }
            from[1] = y1;
            sizes[1] = sizeY;
        }
        if (from.length >= 3) {
            if (z2 < z1) {
                throw new IllegalArgumentException("Zero or negative sub-matrix Z-size: " + z1 + ".." + z2);
            }
            from[2] = z1;
            sizes[2] = sizeZ;
        }
        if (this.isOutputNecessary(RECTANGULAR_AREA)) {
            IPoint minPoint = IPoint.of((long[])from);
            IPoint maxPoint = minPoint.add(IPoint.of((long[])sizes)).addToAllCoordinates(-1L);
            this.getNumbers(RECTANGULAR_AREA).setTo(IRectangularArea.of((IPoint)minPoint, (IPoint)maxPoint));
        }
        if (x1 == 0L && y1 == 0L && z1 == 0L && sizeX == dimX && sizeY == dimY && sizeZ == dimZ) {
            this.logProcessing("whole " + String.valueOf(m));
            return m;
        }
        this.logProcessing(m.dimCount() >= 3 ? "submatrix " + sizeX + "x" + sizeY + "x" + sizeZ + " (" + x1 + ".." + x2 + " x " + y1 + ".." + y2 + " x " + z1 + ".." + z2 + ") of " + String.valueOf(m) : "submatrix " + sizeX + "x" + sizeY + " (" + x1 + ".." + x2 + " x " + y1 + ".." + y2 + ") of " + String.valueOf(m));
        return m.subMatr(from, sizes, continuationMode);
    }

    protected abstract void logProcessing(String var1);
}

