/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.awt.image.BufferedImage;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import javax.imageio.ImageWriteParam;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.io.MatrixIO;

public final class WriteImage
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    private boolean inputRequired = false;
    private boolean autoContrastBeforeWriting = false;
    private boolean convertAllElementTypesToByte = true;
    private Double quality = null;
    private String compressionType = "";

    public WriteImage() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
    }

    public static WriteImage getInstance() {
        return new WriteImage();
    }

    @Override
    public WriteImage setFile(String file) {
        super.setFile(file);
        return this;
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public WriteImage setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    public boolean isAutoContrastBeforeWriting() {
        return this.autoContrastBeforeWriting;
    }

    public WriteImage setAutoContrastBeforeWriting(boolean autoContrastBeforeWriting) {
        this.autoContrastBeforeWriting = autoContrastBeforeWriting;
        return this;
    }

    public boolean isConvertAllElementTypesToByte() {
        return this.convertAllElementTypesToByte;
    }

    public WriteImage setConvertAllElementTypesToByte(boolean convertAllElementTypesToByte) {
        this.convertAllElementTypesToByte = convertAllElementTypesToByte;
        return this;
    }

    public Double getQuality() {
        return this.quality;
    }

    public WriteImage setQuality(Double quality) {
        this.quality = quality;
        return this;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public WriteImage setCompressionType(String compressionType) {
        this.compressionType = WriteImage.nonNull(compressionType).trim();
        return this;
    }

    @Override
    public void process() {
        this.process(this.getInputMat(!this.inputRequired));
    }

    public void process(SMat inputMat) {
        if (inputMat.isInitialized()) {
            if (this.autoContrastBeforeWriting) {
                inputMat = inputMat.autoContrast();
            }
            try {
                this.writeImage(inputMat.toBufferedImage(this.convertAllElementTypesToByte));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public void writeImage(BufferedImage bufferedImage) throws IOException {
        Path file = this.completeFilePath();
        WriteImage.logDebug(() -> "Writing image " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + " to file " + String.valueOf(file.toAbsolutePath()));
        MatrixIO.writeBufferedImage((Path)file, (BufferedImage)bufferedImage, param -> this.setQuality((ImageWriteParam)param, file));
    }

    private void setQuality(ImageWriteParam param, Path file) {
        Object[] legalTypes;
        boolean hasCompression;
        String compressionType = this.compressionType;
        boolean bl = hasCompression = !compressionType.isEmpty();
        if (this.quality != null || hasCompression) {
            param.setCompressionMode(2);
            legalTypes = param.getCompressionTypes();
        } else {
            legalTypes = null;
        }
        if (hasCompression) {
            if (legalTypes == null) {
                throw new UnsupportedOperationException("Can't set compression type \"" + compressionType + "\": there is no allowed compression for the extension of the file " + String.valueOf(file));
            }
            if (Arrays.stream(legalTypes).noneMatch(compressionType::equals)) {
                throw new UnsupportedOperationException("Unknown compression type \"" + compressionType + "\"; you should select one of the following legal compressions: " + Arrays.toString(legalTypes));
            }
            param.setCompressionType(compressionType);
        }
        if (this.quality != null) {
            if (legalTypes != null && param.getCompressionType() == null) {
                if (legalTypes.length == 1) {
                    param.setCompressionType((String)legalTypes[0]);
                } else {
                    WriteImage.logDebug(() -> this.lambda$setQuality$2((String[])legalTypes, file));
                    return;
                }
            }
            param.setCompressionQuality(this.quality.floatValue());
        }
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT);
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    private /* synthetic */ String lambda$setQuality$2(String[] legalTypes, Path file) {
        return "Can't set compression quality to " + this.quality + ": there is no default compression type, you should manually select one of the following legal compressions: " + Arrays.toString(legalTypes) + ", allowed for the extension of the file " + String.valueOf(file);
    }
}

