/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.math.IRange;

public final class NumbersCartesianToPolar
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    public static final String INPUT_X_Y = "x_y";
    public static final String OUTPUT_R = "r";
    public static final String OUTPUT_FI = "fi";
    public static final String OUTPUT_R_FI = "r_fi";
    private AngleRange angleRange = AngleRange.MINUS_PI_PLUS_PI;
    private double angleMultiplier = 1.0;
    private double epsilonForLittleSquare = -1.0;
    private double angleForLittleSquare = 0.0;

    public NumbersCartesianToPolar() {
        super(INPUT_X, INPUT_Y, INPUT_X_Y);
        this.useVisibleResultParameter();
        this.setDefaultOutputNumbers(OUTPUT_R_FI);
        this.addOutputNumbers(OUTPUT_R);
        this.addOutputNumbers(OUTPUT_FI);
    }

    public AngleRange getAngleRange() {
        return this.angleRange;
    }

    public NumbersCartesianToPolar setAngleRange(AngleRange angleRange) {
        this.angleRange = NumbersCartesianToPolar.nonNull(angleRange);
        return this;
    }

    public double getAngleMultiplier() {
        return this.angleMultiplier;
    }

    public NumbersCartesianToPolar setAngleMultiplier(double angleMultiplier) {
        this.angleMultiplier = angleMultiplier;
        return this;
    }

    public double getEpsilonForLittleSquare() {
        return this.epsilonForLittleSquare;
    }

    public NumbersCartesianToPolar setEpsilonForLittleSquare(double epsilonForLittleSquare) {
        this.epsilonForLittleSquare = epsilonForLittleSquare;
        return this;
    }

    public double getAngleForLittleSquare() {
        return this.angleForLittleSquare;
    }

    public NumbersCartesianToPolar setAngleForLittleSquare(double angleForLittleSquare) {
        this.angleForLittleSquare = angleForLittleSquare;
        return this;
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        SNumbers x = sources.get(0);
        SNumbers y = sources.get(1);
        SNumbers xy = sources.get(2);
        if (xy != null) {
            xy.requireBlockLength(2, "x/y");
        }
        if (x != null) {
            x.requireInitialized(INPUT_X).requireBlockLength(1, INPUT_X);
        } else {
            x = NumbersCartesianToPolar.checkXY(xy, INPUT_X).columnRange(0, 1);
        }
        if (y != null) {
            y.requireInitialized(INPUT_Y).requireBlockLength(1, INPUT_Y);
        } else {
            y = NumbersCartesianToPolar.checkXY(xy, INPUT_Y).columnRange(1, 1);
        }
        float[] xArray = x.toFloatArray();
        float[] yArray = y.toFloatArray();
        SNumbers result = new SNumbers();
        if (this.isOutputNecessary(OUTPUT_R_FI)) {
            float[] rFi = this.magnitudeAndArctangent(xArray, yArray);
            result.setTo(rFi, 2);
            if (this.isOutputNecessary(OUTPUT_R)) {
                this.getNumbers(OUTPUT_R).replaceColumnRange(0, result, 0, 1);
            }
            if (this.isOutputNecessary(OUTPUT_FI)) {
                this.getNumbers(OUTPUT_FI).replaceColumnRange(0, result, 1, 1);
            }
        } else {
            if (this.isOutputNecessary(OUTPUT_R)) {
                this.getNumbers(OUTPUT_R).setTo(this.magnitude(xArray, yArray), 1);
            }
            if (this.isOutputNecessary(OUTPUT_FI)) {
                this.getNumbers(OUTPUT_FI).setTo(this.arctangent(xArray, yArray), 1);
            }
        }
        return result;
    }

    public float[] magnitude(float[] x, float[] y) {
        Objects.requireNonNull(x, "Null x");
        Objects.requireNonNull(y, "Null y");
        if (x.length != y.length) {
            throw new IllegalArgumentException("Different lengths of x and y");
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)x.length);
            for (i = block << 8; i < to; ++i) {
                double xValue = x[i];
                double yValue = y[i];
                result[i] = (float)Math.sqrt(xValue * xValue + yValue * yValue);
            }
        });
        return result;
    }

    public float[] arctangent(float[] x, float[] y) {
        Objects.requireNonNull(x, "Null x");
        Objects.requireNonNull(y, "Null y");
        if (x.length != y.length) {
            throw new IllegalArgumentException("Different lengths of x and y");
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)x.length);
            for (i = block << 8; i < to; ++i) {
                double xValue = x[i];
                double yValue = y[i];
                double arctangent = xValue * xValue + yValue * yValue <= this.epsilonForLittleSquare ? this.angleForLittleSquare : this.angleRange.correctAtan2(Math.atan2(yValue, xValue)) * this.angleMultiplier;
                result[i] = (float)arctangent;
            }
        });
        return result;
    }

    public float[] magnitudeAndArctangent(float[] x, float[] y) {
        Objects.requireNonNull(x, "Null x");
        Objects.requireNonNull(y, "Null y");
        if (x.length != y.length) {
            throw new IllegalArgumentException("Different lengths of x and y");
        }
        float[] result = new float[2 * x.length];
        IntStream.range(0, x.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int disp = 2 * i;
            int to = (int)Math.min((long)i + 256L, (long)x.length);
            for (i = block << 8; i < to; ++i) {
                double xValue = x[i];
                double yValue = y[i];
                double rSqr = xValue * xValue + yValue * yValue;
                double arctangent = rSqr <= this.epsilonForLittleSquare ? this.angleForLittleSquare : this.angleRange.correctAtan2(Math.atan2(yValue, xValue)) * this.angleMultiplier;
                result[disp++] = (float)Math.sqrt(rSqr);
                result[disp++] = (float)arctangent;
            }
        });
        return result;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return false;
    }

    @Override
    protected IRange selectedColumnRange(int inputIndex) {
        int start = this.getIndexInBlock(inputIndex);
        return IRange.of((long)start, (long)(inputIndex == 2 ? (long)(start + 1) : (long)start));
    }

    private static SNumbers checkXY(SNumbers xy, String xOrYName) {
        if (xy == null || !xy.isInitialized()) {
            throw new IllegalArgumentException("The \"x/y\" port has no initialized data, but they are required, because \"" + xOrYName + "\" is also empty");
        }
        return xy;
    }

    public static enum AngleRange {
        ZERO_2PI{

            @Override
            double correctAtan2(double atan2) {
                return atan2 < 0.0 ? atan2 + Math.PI * 2 : atan2;
            }
        }
        ,
        ZERO_2PI_AS_0_1{

            @Override
            double correctAtan2(double atan2) {
                double angle = atan2 * 0.15915494309189535;
                return angle < 0.0 ? angle + 1.0 : angle;
            }
        }
        ,
        MINUS_PI_PLUS_PI{

            @Override
            double correctAtan2(double atan2) {
                return atan2;
            }
        }
        ,
        MINUS_PI_PLUS_PI_AS_MINUS_HALF_PLUS_HALF{

            @Override
            double correctAtan2(double atan2) {
                return atan2 * 0.15915494309189535;
            }
        }
        ,
        MINUS_PI_PLUS_PI_AS_MINUS_1_PLUS_1{

            @Override
            double correctAtan2(double atan2) {
                return atan2 * 0.3183098861837907;
            }
        }
        ,
        MINUS_PI_PLUS_PI_AS_0_1{

            @Override
            double correctAtan2(double atan2) {
                return atan2 * 0.15915494309189535 + 0.5;
            }
        };

        private static final double MULTIPLIER = 0.15915494309189535;
        private static final double MULTIPLIER_2 = 0.3183098861837907;
        private static final double PI_2 = Math.PI * 2;

        abstract double correctAtan2(double var1);
    }
}

