/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.stream.IntStream;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class NumbersInRange
extends NumbersFilter
implements ReadOnlyExecutionInput {
    private Class<?> elementType = Float.TYPE;
    private double min = 0.0;
    private double max = Double.POSITIVE_INFINITY;
    private double trueValue = 1.0;
    private boolean addTrueValueToIndex = false;
    private double falseValue = 0.0;
    private boolean addFalseValueToIndex = false;
    private boolean invert = false;

    public Class<?> getElementType() {
        return this.elementType;
    }

    public NumbersInRange setElementType(Class<?> elementType) {
        this.elementType = NumbersInRange.nonNull(elementType, "element type");
        return this;
    }

    public NumbersInRange setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public double getMin() {
        return this.min;
    }

    public NumbersInRange setMin(double min) {
        this.min = min;
        return this;
    }

    public NumbersInRange setMin(String min) {
        this.min = NumbersInRange.doubleOrNegativeInfinity(min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public NumbersInRange setMax(double max) {
        this.max = max;
        return this;
    }

    public NumbersInRange setMax(String max) {
        this.max = NumbersInRange.doubleOrPositiveInfinity(max);
        return this;
    }

    public double getTrueValue() {
        return this.trueValue;
    }

    public NumbersInRange setTrueValue(double trueValue) {
        this.trueValue = trueValue;
        return this;
    }

    public boolean isAddTrueValueToIndex() {
        return this.addTrueValueToIndex;
    }

    public NumbersInRange setAddTrueValueToIndex(boolean addTrueValueToIndex) {
        this.addTrueValueToIndex = addTrueValueToIndex;
        return this;
    }

    public double getFalseValue() {
        return this.falseValue;
    }

    public NumbersInRange setFalseValue(double falseValue) {
        this.falseValue = falseValue;
        return this;
    }

    public boolean isAddFalseValueToIndex() {
        return this.addFalseValueToIndex;
    }

    public NumbersInRange setAddFalseValueToIndex(boolean addFalseValueToIndex) {
        this.addFalseValueToIndex = addFalseValueToIndex;
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public NumbersInRange setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    protected SNumbers processNumbers(SNumbers source) {
        float[] array = source.toFloatArray();
        double inValue = this.invert ? this.falseValue : this.trueValue;
        double outValue = this.invert ? this.trueValue : this.falseValue;
        boolean addIn = this.invert ? this.addFalseValueToIndex : this.addTrueValueToIndex;
        boolean addOut = this.invert ? this.addTrueValueToIndex : this.addFalseValueToIndex;
        IntStream.range(0, array.length).parallel().forEach(k -> {
            boolean inRange;
            double v = array[k];
            boolean bl = inRange = v >= this.min && v <= this.max;
            array[k] = inRange ? (float)(addIn ? (double)k + inValue : inValue) : (float)(addOut ? (double)k + outValue : outValue);
        });
        return SNumbers.ofArray(array, source.getBlockLength()).toPrecision(this.elementType);
    }
}

